/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.validators.InconsistentColumnsValidator;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.CellHelper;
import org.eclipse.birt.report.model.elements.ColumnHelper;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.TableColumn;
import org.eclipse.birt.report.model.elements.TableRow;
import org.eclipse.birt.report.model.elements.interfaces.IGridItemModel;
import org.eclipse.birt.report.model.elements.interfaces.ISupportThemeElement;
import org.eclipse.birt.report.model.elements.strategy.CopyPolicy;

public class GridItem
extends ReportItem
implements IGridItemModel,
ISupportThemeElement {
    private Map<Long, TableColumn> cachedColumn = null;

    public GridItem() {
        this.initSlots();
    }

    public GridItem(String theName) {
        super(theName);
        this.initSlots();
    }

    @Override
    public void apply(ElementVisitor visitor) {
        visitor.visitGrid(this);
    }

    @Override
    public String getElementName() {
        return "Grid";
    }

    @Override
    public DesignElementHandle getHandle(Module module) {
        return this.handle(module);
    }

    public GridHandle handle(Module module) {
        if (this.handle == null) {
            this.handle = new GridHandle(module, this);
        }
        return (GridHandle)this.handle;
    }

    @Override
    public ContainerSlot getSlot(int slot) {
        assert (slot >= 0 && slot < 2);
        return this.slots[slot];
    }

    public int getColumnCount(Module module) {
        int colCount = this.getColDefnCount(module);
        if (colCount != 0) {
            return colCount;
        }
        return this.findMaxCols(module);
    }

    public int getColDefnCount(Module module) {
        int colCount = 0;
        ContainerSlot cols = this.getSlot(0);
        int colDefnCount = cols.getCount();
        int i = 0;
        while (i < colDefnCount) {
            TableColumn col = (TableColumn)cols.getContent(i);
            colCount += col.getIntProperty(module, "repeat");
            ++i;
        }
        return colCount;
    }

    @Override
    public void cacheValues() {
        ContainerSlot columnSlot = this.getSlot(0);
        if (columnSlot.getCount() == 0) {
            return;
        }
        Module module = this.getRoot();
        this.cachedColumn = new HashMap<Long, TableColumn>();
        TableColumn[] cachedColumnArray = ColumnHelper.getTableColumnArray(module, columnSlot);
        ContainerSlot rowSlot = this.getSlot(1);
        List<Cell> list = CellHelper.getCells(rowSlot);
        int i = 0;
        while (i < list.size()) {
            Cell cell = list.get(i);
            int columnNum = this.getCellPositionInColumn(module, cell);
            assert (columnNum > 0);
            TableColumn column = ColumnHelper.getColumnInArray(cachedColumnArray, columnNum);
            if (column != null) {
                this.cachedColumn.put(cell.getID(), column);
            }
            ++i;
        }
    }

    public int findMaxCols(Module module) {
        ContainerSlot rows = this.getSlot(1);
        int maxCols = 0;
        int count = rows.getCount();
        int i = 0;
        while (i < count) {
            TableRow row = (TableRow)rows.getContent(i);
            int cols = row.getColumnCount(module);
            if (cols > maxCols) {
                maxCols = cols;
            }
            ++i;
        }
        return maxCols;
    }

    public TableColumn getColumn(Module module, ContainerSlot columnSlot, Cell target) {
        if (module.isCached()) {
            if (this.cachedColumn == null) {
                return null;
            }
            return this.cachedColumn.get(target.getID());
        }
        int columnNum = this.getCellPositionInColumn(module, target);
        assert (columnNum > 0);
        return ColumnHelper.findColumn(module, columnSlot, columnNum);
    }

    public int getCellPositionInColumn(Module module, Cell target) {
        int pos = target.getColumn(module);
        if (pos > 0) {
            return pos;
        }
        pos = 1;
        TableRow row = (TableRow)target.getContainer();
        List<DesignElement> list = row.getContentsSlot();
        for (Cell cell : list) {
            int cellPos = cell.getColumn(module);
            if (cellPos > 0) {
                pos = cellPos;
            }
            if (cell == target) break;
            pos += cell.getColSpan(module);
        }
        int cellRowNum = this.getRowNumber(row);
        ContainerSlot containerSlot = this.getSlot(1);
        int currRowNum = 0;
        while (currRowNum < containerSlot.getCount()) {
            TableRow currRow = (TableRow)containerSlot.getContent(currRowNum);
            if (row == currRow) break;
            List<DesignElement> cells = currRow.getContentsSlot();
            if (cells != null) {
                int maxSize = Math.min(pos, cells.size());
                int j = 0;
                while (j < maxSize) {
                    Cell cell = (Cell)cells.get(j);
                    if (cell.getRowSpan(module) + currRowNum >= cellRowNum) {
                        ++pos;
                    }
                    ++j;
                }
            }
            ++currRowNum;
        }
        return pos;
    }

    private int getRowNumber(TableRow row) {
        ContainerSlot rows = this.getSlot(1);
        int i = 0;
        while (i < rows.getCount()) {
            TableRow curr = (TableRow)rows.getContent(i);
            if (curr == row) {
                return ++i;
            }
            ++i;
        }
        return 0;
    }

    @Override
    public List<SemanticException> validate(Module module) {
        List<SemanticException> list = super.validate(module);
        list.addAll(InconsistentColumnsValidator.getInstance().validate(module, this));
        return list;
    }

    @Override
    public String getDisplayLabel(Module module, int level) {
        String displayLabel = super.getDisplayLabel(module, level);
        if (level == 2) {
            GridHandle handle = this.handle(module);
            int rows = handle.getRows().getCount();
            int cols = handle.getColumns().getCount();
            displayLabel = String.valueOf(displayLabel) + "(" + rows + " x " + cols + ")";
        }
        return displayLabel;
    }

    @Override
    public Object doClone(CopyPolicy policy) throws CloneNotSupportedException {
        GridItem clonedGrid = (GridItem)super.doClone(policy);
        clonedGrid.cachedColumn = null;
        return clonedGrid;
    }
}

