/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SortDirectionType implements Enumerator
{
    ASCENDING(0, "Ascending", "Ascending"),
    DESCENDING(1, "Descending", "Descending");

    public static final String copyright = "Copyright (c) 2009 Actuate Corporation";
    public static final int ASCENDING_VALUE = 0;
    public static final int DESCENDING_VALUE = 1;
    private static final SortDirectionType[] VALUES_ARRAY;
    public static final List<SortDirectionType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SortDirectionType[]{ASCENDING, DESCENDING};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SortDirectionType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SortDirectionType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SortDirectionType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SortDirectionType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SortDirectionType get(int value) {
        switch (value) {
            case 0: {
                return ASCENDING;
            }
            case 1: {
                return DESCENDING;
            }
        }
        return null;
    }

    private SortDirectionType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

