/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.birt.core.archive.cache.CacheListener;
import org.eclipse.birt.core.archive.cache.Cacheable;
import org.eclipse.birt.core.archive.cache.FileCacheManager;
import org.eclipse.birt.core.archive.compound.AllocEntry;
import org.eclipse.birt.core.archive.compound.AllocTable;
import org.eclipse.birt.core.archive.compound.ArchiveConstants;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;
import org.eclipse.birt.core.archive.compound.ArchiveEntryV2;
import org.eclipse.birt.core.archive.compound.ArchiveHeader;
import org.eclipse.birt.core.archive.compound.Block;
import org.eclipse.birt.core.archive.compound.IArchiveFile;
import org.eclipse.birt.core.archive.compound.NameEntry;
import org.eclipse.birt.core.archive.compound.NameTable;
import org.eclipse.birt.core.i18n.CoreMessages;

public class ArchiveFileV2
implements IArchiveFile,
ArchiveConstants {
    protected RandomAccessFile rf;
    protected boolean isClosed;
    protected boolean isWritable;
    protected boolean isTransient;
    protected boolean isAppend;
    protected String archiveName;
    protected String systemId;
    protected String dependId;
    protected int BLOCK_SIZE;
    protected ArchiveHeader head;
    protected AllocTable allocTbl;
    protected NameTable entryTbl;
    protected HashMap<String, NameEntry> entries;
    protected FileCacheManager caches;
    protected int totalBlocks;
    protected int totalDiskBlocks;

    private void setupArchiveMode(String mode) {
        if ("r".equals(mode)) {
            this.isWritable = false;
            this.isTransient = false;
            this.isAppend = false;
        } else if ("rw".equals(mode)) {
            this.isWritable = true;
            this.isTransient = false;
            this.isAppend = false;
        } else if ("rw+".equals(mode)) {
            this.isWritable = true;
            this.isTransient = false;
            this.isAppend = true;
        } else if ("rwt".equals(mode)) {
            this.isWritable = true;
            this.isTransient = true;
            this.isAppend = false;
        } else {
            throw new IllegalArgumentException();
        }
    }

    public ArchiveFileV2(String fileName, RandomAccessFile rf, String mode) throws IOException {
        this(null, null, fileName, rf, mode);
    }

    public ArchiveFileV2(String fileName, String mode) throws IOException {
        this(null, null, fileName, null, mode);
    }

    public ArchiveFileV2(String systemId, String fileName, String mode) throws IOException {
        this(systemId, null, fileName, null, mode);
    }

    public ArchiveFileV2(String systemId, String dependId, String fileName, String mode) throws IOException {
        this(systemId, dependId, fileName, null, mode);
    }

    public ArchiveFileV2(String systemId, String dependId, String fileName, RandomAccessFile rf, String mode) throws IOException {
        if (fileName == null || fileName.length() == 0) {
            throw new IOException(CoreMessages.getString("error.FileNameIsNull"));
        }
        File fd = new File(fileName);
        this.archiveName = fileName = fd.getCanonicalPath();
        this.rf = rf;
        this.systemId = systemId;
        this.dependId = dependId;
        this.caches = new FileCacheManager();
        this.caches.setCacheListener(new ArchiveFileV2CacheListener());
        this.setupArchiveMode(mode);
        if (this.isWritable && !this.isAppend) {
            this.createDocument();
        } else if (this.isWritable && this.isAppend) {
            if (!new File(fileName).exists()) {
                this.createDocument();
            } else {
                this.openDocument();
            }
        } else {
            this.openDocument();
        }
        this.isClosed = false;
    }

    @Override
    public void setCacheSize(long cacheSize) {
        long cacheBlocks = (cacheSize + (long)this.BLOCK_SIZE - 1L) / (long)this.BLOCK_SIZE;
        if (cacheBlocks > Integer.MAX_VALUE) {
            this.caches.setMaxCacheSize(Integer.MAX_VALUE);
        } else {
            this.caches.setMaxCacheSize((int)cacheBlocks);
        }
    }

    @Override
    public long getUsedCache() {
        return (long)this.caches.getUsedCacheSize() * (long)this.BLOCK_SIZE;
    }

    @Override
    public String getDependId() {
        return this.dependId;
    }

    @Override
    public String getSystemId() {
        if (this.systemId == null) {
            return this.archiveName;
        }
        return this.systemId;
    }

    private void openDocument() throws IOException {
        try {
            if (this.rf == null) {
                if (!this.isWritable) {
                    this.rf = new RandomAccessFile(this.archiveName, "r");
                } else {
                    this.ensureParentFolderCreated();
                    this.rf = new RandomAccessFile(this.archiveName, "rw");
                }
            }
            this.head = ArchiveHeader.read(this.rf);
            if (this.systemId == null) {
                this.systemId = this.head.systemId;
            }
            if (this.dependId == null) {
                this.dependId = this.head.dependId;
            }
            this.BLOCK_SIZE = this.head.blockSize;
            this.totalDiskBlocks = this.totalBlocks = (int)((this.rf.length() + (long)this.BLOCK_SIZE - 1L) / (long)this.BLOCK_SIZE);
            this.allocTbl = AllocTable.loadTable(this);
            this.entryTbl = NameTable.loadTable(this);
            this.entries = new HashMap();
            for (NameEntry nameEnt : this.entryTbl.listEntries()) {
                this.entries.put(nameEnt.getName(), nameEnt);
            }
        }
        catch (IOException ex) {
            if (this.rf != null) {
                this.rf.close();
                this.rf = null;
            }
            throw ex;
        }
    }

    private void createDocument() throws IOException {
        try {
            if (!this.isTransient) {
                this.ensureFileCreated();
                this.rf.setLength(0L);
            }
            this.BLOCK_SIZE = this.getDefaultBlockSize();
            this.totalBlocks = 3;
            this.totalDiskBlocks = 0;
            this.head = new ArchiveHeader(this.BLOCK_SIZE);
            this.head.flush(this);
            this.allocTbl = AllocTable.createTable(this);
            this.entryTbl = NameTable.createTable(this);
            this.entries = new HashMap();
        }
        catch (IOException ex) {
            if (this.rf != null) {
                this.rf.close();
                this.rf = null;
            }
            throw ex;
        }
    }

    @Override
    public String getName() {
        return this.archiveName;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.isWritable) {
            this.head.setStatus(-1);
            if (!this.isTransient) {
                this.flush();
            }
        }
        if (this.rf != null) {
            this.rf.close();
            this.rf = null;
        }
        if (this.isTransient) {
            new File(this.archiveName).delete();
        }
        if (this.caches != null) {
            this.caches.clear();
        }
        this.isClosed = true;
    }

    @Override
    public synchronized void flush() throws IOException {
        this.assertWritable();
        if (!this.isTransient) {
            this.head.flush(this);
            this.entryTbl.flush();
            this.allocTbl.flush();
            if (this.caches != null) {
                this.caches.touchAllCaches(new ArchiveFileV2CacheListener());
            }
        }
    }

    @Override
    public synchronized void save() throws IOException {
        this.assertWritable();
        if (this.isTransient) {
            this.isTransient = false;
        }
        this.flush();
    }

    @Override
    public synchronized void refresh() throws IOException {
        this.assertOpen();
        if (!this.isWritable) {
            this.totalDiskBlocks = this.totalBlocks = (int)((this.rf.length() + (long)this.BLOCK_SIZE - 1L) / (long)this.BLOCK_SIZE);
            this.head.refresh(this);
            this.allocTbl.refresh();
            this.entryTbl.refresh();
        }
    }

    @Override
    public synchronized boolean exists(String name) {
        return this.entries.containsKey(name);
    }

    @Override
    public long getLength() {
        return (long)this.BLOCK_SIZE * (long)this.totalBlocks;
    }

    @Override
    public synchronized ArchiveEntry openEntry(String name) throws IOException {
        NameEntry nameEnt = this.entries.get(name);
        if (nameEnt != null) {
            return new ArchiveEntryV2(this, nameEnt);
        }
        throw new FileNotFoundException(name);
    }

    @Override
    public synchronized List<String> listEntries(String namePattern) {
        ArrayList<String> list = new ArrayList<String>();
        for (String name : this.entries.keySet()) {
            if (namePattern != null && !name.startsWith(namePattern)) continue;
            list.add(name);
        }
        return list;
    }

    @Override
    public synchronized ArchiveEntry createEntry(String name) throws IOException {
        this.assertWritable();
        NameEntry nameEnt = this.entries.get(name);
        if (nameEnt != null) {
            ArchiveEntryV2 entry = new ArchiveEntryV2(this, nameEnt);
            entry.setLength(0L);
            return entry;
        }
        nameEnt = this.entryTbl.createEntry(name);
        this.entries.put(name, nameEnt);
        return new ArchiveEntryV2(this, nameEnt);
    }

    @Override
    public synchronized boolean removeEntry(String name) throws IOException {
        this.assertWritable();
        NameEntry nameEntry = this.entries.get(name);
        if (nameEntry != null) {
            AllocEntry allocEntry;
            this.entries.remove(name);
            this.entryTbl.removeEntry(nameEntry);
            int blockId = nameEntry.getBlock();
            if (blockId != -1 && (allocEntry = this.allocTbl.loadEntry(blockId)) != null) {
                this.allocTbl.removeEntry(allocEntry);
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized Object lockEntry(String name) throws IOException {
        this.assertOpen();
        NameEntry entry = this.entries.get(name);
        if (entry == null) {
            if (!this.isWritable) {
                throw new FileNotFoundException(name);
            }
            entry = this.entryTbl.createEntry(name);
            this.entries.put(name, entry);
        }
        return entry;
    }

    @Override
    public synchronized void unlockEntry(Object locker) throws IOException {
        this.assertOpen();
        if (!(locker instanceof NameEntry)) {
            throw new IOException(CoreMessages.getFormattedString("error.InvalidLockType", locker));
        }
    }

    int getTotalBlocks() {
        return this.totalBlocks;
    }

    int allocateBlock() throws IOException {
        this.assertWritable();
        return this.totalBlocks++;
    }

    private void assertWritable() throws IOException {
        this.assertOpen();
        if (!this.isWritable) {
            throw new IOException(CoreMessages.getFormattedString("error.ArchiveOpenForWrite", this.systemId));
        }
    }

    private void assertOpen() throws IOException {
        if (this.isClosed) {
            throw new IOException(CoreMessages.getString("error.FileHasBeenClosed"));
        }
    }

    synchronized int read(int blockId, int blockOff, byte[] b, int off, int len) throws IOException {
        int size;
        this.assertOpen();
        long pos = (long)blockId * (long)this.BLOCK_SIZE + (long)blockOff;
        int readSize = 0;
        this.rf.seek(pos);
        while ((size = this.rf.read(b, off + readSize, len - readSize)) >= 0 && (readSize += size) < len) {
        }
        return readSize;
    }

    synchronized void write(int blockId, int blockOff, byte[] b, int off, int len) throws IOException {
        this.assertWritable();
        this.ensureFileCreated();
        long pos = (long)blockId * (long)this.BLOCK_SIZE + (long)blockOff;
        this.rf.seek(pos);
        this.rf.write(b, off, len);
    }

    protected synchronized Block createBlock() throws IOException {
        int blockId = this.allocateBlock();
        Block block = new Block(this, blockId, this.BLOCK_SIZE);
        this.caches.addCache(block);
        return block;
    }

    protected synchronized void unloadBlock(Block block) throws IOException {
        this.caches.releaseCache(block);
    }

    synchronized Block loadBlock(int blockId) throws IOException {
        Integer cacheKey = blockId;
        Block block = (Block)this.caches.getCache(cacheKey);
        if (block == null) {
            block = new Block(this, blockId, this.BLOCK_SIZE);
            block.refresh();
            this.caches.addCache(block);
        }
        return block;
    }

    private void ensureFileCreated() throws IOException {
        if (this.rf != null) {
            return;
        }
        this.ensureParentFolderCreated();
        if (this.isWritable) {
            this.rf = new RandomAccessFile(this.archiveName, "rw");
            this.rf.setLength(0L);
        }
    }

    private void ensureParentFolderCreated() {
        File parentFile = new File(this.archiveName).getParentFile();
        if (parentFile != null && !parentFile.exists()) {
            parentFile.mkdirs();
        }
    }

    int getDefaultBlockSize() {
        String value = (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return System.getProperty("org.eclipse.birt.core.archive.compound.DEFAULT_BLOCK_SIZE");
            }
        });
        if (value != null) {
            try {
                int defaultBlockSize = Integer.parseInt(value);
                defaultBlockSize = (defaultBlockSize + 1023) / 1024 * 1024;
                if (defaultBlockSize > 0) {
                    return defaultBlockSize;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 4096;
    }

    static class ArchiveFileV2CacheListener
    implements CacheListener {
        ArchiveFileV2CacheListener() {
        }

        @Override
        public void onCacheRelease(Cacheable cache) {
            Block block = (Block)cache;
            try {
                block.flush();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

