/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.timefunction.ITimeFunction;
import org.eclipse.birt.data.engine.api.timefunction.ITimePeriod;
import org.eclipse.birt.data.engine.api.timefunction.ReferenceDate;
import org.eclipse.birt.data.engine.api.timefunction.TimeFunction;
import org.eclipse.birt.data.engine.api.timefunction.TimePeriod;
import org.eclipse.birt.data.engine.api.timefunction.TimePeriodType;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.document.ExprUtil;

public class BindingIOUtil {
    public static void saveBinding(DataOutputStream dos, IBinding binding, int version) throws DataException {
        int type = binding.getDataType();
        String name = binding.getBindingName();
        String function = binding.getAggrFunction();
        IBaseExpression expr = binding.getExpression();
        IBaseExpression filter = binding.getFilter();
        List arguments = binding.getArguments();
        List aggregateOn = binding.getAggregatOns();
        ITimeFunction timeFunction = binding.getTimeFunction();
        try {
            IOUtil.writeInt((OutputStream)dos, (int)type);
            IOUtil.writeString((DataOutputStream)dos, (String)name);
            IOUtil.writeString((DataOutputStream)dos, (String)function);
            ExprUtil.saveBaseExpr(dos, expr);
            ExprUtil.saveBaseExpr(dos, filter);
            IOUtil.writeInt((OutputStream)dos, (int)arguments.size());
            int i = 0;
            while (i < arguments.size()) {
                ExprUtil.saveBaseExpr(dos, (IBaseExpression)arguments.get(i));
                ++i;
            }
            IOUtil.writeInt((OutputStream)dos, (int)aggregateOn.size());
            i = 0;
            while (i < aggregateOn.size()) {
                IOUtil.writeString((DataOutputStream)dos, (String)aggregateOn.get(i).toString());
                ++i;
            }
            if (version >= 180) {
                if (timeFunction != null) {
                    IOUtil.writeBool((OutputStream)dos, (boolean)true);
                    IOUtil.writeString((DataOutputStream)dos, (String)timeFunction.getTimeDimension());
                    IOUtil.writeObject((DataOutputStream)dos, (Object)timeFunction.getReferenceDate().getDate());
                    ITimePeriod baseTimePeriod = timeFunction.getBaseTimePeriod();
                    ITimePeriod relativeTimePeriod = timeFunction.getRelativeTimePeriod();
                    if (baseTimePeriod != null) {
                        IOUtil.writeBool((OutputStream)dos, (boolean)true);
                        IOUtil.writeString((DataOutputStream)dos, (String)baseTimePeriod.getType().toString());
                        IOUtil.writeInt((OutputStream)dos, (int)baseTimePeriod.countOfUnit());
                        IOUtil.writeBool((OutputStream)dos, (boolean)baseTimePeriod.isCurrent());
                    } else {
                        IOUtil.writeBool((OutputStream)dos, (boolean)false);
                    }
                    if (relativeTimePeriod != null) {
                        IOUtil.writeBool((OutputStream)dos, (boolean)true);
                        IOUtil.writeObject((DataOutputStream)dos, (Object)relativeTimePeriod.getType().toString());
                        IOUtil.writeInt((OutputStream)dos, (int)relativeTimePeriod.countOfUnit());
                    } else {
                        IOUtil.writeBool((OutputStream)dos, (boolean)false);
                    }
                } else {
                    IOUtil.writeBool((OutputStream)dos, (boolean)false);
                }
            }
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
    }

    public static IBinding loadBinding(DataInputStream dis, int version) throws IOException, DataException {
        boolean hasTimeFunction;
        int type = IOUtil.readInt((InputStream)dis);
        String name = IOUtil.readString((DataInputStream)dis);
        String function = IOUtil.readString((DataInputStream)dis);
        IBaseExpression expr = ExprUtil.loadBaseExpr(dis);
        IBaseExpression filter = ExprUtil.loadBaseExpr(dis);
        Binding binding = new Binding(name);
        binding.setAggrFunction(function);
        binding.setDataType(type);
        binding.setExpression(expr);
        binding.setFilter(filter);
        int argSize = IOUtil.readInt((InputStream)dis);
        int i = 0;
        while (i < argSize) {
            binding.addArgument(ExprUtil.loadBaseExpr(dis));
            ++i;
        }
        int aggrSize = IOUtil.readInt((InputStream)dis);
        int i2 = 0;
        while (i2 < aggrSize) {
            binding.addAggregateOn(IOUtil.readString((DataInputStream)dis));
            ++i2;
        }
        if (version >= 180 && (hasTimeFunction = IOUtil.readBool((InputStream)dis))) {
            String timeDimensionName = IOUtil.readString((DataInputStream)dis);
            TimeFunction time = new TimeFunction();
            if (timeDimensionName != null) {
                boolean containsRelativePeriod;
                time.setTimeDimension(timeDimensionName);
                Date referenceDate = (Date)IOUtil.readObject((DataInputStream)dis);
                time.setReferenceDate(new ReferenceDate(referenceDate));
                boolean containsBasePeriod = IOUtil.readBool((InputStream)dis);
                if (containsBasePeriod) {
                    TimePeriodType periodType = BindingIOUtil.getPeriodType(IOUtil.readString((DataInputStream)dis));
                    int unit = IOUtil.readInt((InputStream)dis);
                    boolean isCurrent = IOUtil.readBool((InputStream)dis);
                    TimePeriod basedTimePeriod = new TimePeriod(unit, periodType, isCurrent);
                    time.setBaseTimePeriod(basedTimePeriod);
                }
                if (containsRelativePeriod = IOUtil.readBool((InputStream)dis)) {
                    TimePeriodType periodType = BindingIOUtil.getPeriodType(IOUtil.readString((DataInputStream)dis));
                    int unit = IOUtil.readInt((InputStream)dis);
                    TimePeriod relativeTimePeriod = new TimePeriod(unit, periodType);
                    time.setRelativeTimePeriod(relativeTimePeriod);
                }
            }
            binding.setTimeFunction(time);
        }
        return binding;
    }

    private static TimePeriodType getPeriodType(String type) {
        if (type == null) {
            return null;
        }
        if (type.equals(TimePeriodType.YEAR.toString())) {
            return TimePeriodType.YEAR;
        }
        if (type.equals(TimePeriodType.QUARTER.toString())) {
            return TimePeriodType.QUARTER;
        }
        if (type.equals(TimePeriodType.MONTH.toString())) {
            return TimePeriodType.MONTH;
        }
        if (type.equals(TimePeriodType.WEEK.toString())) {
            return TimePeriodType.WEEK;
        }
        if (type.equals(TimePeriodType.DAY.toString())) {
            return TimePeriodType.DAY;
        }
        return null;
    }
}

