/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.util;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Comparator;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;
import org.eclipse.birt.core.archive.compound.IArchiveFile;
import org.eclipse.birt.core.btree.BTree;
import org.eclipse.birt.core.btree.BTreeFile;
import org.eclipse.birt.core.btree.BTreeOption;
import org.eclipse.birt.core.btree.BTreeSerializer;
import org.eclipse.birt.core.util.IOUtil;

public class BTreeUtil {
    private static void checkDataType(int dataType) throws IOException {
        if (dataType != 2 || dataType != 3 || dataType != 6 || dataType != 9 || dataType != 10 || dataType != 4 || dataType != 5) {
            throw new IOException("unsupported datatype:" + dataType);
        }
    }

    public static BTree<Object, Integer> openBTree(IArchiveFile archive, String entryName, int dataType) throws IOException {
        BTreeUtil.checkDataType(dataType);
        BTreeOption btreeOption = new BTreeOption();
        BTreeUtil.setupBTreeOption((BTreeOption<Object, Integer>)btreeOption, dataType);
        btreeOption.setFile((BTreeFile)new ArchiveTreeFile(archive, entryName));
        return new BTree(btreeOption);
    }

    public static BTree<Object, Integer> createBTree(IArchiveFile archive, String entryName, int dataType) throws IOException {
        BTreeUtil.checkDataType(dataType);
        if (archive.exists(entryName)) {
            archive.removeEntry(entryName);
        }
        BTreeOption btreeOption = new BTreeOption();
        BTreeUtil.setupBTreeOption((BTreeOption<Object, Integer>)btreeOption, dataType);
        btreeOption.setFile((BTreeFile)new ArchiveTreeFile(archive, entryName));
        return new BTree(btreeOption);
    }

    public static BTree<Object, Integer> openBTree(IDocArchiveReader reader, String entryName, int dataType) throws IOException {
        BTreeUtil.checkDataType(dataType);
        BTreeOption btreeOption = new BTreeOption();
        BTreeUtil.setupBTreeOption((BTreeOption<Object, Integer>)btreeOption, dataType);
        btreeOption.setFile((BTreeFile)new ReaderTreeFile(reader, entryName));
        return new BTree(btreeOption);
    }

    public static BTree<Object, Integer> openBTree(IDocArchiveWriter writer, String entryName, int dataType) throws IOException {
        BTreeUtil.checkDataType(dataType);
        BTreeOption btreeOption = new BTreeOption();
        BTreeUtil.setupBTreeOption((BTreeOption<Object, Integer>)btreeOption, dataType);
        btreeOption.setFile((BTreeFile)new WriterTreeFile(writer, entryName));
        return new BTree(btreeOption);
    }

    public static BTree<Object, Integer> createBTree(IDocArchiveWriter writer, String entryName, int dataType) throws IOException {
        BTreeUtil.checkDataType(dataType);
        if (writer.exists(entryName)) {
            writer.dropStream(entryName);
        }
        BTreeOption btreeOption = new BTreeOption();
        BTreeUtil.setupBTreeOption((BTreeOption<Object, Integer>)btreeOption, dataType);
        btreeOption.setFile((BTreeFile)new WriterTreeFile(writer, entryName));
        return new BTree(btreeOption);
    }

    static void setupBTreeOption(BTreeOption<Object, Integer> option, int type) {
        option.setValueSize(4);
        option.setValueSerializer((BTreeSerializer)new IntSerializer());
        option.setAllowDuplicate(true);
        int keySize = BTreeUtil.getKeySize(type);
        if (keySize != -1) {
            option.setKeySize(keySize);
        }
        option.setKeySerializer((BTreeSerializer)new KeySerializer(type));
        option.setComparator((Comparator)new KeyComparator());
    }

    static int getKeySize(int dataType) {
        switch (dataType) {
            case 2: {
                return 4;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: {
                return 8;
            }
            case 4: 
            case 5: {
                return -1;
            }
        }
        return -1;
    }

    private static class ArchiveTreeFile
    implements BTreeFile {
        protected IArchiveFile af;
        protected String name;
        protected ArchiveEntry rf;
        protected int totalBlock;

        ArchiveTreeFile(IArchiveFile archive, String entryName) throws IOException {
            this.af = archive;
            this.name = entryName;
            this.rf = archive.exists(entryName) ? archive.openEntry(entryName) : archive.createEntry(entryName);
            this.totalBlock = (int)((this.rf.getLength() + 4096L - 1L) / 4096L);
        }

        public void close() throws IOException {
            this.rf.close();
        }

        public int allocBlock() throws IOException {
            return this.totalBlock++;
        }

        public int getTotalBlock() throws IOException {
            return this.totalBlock;
        }

        public Object lock() throws IOException {
            return this.af.lockEntry(this.name);
        }

        public void readBlock(int block, byte[] bytes) throws IOException {
            this.rf.read((long)block * 4096L, bytes, 0, bytes.length);
        }

        public void unlock(Object lock) throws IOException {
            this.af.unlockEntry(lock);
        }

        public void writeBlock(int block, byte[] bytes) throws IOException {
            if (block >= this.totalBlock) {
                this.totalBlock = block + 1;
            }
            this.rf.write((long)block * 4096L, bytes, 0, bytes.length);
        }
    }

    private static class IntSerializer
    implements BTreeSerializer<Integer> {
        private IntSerializer() {
        }

        public byte[] getBytes(Integer value) throws IOException {
            byte[] bytes = new byte[4];
            IOUtil.integerToBytes(value, bytes);
            return bytes;
        }

        public Integer getObject(byte[] bytes) throws IOException, ClassNotFoundException {
            return IOUtil.bytesToInteger(bytes);
        }
    }

    private static class KeyComparator
    implements Comparator<Object>,
    Serializable {
        private static final long serialVersionUID = 486084009828701292L;

        private KeyComparator() {
        }

        @Override
        public int compare(Object v1, Object v2) {
            if (v1 == v2) {
                return 0;
            }
            if (v1 == null) {
                return -1;
            }
            if (v2 == null) {
                return 1;
            }
            return ((Comparable)v1).compareTo(v2);
        }
    }

    private static class KeySerializer
    implements BTreeSerializer<Object> {
        static final String UTF_8 = "utf-8";
        int dataType;

        KeySerializer(int type) {
            this.dataType = type;
        }

        public byte[] getBytes(Object value) throws IOException {
            switch (this.dataType) {
                case 2: {
                    byte[] bytes = new byte[4];
                    IOUtil.integerToBytes((Integer)value, bytes);
                    return bytes;
                }
                case 3: {
                    byte[] bytes = new byte[8];
                    long v = Double.doubleToLongBits((Double)value);
                    IOUtil.longToBytes(v, bytes);
                    return bytes;
                }
                case 6: 
                case 9: 
                case 10: {
                    byte[] bytes = new byte[8];
                    long time = ((java.util.Date)value).getTime();
                    IOUtil.longToBytes(time, bytes);
                    return bytes;
                }
                case 4: {
                    String dec = ((BigDecimal)value).toString();
                    return dec.getBytes(UTF_8);
                }
                case 5: {
                    return ((String)value).getBytes(UTF_8);
                }
            }
            throw new IOException("unsupported data type");
        }

        public Object getObject(byte[] bytes) throws IOException, ClassNotFoundException {
            switch (this.dataType) {
                case 2: {
                    return IOUtil.bytesToInteger(bytes);
                }
                case 3: {
                    return Double.longBitsToDouble(IOUtil.bytesToLong(bytes));
                }
                case 6: {
                    return new Timestamp(IOUtil.bytesToLong(bytes));
                }
                case 9: {
                    return new Date(IOUtil.bytesToLong(bytes));
                }
                case 10: {
                    return new Time(IOUtil.bytesToLong(bytes));
                }
                case 4: {
                    return new BigDecimal(new String(bytes, UTF_8));
                }
                case 5: {
                    return new String(bytes, UTF_8);
                }
            }
            throw new IOException("unsupported data type");
        }
    }

    public static class ReaderTreeFile
    implements BTreeFile {
        private IDocArchiveReader archive;
        private String name;
        private RAInputStream input;
        private int totalBlock;

        ReaderTreeFile(IDocArchiveReader archive, String name) throws IOException {
            this.archive = archive;
            this.name = name;
            this.input = archive.getInputStream(name);
            this.totalBlock = (int)((this.input.length() + 4096L - 1L) / 4096L);
        }

        public int allocBlock() throws IOException {
            throw new IOException("read only stream");
        }

        public int getTotalBlock() throws IOException {
            return this.totalBlock;
        }

        public Object lock() throws IOException {
            return this.archive.lock(this.name);
        }

        public void readBlock(int blockId, byte[] bytes) throws IOException {
            this.input.refresh();
            this.input.seek((long)blockId * 4096L);
            this.input.read(bytes);
        }

        public void unlock(Object lock) throws IOException {
            this.archive.unlock(lock);
        }

        public void writeBlock(int blockId, byte[] bytes) throws IOException {
            throw new IOException("read only stream");
        }

        public void close() throws IOException {
            this.input.close();
        }
    }

    private static class WriterTreeFile
    implements BTreeFile {
        private IDocArchiveWriter archive;
        private String name;
        private RAOutputStream output;
        private RAInputStream input;
        private int totalBlock;

        WriterTreeFile(IDocArchiveWriter archive, String name) throws IOException {
            this.archive = archive;
            this.name = name;
            if (archive.exists(name)) {
                this.output = archive.getOutputStream(name);
                this.input = archive.getInputStream(name);
            } else {
                this.output = archive.createOutputStream(name);
                this.input = archive.getInputStream(name);
            }
            this.totalBlock = (int)((this.output.length() + 4096L - 1L) / 4096L);
        }

        public void close() throws IOException {
            if (this.output != null) {
                this.output.close();
            }
            if (this.input != null) {
                this.input.close();
            }
        }

        public int allocBlock() throws IOException {
            return this.totalBlock++;
        }

        public int getTotalBlock() throws IOException {
            return this.totalBlock;
        }

        public Object lock() throws IOException {
            return this.archive.lock(this.name);
        }

        public void readBlock(int blockId, byte[] bytes) throws IOException {
            this.input.refresh();
            this.input.seek((long)blockId * 4096L);
            this.input.read(bytes);
        }

        public void unlock(Object lock) throws IOException {
            this.archive.unlock(lock);
        }

        public void writeBlock(int blockId, byte[] bytes) throws IOException {
            if (blockId >= this.totalBlock) {
                this.totalBlock = blockId + 1;
            }
            this.output.seek((long)blockId * 4096L);
            this.output.write(bytes);
            this.output.flush();
        }
    }
}

