/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui.views.attributes.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.birt.chart.reportitem.ChartReportItemUtil;
import org.eclipse.birt.chart.reportitem.api.ChartCubeUtil;
import org.eclipse.birt.chart.reportitem.api.ChartReportItemHelper;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.DataSetBindingSelector;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.BindingGroupDescriptorProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.LinkedDataSetAdapter;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.jface.dialogs.MessageDialog;

public class ChartBindingGroupDescriptorProvider
extends BindingGroupDescriptorProvider {
    private static final String DATA_CUBES_DEFAULT = org.eclipse.birt.chart.reportitem.ui.i18n.Messages.getString("ChartBindingGroupDescriptorProvider.DataCubes.Default");
    private static final String DATA_SETS_DEFAULT = org.eclipse.birt.chart.reportitem.ui.i18n.Messages.getString("ChartBindingGroupDescriptorProvider.DataSets.Default");

    protected List<ReportItemHandle> getAvailableDataBindingReferenceList(ReportItemHandle element) {
        List availableList = element.getNamedDataBindingReferenceList();
        ArrayList<ReportItemHandle> referenceList = new ArrayList<ReportItemHandle>();
        for (ReportItemHandle handle : availableList) {
            String extensionName;
            if (handle instanceof ExtendedItemHandle && !ChartReportItemUtil.isAvailableExtensionToReferenceDataBinding((String)(extensionName = ((ExtendedItemHandle)handle).getExtensionName()))) continue;
            referenceList.add(handle);
        }
        return referenceList;
    }

    public Object load() {
        String value;
        ReportItemHandle element = this.getReportItemHandle();
        boolean isNotDataModel = false;
        int type = element.getDataBindingType();
        List<ReportItemHandle> referenceList = this.getAvailableDataBindingReferenceList(element);
        String[] references = new String[referenceList.size() + 1];
        references[0] = NONE;
        int i = 0;
        while (i < referenceList.size()) {
            references[i + 1] = referenceList.get(i).getQualifiedName();
            ++i;
        }
        this.setReferences(references);
        switch (type) {
            case 1: {
                DataSetHandle dataset = ChartReportItemHelper.instance().getBindingDataSetHandle(element);
                CubeHandle cube = ChartReportItemHelper.instance().getBindingCubeHandle(element);
                if (dataset == null && cube == null) {
                    value = NullDatasetChoice.getBindingValue();
                    isNotDataModel = true;
                    break;
                }
                if (dataset != null) {
                    List datasets = element.getModuleHandle().getAllDataSets();
                    if (datasets != null) {
                        int i2 = 0;
                        while (i2 < datasets.size()) {
                            if (datasets.get(i2) == dataset) {
                                isNotDataModel = true;
                                break;
                            }
                            ++i2;
                        }
                    }
                    value = dataset.getQualifiedName();
                    break;
                }
                List cubes = element.getModuleHandle().getAllCubes();
                if (cubes != null) {
                    int i3 = 0;
                    while (i3 < cubes.size()) {
                        if (cubes.get(i3) == cube) {
                            isNotDataModel = true;
                            break;
                        }
                        ++i3;
                    }
                }
                value = cube.getName();
                break;
            }
            case 2: {
                ReportItemHandle reference = element.getDataBindingReference();
                if (reference == null) {
                    value = NONE;
                    break;
                }
                value = reference.getQualifiedName();
                break;
            }
            default: {
                value = NullDatasetChoice.getBindingValue();
                isNotDataModel = true;
            }
        }
        BindingGroupDescriptorProvider.BindingInfo info = new BindingGroupDescriptorProvider.BindingInfo(type, value, isNotDataModel);
        if (ChartReportItemUtil.isChildOfMultiViewsHandle((DesignElementHandle)this.getReportItemHandle())) {
            String name = element.getContainer().getContainer().getQualifiedName();
            info.setBindingType(2);
            name = name == null ? NONE : name;
            info.setBindingValue(name);
            info.setReadOnly(true);
        }
        if (ChartCubeUtil.isPlotChart((DesignElementHandle)element) || ChartCubeUtil.isAxisChart((DesignElementHandle)element)) {
            info.setBindingType(2);
            info.setReadOnly(true);
        }
        return info;
    }

    public void save(Object saveValue) throws SemanticException {
        if (saveValue instanceof BindingGroupDescriptorProvider.BindingInfo) {
            BindingGroupDescriptorProvider.BindingInfo info = (BindingGroupDescriptorProvider.BindingInfo)saveValue;
            int type = info.getBindingType();
            String value = info.getBindingValue().toString();
            block0 : switch (type) {
                case 1: {
                    if (value.equals(NONE)) {
                        value = null;
                    } else if (value.equals(DATA_SETS_DEFAULT)) {
                        value = ChoiceSetFactory.getDataSets()[0];
                    } else if (value.equals(DATA_CUBES_DEFAULT)) {
                        value = ChoiceSetFactory.getCubes()[0];
                    }
                    int ret = 0;
                    if (!NONE.equals(((BindingGroupDescriptorProvider.BindingInfo)this.load()).getBindingValue().toString()) || this.getReportItemHandle().getColumnBindings().iterator().hasNext()) {
                        MessageDialog prefDialog = new MessageDialog(UIUtil.getDefaultShell(), Messages.getString((String)"dataBinding.title.changeDataSet"), null, Messages.getString((String)"dataBinding.message.changeDataSet"), 2, new String[]{Messages.getString((String)"AttributeView.dialg.Message.Yes"), Messages.getString((String)"AttributeView.dialg.Message.No"), Messages.getString((String)"AttributeView.dialg.Message.Cancel")}, 0);
                        ret = prefDialog.open();
                    }
                    switch (ret) {
                        case 0: {
                            if (this.getAvailableDatasets().contains(value)) {
                                this.resetDataSetReference(value, info, true);
                                break;
                            }
                            this.resetCubeReference(value, true);
                            break;
                        }
                        case 1: {
                            if (this.getAvailableDatasets().contains(value)) {
                                this.resetDataSetReference(value, info, false);
                                break;
                            }
                            this.resetCubeReference(value, false);
                            break;
                        }
                        case 2: {
                            this.section.load();
                        }
                    }
                    break;
                }
                case 2: {
                    if (value.equals(NONE)) {
                        value = null;
                    }
                    int ret1 = 0;
                    if (!NONE.equals(((BindingGroupDescriptorProvider.BindingInfo)this.load()).getBindingValue().toString()) || this.getReportItemHandle().getColumnBindings().iterator().hasNext()) {
                        MessageDialog prefDialog = new MessageDialog(UIUtil.getDefaultShell(), Messages.getString((String)"dataBinding.title.changeDataSet"), null, Messages.getString((String)"dataBinding.message.changeDataSet"), 2, new String[]{Messages.getString((String)"AttributeView.dialg.Message.Yes"), Messages.getString((String)"AttributeView.dialg.Message.Cancel")}, 0);
                        ret1 = prefDialog.open();
                    }
                    switch (ret1) {
                        case 0: {
                            this.resetReference(value, true);
                            break block0;
                        }
                        case 1: {
                            this.section.load();
                        }
                    }
                }
            }
        }
    }

    private void resetCubeReference(Object value, boolean clearHistory) {
        try {
            this.startTrans("");
            CubeHandle cubeHandle = null;
            if (value != null) {
                cubeHandle = SessionHandleAdapter.getInstance().getReportDesignHandle().findCube(value.toString());
            }
            if (this.getReportItemHandle().getDataBindingType() == 2) {
                this.getReportItemHandle().setDataBindingReference(null);
            }
            this.getReportItemHandle().setDataSet(null);
            if (cubeHandle == null && value != null) {
                this.getReportItemHandle().setDataSet(null);
                new LinkedDataSetAdapter().setLinkedDataModel(this.getReportItemHandle(), value);
            } else {
                new LinkedDataSetAdapter().setLinkedDataModel(this.getReportItemHandle(), null);
                this.getReportItemHandle().setCube(cubeHandle);
            }
            this.getReportItemHandle().setCube(cubeHandle);
            if (clearHistory) {
                this.getReportItemHandle().getColumnBindings().clearValue();
                this.getReportItemHandle().getPropertyHandle("paramBindings").clearValue();
            }
            this.commit();
        }
        catch (SemanticException e) {
            this.rollback();
            ExceptionHandler.handle((Throwable)e);
        }
        this.section.load();
    }

    private List getAvailableDatasets() {
        return Arrays.asList(ChoiceSetFactory.getDataSets());
    }

    public BindingGroupDescriptorProvider.BindingInfo[] getAvailableDatasetItems() {
        int i;
        ModuleHandle handle = SessionHandleAdapter.getInstance().getReportDesignHandle();
        List dataSets = UIUtil.getVisibleDataSetHandles((ModuleHandle)handle);
        List cubes = handle.getVisibleCubes();
        int length = 1;
        if (dataSets.size() > 0) {
            length += dataSets.size() + 1;
        }
        if (cubes.size() > 0) {
            length += cubes.size() + 1;
        }
        BindingGroupDescriptorProvider.BindingInfo[] newList = new BindingGroupDescriptorProvider.BindingInfo[length];
        newList[0] = NullDatasetChoice;
        if (dataSets.size() > 0) {
            newList[1] = new BindingGroupDescriptorProvider.BindingInfo(1, DATA_SETS_DEFAULT, true);
            i = 0;
            while (i < dataSets.size()) {
                DataSetHandle dataSet = (DataSetHandle)dataSets.get(i);
                newList[i + 2] = handle.findDataSet(dataSet.getQualifiedName()) == dataSet ? new BindingGroupDescriptorProvider.BindingInfo(1, dataSet.getQualifiedName(), true) : new BindingGroupDescriptorProvider.BindingInfo(1, dataSet.getQualifiedName(), false);
                ++i;
            }
        }
        if (cubes.size() > 0) {
            newList[newList.length - cubes.size() - 1] = new BindingGroupDescriptorProvider.BindingInfo(1, DATA_CUBES_DEFAULT, true);
            i = 0;
            while (i < cubes.size()) {
                CubeHandle cube = (CubeHandle)cubes.get(i);
                newList[i + newList.length - cubes.size()] = new BindingGroupDescriptorProvider.BindingInfo(1, cube.getQualifiedName(), true);
                ++i;
            }
        }
        return newList;
    }

    private void resetDataSetReference(Object value, BindingGroupDescriptorProvider.BindingInfo info, boolean clearHistory) {
        try {
            this.startTrans("");
            this.getReportItemHandle().setDataBindingReference(null);
            DataSetHandle dataSet = null;
            if (value != null && info != null && info.isDataSet()) {
                dataSet = SessionHandleAdapter.getInstance().getReportDesignHandle().findDataSet(value.toString());
            }
            if (this.getReportItemHandle().getDataBindingType() == 2) {
                this.getReportItemHandle().setDataBindingReference(null);
            }
            this.getReportItemHandle().setCube(null);
            boolean isExtendedDataModel = false;
            if (dataSet == null && value != null) {
                this.getReportItemHandle().setDataSet(null);
                isExtendedDataModel = new LinkedDataSetAdapter().setLinkedDataModel(this.getReportItemHandle(), value);
            } else {
                new LinkedDataSetAdapter().setLinkedDataModel(this.getReportItemHandle(), null);
                this.getReportItemHandle().setDataSet(dataSet);
            }
            if (clearHistory) {
                this.getReportItemHandle().getColumnBindings().clearValue();
                this.getReportItemHandle().getPropertyHandle("paramBindings").clearValue();
            }
            if (info != null) {
                DataSetBindingSelector selector = new DataSetBindingSelector(UIUtil.getDefaultShell(), isExtendedDataModel ? Messages.getString((String)"BindingGroupDescriptorProvider.DataSetBindingSelector.Title.LinkModel") : Messages.getString((String)"BindingGroupDescriptorProvider.DataSetBindingSelector.Title.DataSet"));
                selector.setDataSet(info.getBindingValue(), info.isDataSet());
                if (selector.open() == 0) {
                    Object[] columns = (Object[])((Object[])selector.getResult())[1];
                    this.getDependedProvider().generateBindingColumns(columns);
                }
            }
            this.commit();
        }
        catch (SemanticException e) {
            this.rollback();
            ExceptionHandler.handle((Throwable)e);
        }
        this.section.load();
    }

    private void resetReference(Object value, boolean clearHistory) {
        if (value == null && this.getReportItemHandle().getDataBindingType() == 1) {
            this.resetDataSetReference(null, null, true);
        } else {
            try {
                this.startTrans("");
                ReportItemHandle element = null;
                if (value != null) {
                    element = (ReportItemHandle)SessionHandleAdapter.getInstance().getReportDesignHandle().findElement(value.toString());
                }
                this.getReportItemHandle().setDataBindingReference(element);
                this.commit();
            }
            catch (SemanticException e) {
                this.rollback();
                ExceptionHandler.handle((Throwable)e);
            }
            this.section.load();
        }
    }

    public String getText(int key) {
        switch (key) {
            case 0: {
                return org.eclipse.birt.chart.reportitem.ui.i18n.Messages.getString("BindingPage.Data.Label");
            }
            case 1: {
                return Messages.getString((String)"parameterBinding.title");
            }
            case 2: {
                return Messages.getString((String)"BindingPage.ReportItem.Label");
            }
        }
        return "";
    }

    public boolean enableBindingButton() {
        return this.getAvailableDatasets().contains(((BindingGroupDescriptorProvider.BindingInfo)this.load()).getBindingValue());
    }
}

