/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.completion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.acceleo.AcceleoASTNode;
import org.eclipse.acceleo.Error;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.aql.completion.AcceleoAstCompletor;
import org.eclipse.acceleo.aql.completion.proposals.AcceleoCompletionProposal;
import org.eclipse.acceleo.aql.parser.AcceleoAstResult;
import org.eclipse.acceleo.aql.parser.AcceleoParser;
import org.eclipse.acceleo.aql.validation.AcceleoValidator;
import org.eclipse.acceleo.aql.validation.IAcceleoValidationResult;
import org.eclipse.acceleo.query.runtime.impl.QueryCompletionEngine;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameQueryEnvironment;

public class AcceleoCompletor {
    private static final String TO_COMPLETION_NAMESPACE = "_reserved_::to::completion";
    private String newLine;

    public AcceleoCompletor(String newLine) {
        this.newLine = newLine;
    }

    public List<AcceleoCompletionProposal> getProposals(IQualifiedNameQueryEnvironment queryEnvironment, String moduleFileName, String source, int position) {
        List<AcceleoCompletionProposal> proposals;
        String moduleQualifiedNameForCompletion = "_reserved_::to::completion::" + moduleFileName;
        AcceleoParser acceleoParser = new AcceleoParser();
        String remaining = QueryCompletionEngine.getRemaining((String)source, (int)position);
        String partialAcceleoSource = source.substring(0, position + remaining.length());
        AcceleoAstResult partialAcceleoAstResult = acceleoParser.parse(partialAcceleoSource.substring(0, position), null, moduleQualifiedNameForCompletion);
        AcceleoAstResult acceleoAstResult = acceleoParser.parse(source, null, moduleQualifiedNameForCompletion);
        queryEnvironment.getLookupEngine().getResolver().register(moduleQualifiedNameForCompletion, (Object)acceleoAstResult.getModule());
        try {
            AcceleoValidator acceleoValidator = new AcceleoValidator(queryEnvironment);
            IAcceleoValidationResult acceleoValidationResult = acceleoValidator.validate(partialAcceleoAstResult, moduleQualifiedNameForCompletion);
            AcceleoASTNode acceleoElementToComplete = this.getElementToComplete(partialAcceleoAstResult);
            queryEnvironment.getLookupEngine().pushImportsContext(moduleQualifiedNameForCompletion, moduleQualifiedNameForCompletion);
            try {
                proposals = this.getProposals(queryEnvironment, moduleFileName, partialAcceleoSource, position, acceleoValidationResult, acceleoElementToComplete);
            }
            finally {
                queryEnvironment.getLookupEngine().popContext(moduleQualifiedNameForCompletion);
            }
        }
        finally {
            queryEnvironment.getLookupEngine().getResolver().clear(Collections.singleton(moduleQualifiedNameForCompletion));
            queryEnvironment.getLookupEngine().clearContext(moduleQualifiedNameForCompletion);
        }
        return proposals;
    }

    protected List<AcceleoCompletionProposal> getProposals(IQualifiedNameQueryEnvironment queryEnvironment, String computedModuleName, String sourceFragment, int position, IAcceleoValidationResult acceleoValidationResult, AcceleoASTNode acceleoElementToComplete) {
        ArrayList<AcceleoCompletionProposal> completionProposals = new ArrayList<AcceleoCompletionProposal>();
        AcceleoAstCompletor acceleoSyntaxCompletor = new AcceleoAstCompletor(queryEnvironment, acceleoValidationResult, this.newLine);
        completionProposals.addAll(acceleoSyntaxCompletor.getCompletion(computedModuleName, sourceFragment, position, acceleoElementToComplete));
        return completionProposals;
    }

    private AcceleoASTNode getElementToComplete(AcceleoAstResult acceleoAstResult) {
        Error errorToComplete = this.getErrorToComplete(acceleoAstResult);
        if (errorToComplete == null) {
            Module moduleToComplete = acceleoAstResult.getModule();
            return moduleToComplete;
        }
        return errorToComplete;
    }

    private Error getErrorToComplete(AcceleoAstResult acceleoAstResultToComplete) {
        Objects.requireNonNull(acceleoAstResultToComplete);
        List<Error> errors = acceleoAstResultToComplete.getErrors();
        if (errors.isEmpty()) {
            return null;
        }
        Error currentError = errors.get(0);
        int currentErrorEndPosition = acceleoAstResultToComplete.getEndPosition(currentError);
        int i = 1;
        while (i < errors.size()) {
            Error candidateError = errors.get(i);
            int candidateErrorEnd = acceleoAstResultToComplete.getEndPosition(candidateError);
            if (candidateErrorEnd > currentErrorEndPosition) {
                currentError = candidateError;
                currentErrorEndPosition = candidateErrorEnd;
            }
            ++i;
        }
        return currentError;
    }
}

