/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services.collection;

import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.services.collection.AbstractCollectionService;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.ICollectionType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.LambdaType;
import org.eclipse.acceleo.query.validation.type.NothingType;

public class CollectService
extends AbstractCollectionService {
    public CollectService(Method serviceMethod, Object serviceInstance, boolean forWorkspace) {
        super(serviceMethod, serviceInstance, forWorkspace);
    }

    @Override
    public Set<IType> getType(Call call, ValidationServices services, IValidationResult validationResult, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        IType receiverType = argTypes.get(0);
        if (receiverType instanceof NothingType) {
            result.add(this.createReturnCollectionWithType(queryEnvironment, receiverType));
        } else if (receiverType instanceof ICollectionType && ((ICollectionType)receiverType).getCollectionType() instanceof NothingType) {
            result.add(receiverType);
        } else if (argTypes.get(1) instanceof LambdaType) {
            LambdaType lambdaType = (LambdaType)argTypes.get(1);
            result.add(this.createReturnCollectionWithType(queryEnvironment, this.flatten(lambdaType.getLambdaExpressionType())));
        } else {
            result.add(this.createReturnCollectionWithType(queryEnvironment, services.nothing("The %s service takes a lambda as parameter: v | v...", call.getServiceName())));
        }
        return result;
    }

    private IType flatten(IType type) {
        if (type instanceof ICollectionType) {
            return this.flatten(((ICollectionType)type).getCollectionType());
        }
        return type;
    }

    @Override
    public Set<IType> validateAllType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, Map<List<IType>, Set<IType>> allTypes) {
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        for (Map.Entry<List<IType>, Set<IType>> entry : allTypes.entrySet()) {
            for (IType type : entry.getValue()) {
                IType collectionType = ((ICollectionType)type).getCollectionType();
                if (collectionType instanceof ClassType && ((ClassType)collectionType).getType() == null) continue;
                result.add(type);
            }
        }
        return result;
    }
}

