/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.validation.type.CollectionType;
import org.eclipse.acceleo.query.validation.type.ICollectionType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.NothingType;
import org.eclipse.acceleo.query.validation.type.SequenceType;
import org.eclipse.acceleo.query.validation.type.SetType;

public class ServicesValidationResult {
    private static final String LS = System.getProperty("line.separator");
    private final IReadOnlyQueryEnvironment queryEnvironment;
    private final ValidationServices validationServices;
    private final Map<IService<?>, Map<List<IType>, Set<IType>>> typesPerService = new LinkedHashMap();
    private final Map<String, NothingType> serviceNotFoundMessages = new LinkedHashMap<String, NothingType>();

    public ServicesValidationResult(IReadOnlyQueryEnvironment queryEnvironment, ValidationServices validationServices) {
        this.queryEnvironment = queryEnvironment;
        this.validationServices = validationServices;
    }

    public void addServiceTypes(IService<?> service, Map<List<IType>, Set<IType>> types) {
        Map<List<IType>, Set<IType>> existingTypes = this.typesPerService.get(service);
        if (existingTypes == null) {
            this.typesPerService.put(service, types);
        } else {
            for (Map.Entry<List<IType>, Set<IType>> entry : types.entrySet()) {
                Set<IType> existingResultTypes = existingTypes.get(entry.getKey());
                if (existingResultTypes == null) {
                    existingTypes.put(entry.getKey(), entry.getValue());
                    continue;
                }
                existingResultTypes.addAll((Collection<IType>)entry.getValue());
            }
        }
    }

    public void addServiceNotFound(NothingType notFound) {
        this.serviceNotFoundMessages.put(notFound.getMessage(), notFound);
    }

    public void merge(ServicesValidationResult other) {
        for (Map.Entry<IService<?>, Map<List<IType>, Set<IType>>> entry : other.typesPerService.entrySet()) {
            this.addServiceTypes(entry.getKey(), entry.getValue());
        }
        this.serviceNotFoundMessages.putAll(other.serviceNotFoundMessages);
    }

    public void flattenSet() {
        for (Map<List<IType>, Set<IType>> map : this.typesPerService.values()) {
            for (Set<IType> resultTypes : map.values()) {
                LinkedHashSet<SetType> flattenedTypes = new LinkedHashSet<SetType>();
                for (IType resultType : resultTypes) {
                    if (resultType instanceof ICollectionType) {
                        flattenedTypes.add(new SetType(this.queryEnvironment, ((ICollectionType)resultType).getCollectionType()));
                        continue;
                    }
                    flattenedTypes.add(new SetType(this.queryEnvironment, resultType));
                }
                resultTypes.clear();
                resultTypes.addAll(flattenedTypes);
            }
        }
    }

    public void flattenSequence() {
        for (Map<List<IType>, Set<IType>> map : this.typesPerService.values()) {
            for (Set<IType> resultTypes : map.values()) {
                LinkedHashSet<SequenceType> flattenedTypes = new LinkedHashSet<SequenceType>();
                for (IType resultType : resultTypes) {
                    if (resultType instanceof ICollectionType) {
                        flattenedTypes.add(new SequenceType(this.queryEnvironment, ((ICollectionType)resultType).getCollectionType()));
                        continue;
                    }
                    flattenedTypes.add(new SequenceType(this.queryEnvironment, resultType));
                }
                resultTypes.clear();
                resultTypes.addAll(flattenedTypes);
            }
        }
    }

    public void flattenCollection() {
        for (Map<List<IType>, Set<IType>> map : this.typesPerService.values()) {
            for (Set<IType> resultTypes : map.values()) {
                LinkedHashSet<CollectionType> flattenedTypes = new LinkedHashSet<CollectionType>();
                for (IType resultType : resultTypes) {
                    if (resultType instanceof ICollectionType) {
                        flattenedTypes.add(new CollectionType(this.queryEnvironment, ((ICollectionType)resultType).getCollectionType()));
                        continue;
                    }
                    flattenedTypes.add(new CollectionType(this.queryEnvironment, resultType));
                }
                resultTypes.clear();
                resultTypes.addAll(flattenedTypes);
            }
        }
    }

    public Set<IType> getResultingTypes() {
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        LinkedHashSet<IType> aggregated = new LinkedHashSet<IType>();
        if (!this.typesPerService.isEmpty()) {
            for (Map.Entry<IService<?>, Map<List<IType>, Set<IType>>> entry : this.typesPerService.entrySet()) {
                IService<?> service = entry.getKey();
                Map<List<IType>, Set<IType>> types = entry.getValue();
                Set<IType> validatedTypes = service.validateAllType(this.validationServices, this.queryEnvironment, types);
                aggregated.addAll(validatedTypes);
            }
        } else {
            aggregated.addAll(this.serviceNotFoundMessages.values());
        }
        StringBuilder builderSequenceNothing = new StringBuilder();
        StringBuilder builderSetNothing = new StringBuilder();
        StringBuilder builderNothing = new StringBuilder();
        for (IType type : aggregated) {
            if (type instanceof ICollectionType) {
                if (((ICollectionType)type).getCollectionType() instanceof NothingType) {
                    NothingType collectionType = (NothingType)((ICollectionType)type).getCollectionType();
                    if (type instanceof SequenceType) {
                        builderSequenceNothing.append(collectionType.getMessage());
                        builderSequenceNothing.append(LS);
                        continue;
                    }
                    if (type instanceof SetType) {
                        builderSetNothing.append(collectionType.getMessage());
                        builderSetNothing.append(LS);
                        continue;
                    }
                    throw new IllegalStateException("new collection type ?");
                }
                result.add(type);
                continue;
            }
            if (type instanceof NothingType) {
                builderNothing.append(((NothingType)type).getMessage());
                builderNothing.append(LS);
                continue;
            }
            result.add(type);
        }
        if (builderSequenceNothing.length() != 0) {
            result.add(new SequenceType(this.queryEnvironment, new NothingType(builderSequenceNothing.substring(0, builderSequenceNothing.length() - LS.length()))));
        }
        if (builderSetNothing.length() != 0) {
            result.add(new SetType(this.queryEnvironment, new NothingType(builderSetNothing.substring(0, builderSetNothing.length() - LS.length()))));
        }
        if (builderNothing.length() != 0) {
            result.add(new NothingType(builderNothing.substring(0, builderNothing.length() - LS.length())));
        }
        return result;
    }

    public Set<IService<?>> getResolvedServices() {
        return this.typesPerService.keySet();
    }
}

