/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.ide.jdt.runtime.impl.namespace;

import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import org.eclipse.acceleo.query.ide.jdt.Activator;
import org.eclipse.acceleo.query.ide.jdt.runtime.impl.namespace.EclipseJDTQualifiedNameResolver;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.impl.namespace.JavaLoader;
import org.eclipse.acceleo.query.runtime.impl.namespace.Position;
import org.eclipse.acceleo.query.runtime.impl.namespace.Range;
import org.eclipse.acceleo.query.runtime.impl.namespace.SourceLocation;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameLookupEngine;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameResolver;
import org.eclipse.acceleo.query.runtime.namespace.ISourceLocation;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class EclipseJDTJavaLoader
extends JavaLoader {
    public static final String PATH_SEPARATOR = "/";
    public static final String PERIOD = ".";
    public static final String SRC = "src";
    private static final String JDT_SCHEME = "jdt";
    public static final String SYNTAX_SERVER_ID = "syntaxserver";

    public EclipseJDTJavaLoader(String qualifierSeparator, boolean forWorkspace) {
        super(qualifierSeparator, forWorkspace);
    }

    public Set<IService<?>> getServices(IQualifiedNameLookupEngine lookupEngine, Object object, String contextQualifiedName) {
        return super.getServices(lookupEngine, object, contextQualifiedName);
    }

    public ISourceLocation getSourceLocation(IQualifiedNameResolver resolver, IService<?> service) {
        ISourceLocation res;
        block14: {
            String contextQualifiedName = this.getQualifiedName(this.getContext(service));
            if (contextQualifiedName != null) {
                URI sourceURI = null;
                if (resolver instanceof EclipseJDTQualifiedNameResolver) {
                    IJavaProject project = ((EclipseJDTQualifiedNameResolver)resolver).getProject();
                    try {
                        IType type = project.findType(contextQualifiedName);
                        if (type != null) {
                            type.getOpenable().open((IProgressMonitor)new NullProgressMonitor());
                            IResource typeResource = type.getResource();
                            ASTParser parser = ASTParser.newParser((int)AST.getJLSLatest());
                            if (typeResource != null) {
                                sourceURI = typeResource.getLocationURI();
                                parser.setSource(type.getCompilationUnit());
                            } else if (type.getSource() != null) {
                                try {
                                    sourceURI = new URI(EclipseJDTJavaLoader.replaceUriFragment(this.toJDTUri((IClassFile)type.getClassFile()).toASCIIString(), SYNTAX_SERVER_ID));
                                    parser.setSource(type.getSource().toCharArray());
                                }
                                catch (Exception e) {
                                    Activator.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.aql.ide.jdt", "can't get source location from:" + contextQualifiedName, (Throwable)e));
                                }
                            }
                            if (sourceURI != null) {
                                IMethod javaMethod = this.getIMethod(type, service);
                                javaMethod.getOpenable().open((IProgressMonitor)new NullProgressMonitor());
                                ISourceRange methodIdentifierRange = javaMethod.getNameRange();
                                ISourceRange sourceRange = javaMethod.getSourceRange();
                                res = this.getIdentifierLocation(sourceURI, parser, methodIdentifierRange, sourceRange);
                            } else {
                                res = null;
                            }
                            break block14;
                        }
                        res = null;
                    }
                    catch (JavaModelException e) {
                        res = null;
                    }
                } else {
                    res = null;
                }
            } else {
                res = null;
            }
        }
        return res;
    }

    private String getQualifiedName(Object resolved) {
        String res = resolved instanceof Class ? ((Class)resolved).getCanonicalName() : null;
        return res;
    }

    private Object getContext(IService<?> service) {
        Object origin = service.getOrigin();
        Class<?> res = origin instanceof Method ? ((Method)origin).getDeclaringClass() : null;
        return res;
    }

    private IMethod getIMethod(IType type, IService<?> service) {
        IMethod res;
        Object origin = service.getOrigin();
        if (origin instanceof IMethod) {
            res = (IMethod)origin;
        } else if (origin instanceof Method) {
            Method method = (Method)origin;
            res = type.getMethod(method.getName(), this.getParamterTypes(method));
        } else {
            res = null;
        }
        return res;
    }

    private URI toJDTUri(IClassFile classFile) {
        URI res;
        String packageName = classFile.getParent().getElementName();
        String jarName = classFile.getParent().getParent().getElementName();
        try {
            res = new URI(JDT_SCHEME, "contents", PATH_SEPARATOR + jarName + PATH_SEPARATOR + packageName + PATH_SEPARATOR + classFile.getElementName(), classFile.getHandleIdentifier(), null);
        }
        catch (URISyntaxException e) {
            res = null;
        }
        return res;
    }

    public static String replaceUriFragment(String uriString, String fragment) {
        URI uri;
        if (uriString != null && (uri = EclipseJDTJavaLoader.toURI(uriString)) != null && Objects.equals(JDT_SCHEME, uri.getScheme())) {
            try {
                return new URI(JDT_SCHEME, uri.getAuthority(), uri.getPath(), uri.getQuery(), fragment).toASCIIString();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return uriString;
    }

    public static URI toURI(String uriString) {
        if (uriString == null || uriString.isEmpty()) {
            return null;
        }
        try {
            URI uri = new URI(uriString);
            if ("win32".equals(Platform.getOS()) && URIUtil.isFileURI((URI)uri)) {
                uri = URIUtil.toFile((URI)uri).toURI();
            }
            return uri;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public ISourceLocation getSourceLocation(IQualifiedNameResolver resolver, String qualifiedName) {
        ISourceLocation res;
        block9: {
            Object resolved = resolver.resolve(qualifiedName);
            if (resolved != null) {
                URI sourceURI = null;
                if (resolver instanceof EclipseJDTQualifiedNameResolver) {
                    IJavaProject project = ((EclipseJDTQualifiedNameResolver)resolver).getProject();
                    try {
                        IType type = this.getJDTIType(resolved, project);
                        if (type != null) {
                            type.getOpenable().open((IProgressMonitor)new NullProgressMonitor());
                            IResource typeResource = type.getResource();
                            ASTParser parser = ASTParser.newParser((int)AST.getJLSLatest());
                            if (typeResource != null) {
                                sourceURI = typeResource.getLocationURI();
                                parser.setSource(type.getCompilationUnit());
                            } else {
                                sourceURI = this.toJDTUri((IClassFile)type.getClassFile());
                                parser.setSource(type.getSource().toCharArray());
                            }
                            ISourceRange classIdentifierRange = type.getNameRange();
                            ISourceRange sourceRange = type.getSourceRange();
                            res = this.getIdentifierLocation(sourceURI, parser, classIdentifierRange, sourceRange);
                            break block9;
                        }
                        res = null;
                    }
                    catch (JavaModelException e) {
                        res = null;
                    }
                } else {
                    res = null;
                }
            } else {
                res = null;
            }
        }
        return res;
    }

    private IType getJDTIType(Object resolved, IJavaProject project) throws JavaModelException {
        IType res = resolved instanceof Class ? project.findType(((Class)resolved).getCanonicalName()) : null;
        return res;
    }

    private ISourceLocation getIdentifierLocation(URI sourceURI, ASTParser parser, ISourceRange javaIdentifierRange, ISourceRange javaSourceRange) {
        try {
            CompilationUnit cu = (CompilationUnit)parser.createAST(null);
            int identifierStartOffset = javaIdentifierRange.getOffset();
            Position identifierStart = new Position(cu.getLineNumber(identifierStartOffset) - 1, cu.getColumnNumber(identifierStartOffset), identifierStartOffset);
            int identifierEndOffset = identifierStartOffset + javaIdentifierRange.getLength();
            Position identifierEnd = new Position(cu.getLineNumber(identifierEndOffset) - 1, cu.getColumnNumber(identifierEndOffset), identifierEndOffset);
            int startOffset = javaSourceRange.getOffset();
            Position start = new Position(cu.getLineNumber(startOffset) - 1, cu.getColumnNumber(startOffset), startOffset);
            int endOffset = startOffset + javaSourceRange.getLength();
            Position end = new Position(cu.getLineNumber(endOffset) - 1, cu.getColumnNumber(endOffset), endOffset);
            Range identifierRange = new Range((ISourceLocation.IPosition)identifierStart, (ISourceLocation.IPosition)identifierEnd);
            Range range = new Range((ISourceLocation.IPosition)start, (ISourceLocation.IPosition)end);
            return new SourceLocation(sourceURI, (ISourceLocation.IRange)identifierRange, (ISourceLocation.IRange)range);
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    private String[] getParamterTypes(Method method) {
        ArrayList<String> res = new ArrayList<String>();
        Class<?>[] classArray = method.getParameterTypes();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> type = classArray[n2];
            res.add(Signature.createTypeSignature((String)type.getSimpleName(), (boolean)false));
            ++n2;
        }
        return res.toArray(new String[res.size()]);
    }
}

