/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.migration.converters.utils;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.acceleo.query.ast.AstFactory;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ast.CallType;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.OperationCallExp;

public final class OperationUtils {
    private static final Map<String, String> OPERATORS_SERVICES = new HashMap<String, String>();
    private static final Map<String, String> TRANSLATED_SERVICES = new HashMap<String, String>();

    static {
        OPERATORS_SERVICES.put("not", "not");
        OPERATORS_SERVICES.put("<>", "differs");
        OPERATORS_SERVICES.put("=", "equals");
        OPERATORS_SERVICES.put(">=", "greaterThanEqual");
        OPERATORS_SERVICES.put(">", "greaterThan");
        OPERATORS_SERVICES.put("<=", "lessThanEqual");
        OPERATORS_SERVICES.put("<", "lessThan");
        OPERATORS_SERVICES.put("/", "divOp");
        OPERATORS_SERVICES.put("*", "mult");
        OPERATORS_SERVICES.put("-", "sub");
        OPERATORS_SERVICES.put("+", "add");
        OPERATORS_SERVICES.put("and", "and");
        OPERATORS_SERVICES.put("or", "or");
        OPERATORS_SERVICES.put("xor", "xor");
        OPERATORS_SERVICES.put("implies", "implies");
        TRANSLATED_SERVICES.put("toUpperCase", "toUpper");
        TRANSLATED_SERVICES.put("toLowerCase", "toLower");
        TRANSLATED_SERVICES.put("isAlphanum", "isAlphaNum");
        TRANSLATED_SERVICES.put("asBag", "asSequence");
    }

    private OperationUtils() {
    }

    public static Call createCall(OperationCallExp input) {
        String operationName = OperationUtils.getEOperationName((EOperation)input.getReferredOperation());
        Object output = null;
        output = "and".equals(operationName) ? AstFactory.eINSTANCE.createAnd() : ("or".equals(operationName) ? AstFactory.eINSTANCE.createOr() : ("implies".equals(operationName) ? AstFactory.eINSTANCE.createImplies() : AstFactory.eINSTANCE.createCall()));
        if (OPERATORS_SERVICES.containsKey(operationName)) {
            output.setServiceName(OPERATORS_SERVICES.get(operationName));
        } else if (TRANSLATED_SERVICES.containsKey(operationName)) {
            output.setServiceName(TRANSLATED_SERVICES.get(operationName));
        } else {
            output.setServiceName(operationName);
        }
        if (OPERATORS_SERVICES.containsKey(operationName)) {
            output.setType(CallType.CALLSERVICE);
        } else if (input.getSource().getType() instanceof CollectionType) {
            output.setType(CallType.COLLECTIONCALL);
        } else {
            output.setType(CallType.CALLORAPPLY);
        }
        return output;
    }

    private static String getEOperationName(EOperation referredOperation) {
        String res = null;
        if (referredOperation.eIsProxy()) {
            URI uri = ((InternalEObject)referredOperation).eProxyURI();
            if (uri.fragment() != null && uri.fragment().endsWith("%2F")) {
                res = "/";
            }
        } else {
            res = referredOperation.getName();
        }
        return res;
    }
}

