/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.columnChooser.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.nebula.widgets.nattable.columnChooser.ColumnChooser;
import org.eclipse.nebula.widgets.nattable.columnChooser.command.DisplayColumnChooserCommand;
import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupModel;
import org.eclipse.nebula.widgets.nattable.group.performance.ColumnGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.ColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;

public class DisplayColumnChooserCommandHandler
extends AbstractLayerCommandHandler<DisplayColumnChooserCommand> {
    private final ColumnHideShowLayer columnHideShowLayer;
    private final org.eclipse.nebula.widgets.nattable.group.ColumnGroupHeaderLayer columnGroupHeaderLayer;
    private final ColumnGroupModel columnGroupModel;
    private final SelectionLayer selectionLayer;
    private final DataLayer columnHeaderDataLayer;
    private final ColumnHeaderLayer columnHeaderLayer;
    private final boolean sortAvailableColumns;
    private final boolean preventHidingAllColumns;
    private IDialogSettings dialogSettings;
    private List<Integer> nonModifiableColumns = new ArrayList<Integer>();
    private final ColumnGroupHeaderLayer cghLayer;

    public DisplayColumnChooserCommandHandler(SelectionLayer selectionLayer, ColumnHideShowLayer columnHideShowLayer, ColumnHeaderLayer columnHeaderLayer, DataLayer columnHeaderDataLayer, org.eclipse.nebula.widgets.nattable.group.ColumnGroupHeaderLayer cgHeader, ColumnGroupModel columnGroupModel) {
        this(selectionLayer, columnHideShowLayer, columnHeaderLayer, columnHeaderDataLayer, cgHeader, columnGroupModel, false, false);
    }

    public DisplayColumnChooserCommandHandler(SelectionLayer selectionLayer, ColumnHideShowLayer columnHideShowLayer, ColumnHeaderLayer columnHeaderLayer, DataLayer columnHeaderDataLayer, org.eclipse.nebula.widgets.nattable.group.ColumnGroupHeaderLayer cgHeader, ColumnGroupModel columnGroupModel, boolean sortAvailableColumns) {
        this(selectionLayer, columnHideShowLayer, columnHeaderLayer, columnHeaderDataLayer, cgHeader, columnGroupModel, sortAvailableColumns, false);
    }

    public DisplayColumnChooserCommandHandler(SelectionLayer selectionLayer, ColumnHideShowLayer columnHideShowLayer, ColumnHeaderLayer columnHeaderLayer, DataLayer columnHeaderDataLayer, org.eclipse.nebula.widgets.nattable.group.ColumnGroupHeaderLayer cgHeader, ColumnGroupModel columnGroupModel, boolean sortAvalableColumns, boolean preventHidingAllColumns) {
        this.selectionLayer = selectionLayer;
        this.columnHideShowLayer = columnHideShowLayer;
        this.columnHeaderLayer = columnHeaderLayer;
        this.columnHeaderDataLayer = columnHeaderDataLayer;
        this.columnGroupHeaderLayer = cgHeader;
        this.columnGroupModel = columnGroupModel;
        this.sortAvailableColumns = sortAvalableColumns;
        this.preventHidingAllColumns = preventHidingAllColumns;
        this.cghLayer = null;
    }

    public DisplayColumnChooserCommandHandler(ColumnHideShowLayer columnHideShowLayer, ColumnHeaderLayer columnHeaderLayer, DataLayer columnHeaderDataLayer, ColumnGroupHeaderLayer cgHeader) {
        this(columnHideShowLayer, columnHeaderLayer, columnHeaderDataLayer, cgHeader, false);
    }

    public DisplayColumnChooserCommandHandler(ColumnHideShowLayer columnHideShowLayer, ColumnHeaderLayer columnHeaderLayer, DataLayer columnHeaderDataLayer, ColumnGroupHeaderLayer cgHeader, boolean sortAvailableColumns) {
        if (cgHeader == null) {
            throw new IllegalArgumentException("cgHeader cannot be null");
        }
        this.selectionLayer = null;
        this.columnHideShowLayer = columnHideShowLayer;
        this.columnHeaderLayer = columnHeaderLayer;
        this.columnHeaderDataLayer = columnHeaderDataLayer;
        this.columnGroupHeaderLayer = null;
        this.columnGroupModel = null;
        this.sortAvailableColumns = sortAvailableColumns;
        this.preventHidingAllColumns = false;
        this.cghLayer = cgHeader;
    }

    @Override
    public boolean doCommand(DisplayColumnChooserCommand command) {
        ColumnChooser columnChooser = this.cghLayer == null ? new ColumnChooser(command.getNatTable().getShell(), this.selectionLayer, this.columnHideShowLayer, this.columnHeaderLayer, this.columnHeaderDataLayer, this.columnGroupHeaderLayer, this.columnGroupModel, this.sortAvailableColumns, this.preventHidingAllColumns) : new ColumnChooser(command.getNatTable().getShell(), this.columnHideShowLayer, this.columnHeaderLayer, this.columnHeaderDataLayer, this.cghLayer, this.sortAvailableColumns);
        columnChooser.setDialogSettings(this.dialogSettings);
        columnChooser.addNonModifiableColumn(this.nonModifiableColumns.toArray(new Integer[0]));
        columnChooser.openDialog();
        return true;
    }

    public void setDialogSettings(IDialogSettings dialogSettings) {
        this.dialogSettings = dialogSettings;
    }

    public void addNonModifiableColumn(Integer ... columnIndexes) {
        Integer[] integerArray = columnIndexes;
        int n = columnIndexes.length;
        int n2 = 0;
        while (n2 < n) {
            Integer column = integerArray[n2];
            this.nonModifiableColumns.add(column);
            ++n2;
        }
    }

    public void removeNonModifiableColumn(Integer ... columnIndexes) {
        Integer[] integerArray = columnIndexes;
        int n = columnIndexes.length;
        int n2 = 0;
        while (n2 < n) {
            Integer column = integerArray[n2];
            this.nonModifiableColumns.remove(column);
            ++n2;
        }
    }

    @Override
    public Class<DisplayColumnChooserCommand> getCommandClass() {
        return DisplayColumnChooserCommand.class;
    }
}

