/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class DeleteReferencesItem
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=385");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=386");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=387");
    private final NodeId sourceNodeId;
    private final NodeId referenceTypeId;
    private final Boolean isForward;
    private final ExpandedNodeId targetNodeId;
    private final Boolean deleteBidirectional;

    public DeleteReferencesItem(NodeId sourceNodeId, NodeId referenceTypeId, Boolean isForward, ExpandedNodeId targetNodeId, Boolean deleteBidirectional) {
        this.sourceNodeId = sourceNodeId;
        this.referenceTypeId = referenceTypeId;
        this.isForward = isForward;
        this.targetNodeId = targetNodeId;
        this.deleteBidirectional = deleteBidirectional;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public NodeId getSourceNodeId() {
        return this.sourceNodeId;
    }

    public NodeId getReferenceTypeId() {
        return this.referenceTypeId;
    }

    public Boolean getIsForward() {
        return this.isForward;
    }

    public ExpandedNodeId getTargetNodeId() {
        return this.targetNodeId;
    }

    public Boolean getDeleteBidirectional() {
        return this.deleteBidirectional;
    }

    protected DeleteReferencesItem(DeleteReferencesItemBuilder<?, ?> b) {
        super(b);
        this.sourceNodeId = ((DeleteReferencesItemBuilder)b).sourceNodeId;
        this.referenceTypeId = ((DeleteReferencesItemBuilder)b).referenceTypeId;
        this.isForward = ((DeleteReferencesItemBuilder)b).isForward;
        this.targetNodeId = ((DeleteReferencesItemBuilder)b).targetNodeId;
        this.deleteBidirectional = ((DeleteReferencesItemBuilder)b).deleteBidirectional;
    }

    public static DeleteReferencesItemBuilder<?, ?> builder() {
        return new DeleteReferencesItemBuilderImpl();
    }

    public DeleteReferencesItemBuilder<?, ?> toBuilder() {
        return new DeleteReferencesItemBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteReferencesItem)) {
            return false;
        }
        DeleteReferencesItem other = (DeleteReferencesItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isForward = this.getIsForward();
        Boolean other$isForward = other.getIsForward();
        if (this$isForward == null ? other$isForward != null : !((Object)this$isForward).equals(other$isForward)) {
            return false;
        }
        Boolean this$deleteBidirectional = this.getDeleteBidirectional();
        Boolean other$deleteBidirectional = other.getDeleteBidirectional();
        if (this$deleteBidirectional == null ? other$deleteBidirectional != null : !((Object)this$deleteBidirectional).equals(other$deleteBidirectional)) {
            return false;
        }
        NodeId this$sourceNodeId = this.getSourceNodeId();
        NodeId other$sourceNodeId = other.getSourceNodeId();
        if (this$sourceNodeId == null ? other$sourceNodeId != null : !((Object)this$sourceNodeId).equals(other$sourceNodeId)) {
            return false;
        }
        NodeId this$referenceTypeId = this.getReferenceTypeId();
        NodeId other$referenceTypeId = other.getReferenceTypeId();
        if (this$referenceTypeId == null ? other$referenceTypeId != null : !((Object)this$referenceTypeId).equals(other$referenceTypeId)) {
            return false;
        }
        ExpandedNodeId this$targetNodeId = this.getTargetNodeId();
        ExpandedNodeId other$targetNodeId = other.getTargetNodeId();
        return !(this$targetNodeId == null ? other$targetNodeId != null : !((Object)this$targetNodeId).equals(other$targetNodeId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeleteReferencesItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isForward = this.getIsForward();
        result = result * 59 + ($isForward == null ? 43 : ((Object)$isForward).hashCode());
        Boolean $deleteBidirectional = this.getDeleteBidirectional();
        result = result * 59 + ($deleteBidirectional == null ? 43 : ((Object)$deleteBidirectional).hashCode());
        NodeId $sourceNodeId = this.getSourceNodeId();
        result = result * 59 + ($sourceNodeId == null ? 43 : ((Object)$sourceNodeId).hashCode());
        NodeId $referenceTypeId = this.getReferenceTypeId();
        result = result * 59 + ($referenceTypeId == null ? 43 : ((Object)$referenceTypeId).hashCode());
        ExpandedNodeId $targetNodeId = this.getTargetNodeId();
        result = result * 59 + ($targetNodeId == null ? 43 : ((Object)$targetNodeId).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "DeleteReferencesItem(sourceNodeId=" + this.getSourceNodeId() + ", referenceTypeId=" + this.getReferenceTypeId() + ", isForward=" + this.getIsForward() + ", targetNodeId=" + this.getTargetNodeId() + ", deleteBidirectional=" + this.getDeleteBidirectional() + ")";
    }

    private static final class DeleteReferencesItemBuilderImpl
    extends DeleteReferencesItemBuilder<DeleteReferencesItem, DeleteReferencesItemBuilderImpl> {
        private DeleteReferencesItemBuilderImpl() {
        }

        @Override
        protected DeleteReferencesItemBuilderImpl self() {
            return this;
        }

        @Override
        public DeleteReferencesItem build() {
            return new DeleteReferencesItem(this);
        }
    }

    public static abstract class DeleteReferencesItemBuilder<C extends DeleteReferencesItem, B extends DeleteReferencesItemBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private NodeId sourceNodeId;
        private NodeId referenceTypeId;
        private Boolean isForward;
        private ExpandedNodeId targetNodeId;
        private Boolean deleteBidirectional;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            DeleteReferencesItemBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(DeleteReferencesItem instance, DeleteReferencesItemBuilder<?, ?> b) {
            b.sourceNodeId(instance.sourceNodeId);
            b.referenceTypeId(instance.referenceTypeId);
            b.isForward(instance.isForward);
            b.targetNodeId(instance.targetNodeId);
            b.deleteBidirectional(instance.deleteBidirectional);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B sourceNodeId(NodeId sourceNodeId) {
            this.sourceNodeId = sourceNodeId;
            return (B)this.self();
        }

        public B referenceTypeId(NodeId referenceTypeId) {
            this.referenceTypeId = referenceTypeId;
            return (B)this.self();
        }

        public B isForward(Boolean isForward) {
            this.isForward = isForward;
            return (B)this.self();
        }

        public B targetNodeId(ExpandedNodeId targetNodeId) {
            this.targetNodeId = targetNodeId;
            return (B)this.self();
        }

        public B deleteBidirectional(Boolean deleteBidirectional) {
            this.deleteBidirectional = deleteBidirectional;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "DeleteReferencesItem.DeleteReferencesItemBuilder(super=" + super.toString() + ", sourceNodeId=" + this.sourceNodeId + ", referenceTypeId=" + this.referenceTypeId + ", isForward=" + this.isForward + ", targetNodeId=" + this.targetNodeId + ", deleteBidirectional=" + this.deleteBidirectional + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<DeleteReferencesItem> {
        @Override
        public Class<DeleteReferencesItem> getType() {
            return DeleteReferencesItem.class;
        }

        @Override
        public DeleteReferencesItem decode(SerializationContext context, UaDecoder decoder) {
            NodeId sourceNodeId = decoder.readNodeId("SourceNodeId");
            NodeId referenceTypeId = decoder.readNodeId("ReferenceTypeId");
            Boolean isForward = decoder.readBoolean("IsForward");
            ExpandedNodeId targetNodeId = decoder.readExpandedNodeId("TargetNodeId");
            Boolean deleteBidirectional = decoder.readBoolean("DeleteBidirectional");
            return new DeleteReferencesItem(sourceNodeId, referenceTypeId, isForward, targetNodeId, deleteBidirectional);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, DeleteReferencesItem value) {
            encoder.writeNodeId("SourceNodeId", value.getSourceNodeId());
            encoder.writeNodeId("ReferenceTypeId", value.getReferenceTypeId());
            encoder.writeBoolean("IsForward", value.getIsForward());
            encoder.writeExpandedNodeId("TargetNodeId", value.getTargetNodeId());
            encoder.writeBoolean("DeleteBidirectional", value.getDeleteBidirectional());
        }
    }
}

