/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.forte_ng;

import com.google.common.collect.Iterables;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.export.forte_ng.ForteNgExportTemplate;
import org.eclipse.fordiac.ide.export.forte_ng.util.ForteNgExportUtil;
import org.eclipse.fordiac.ide.export.language.ILanguageSupport;
import org.eclipse.fordiac.ide.export.language.ILanguageSupportFactory;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.CompilerInfo;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.ICallable;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.VersionInfo;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;

public abstract class ForteLibraryElementTemplate<T extends LibraryElement>
extends ForteNgExportTemplate {
    @Accessors(value={AccessorType.PROTECTED_GETTER})
    private final T type;
    private final Map<VarDeclaration, ILanguageSupport> variableLanguageSupport;

    public ForteLibraryElementTemplate(T type, String name, Path prefix, Map<?, ?> options) {
        super(name, prefix);
        this.type = type;
        Functions.Function1 _function = it -> ILanguageSupportFactory.createLanguageSupport((String)"forte_ng", (EObject)it, (Map)options);
        this.variableLanguageSupport = IterableExtensions.toInvertedMap((Iterable)EcoreUtil2.getAllContentsOfType(type, VarDeclaration.class), (Functions.Function1)_function);
    }

    protected CharSequence getClassName() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("FORTE_");
        String _generateTypeNamePlain = ForteNgExportUtil.generateTypeNamePlain(this.type);
        _builder.append(_generateTypeNamePlain);
        return _builder;
    }

    protected CharSequence generateHeader() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/*************************************************************************");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*** FORTE Library Element");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("***");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*** ");
        _builder.append(ForteNgExportTemplate.HEADER_TEXT, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("***");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*** Name: ");
        String _name = this.type.getName();
        _builder.append(_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*** Description: ");
        CharSequence _escapeMultilineCommentString = ForteNgExportUtil.escapeMultilineCommentString(this.type.getComment());
        _builder.append((Object)_escapeMultilineCommentString, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*** Version:");
        _builder.newLine();
        EList _versionInfo = this.type.getVersionInfo();
        for (VersionInfo info : _versionInfo) {
            _builder.append(" ");
            _builder.append("***     ");
            CharSequence _escapeMultilineCommentString_1 = ForteNgExportUtil.escapeMultilineCommentString(info.getVersion());
            _builder.append((Object)_escapeMultilineCommentString_1, " ");
            _builder.append(": ");
            CharSequence _escapeMultilineCommentString_2 = ForteNgExportUtil.escapeMultilineCommentString(info.getDate());
            _builder.append((Object)_escapeMultilineCommentString_2, " ");
            _builder.append("/");
            CharSequence _escapeMultilineCommentString_3 = ForteNgExportUtil.escapeMultilineCommentString(info.getAuthor());
            _builder.append((Object)_escapeMultilineCommentString_3, " ");
            _builder.append(" - ");
            CharSequence _escapeMultilineCommentString_4 = ForteNgExportUtil.escapeMultilineCommentString(info.getOrganization());
            _builder.append((Object)_escapeMultilineCommentString_4, " ");
            _builder.append(" - ");
            CharSequence _escapeMultilineCommentString_5 = ForteNgExportUtil.escapeMultilineCommentString(info.getRemarks());
            _builder.append((Object)_escapeMultilineCommentString_5, " ");
            _builder.newLineIfNotEmpty();
        }
        _builder.append(" ");
        _builder.append("*************************************************************************/");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence generateIncludeGuardStart() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#pragma once");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence generateIncludeGuardEnd() {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    protected CharSequence generateImplIncludes() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#include \"");
        String _generateTypeIncludePath = ForteNgExportUtil.generateTypeIncludePath(this.type);
        _builder.append(_generateTypeIncludePath);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateDependencyIncludes = this.generateDependencyIncludes(this.getDependencies(CollectionLiterals.emptyMap()));
        _builder.append((Object)_generateDependencyIncludes);
        _builder.newLineIfNotEmpty();
        CompilerInfo _compilerInfo = this.type.getCompilerInfo();
        String _header = null;
        if (_compilerInfo != null) {
            _header = _compilerInfo.getHeader();
        }
        _builder.append(_header);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("using namespace std::literals;");
        _builder.newLine();
        _builder.append("using namespace forte::literals;");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence generateVariableDeclarations(List<VarDeclaration> variables, boolean const_) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (VarDeclaration variable : variables) {
            if (!_hasElements) {
                _hasElements = true;
            }
            if (const_) {
                _builder.append("static const ");
            }
            CharSequence _generateVariableTypeName = this.generateVariableTypeName(variable);
            _builder.append((Object)_generateVariableTypeName);
            _builder.append(" ");
            CharSequence _generateName = ForteNgExportUtil.generateName((IInterfaceElement)variable);
            _builder.append((Object)_generateName);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        if (_hasElements) {
            _builder.append("\n");
        }
        return _builder;
    }

    protected CharSequence generateVariableDefinitions(List<VarDeclaration> variables, boolean const_) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (VarDeclaration variable : variables) {
            if (!_hasElements) {
                _hasElements = true;
            }
            if (const_) {
                _builder.append("const ");
            }
            CharSequence _generateVariableTypeName = this.generateVariableTypeName(variable);
            _builder.append((Object)_generateVariableTypeName);
            _builder.append(" ");
            CharSequence _className = this.getClassName();
            _builder.append((Object)_className);
            _builder.append("::");
            CharSequence _generateName = ForteNgExportUtil.generateName((IInterfaceElement)variable);
            _builder.append((Object)_generateName);
            _builder.append(" = ");
            CharSequence _generateVariableDefaultValue = this.generateVariableDefaultValue(variable);
            _builder.append((Object)_generateVariableDefaultValue);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        if (_hasElements) {
            _builder.append("\n");
        }
        return _builder;
    }

    protected CharSequence generateVariableInitializer(Iterable<VarDeclaration> variables) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (VarDeclaration variable : variables) {
            if (!_hasElements) {
                _hasElements = true;
                _builder.append(",\n");
            } else {
                _builder.appendImmediate((Object)",\n", "");
            }
            CharSequence _generateName = ForteNgExportUtil.generateName((IInterfaceElement)variable);
            _builder.append((Object)_generateName);
            _builder.append("(");
            CharSequence _generateVariableDefaultValue = this.generateVariableDefaultValue(variable);
            _builder.append((Object)_generateVariableDefaultValue);
            _builder.append(")");
        }
        return _builder;
    }

    protected CharSequence generateVariableInitializerFromParameters(Iterable<VarDeclaration> variables) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (VarDeclaration variable : variables) {
            if (!_hasElements) {
                _hasElements = true;
                _builder.append(",\n");
            } else {
                _builder.appendImmediate((Object)",\n", "");
            }
            CharSequence _generateName = ForteNgExportUtil.generateName((IInterfaceElement)variable);
            _builder.append((Object)_generateName);
            _builder.append("(");
            CharSequence _generateNameAsParameter = ForteNgExportUtil.generateNameAsParameter(variable);
            _builder.append((Object)_generateNameAsParameter);
            _builder.append(")");
        }
        return _builder;
    }

    protected CharSequence generatePlugDeclarations(List<AdapterDeclaration> adapters) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (AdapterDeclaration adapter : adapters) {
            if (!_hasElements) {
                _hasElements = true;
            }
            _builder.append("forte::CPlugPin<");
            CharSequence _generateTypeName = ForteNgExportUtil.generateTypeName((LibraryElement)adapter.getType());
            _builder.append((Object)_generateTypeName);
            _builder.append("_Plug> ");
            CharSequence _generateName = ForteNgExportUtil.generateName((IInterfaceElement)adapter);
            _builder.append((Object)_generateName);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        if (_hasElements) {
            _builder.append("\n");
        }
        return _builder;
    }

    protected CharSequence generateSocketDeclarations(List<AdapterDeclaration> adapters) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (AdapterDeclaration adapter : adapters) {
            if (!_hasElements) {
                _hasElements = true;
            }
            _builder.append("forte::CSocketPin<");
            CharSequence _generateTypeName = ForteNgExportUtil.generateTypeName((LibraryElement)adapter.getType());
            _builder.append((Object)_generateTypeName);
            _builder.append("_Socket> ");
            CharSequence _generateName = ForteNgExportUtil.generateName((IInterfaceElement)adapter);
            _builder.append((Object)_generateName);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        if (_hasElements) {
            _builder.append("\n");
        }
        return _builder;
    }

    protected CharSequence generateAdapterInitializer(List<AdapterDeclaration> adapters) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (AdapterDeclaration adapter : adapters) {
            if (!_hasElements) {
                _hasElements = true;
                _builder.append(",\n");
            } else {
                _builder.appendImmediate((Object)",\n", "");
            }
            CharSequence _generateName = ForteNgExportUtil.generateName((IInterfaceElement)adapter);
            _builder.append((Object)_generateName);
            _builder.append("(");
            CharSequence _fORTEStringId = ForteNgExportUtil.getFORTEStringId(adapter.getName());
            _builder.append((Object)_fORTEStringId);
            _builder.append(", *this, ");
            if (this.type instanceof CompositeFBType) {
                _builder.append("forte::cgCFBParentAdapterlistIDMarker");
            } else {
                int _indexOf = adapters.indexOf(adapter);
                _builder.append((Object)_indexOf);
            }
            _builder.append(")");
        }
        return _builder;
    }

    protected CharSequence generateAccessorDeclaration(String function, boolean const_) {
        return this.generateAccessorDeclaration(function, "CIEC_ANY *", const_);
    }

    protected CharSequence generateAccessorDeclaration(String function, String type, boolean const_) {
        StringConcatenation _builder = new StringConcatenation();
        if (const_) {
            _builder.append("const ");
        }
        _builder.append(type);
        _builder.append(function);
        _builder.append("(size_t)");
        if (const_) {
            _builder.append(" const");
        }
        _builder.append(" override;");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence generateAccessorDefinition(List<VarDeclaration> variables, String function, boolean const_) {
        return this.generateAccessorDefinition(variables, function, "CIEC_ANY *", const_);
    }

    protected CharSequence generateAccessorDefinition(List<? extends IInterfaceElement> variables, String function, String type, boolean const_) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = variables.isEmpty();
        if (_isEmpty) {
            if (const_) {
                _builder.append("const ");
            }
            _builder.append(type);
            CharSequence _className = this.getClassName();
            _builder.append((Object)_className);
            _builder.append("::");
            _builder.append(function);
            _builder.append("(size_t)");
            if (const_) {
                _builder.append(" const");
            }
            _builder.append(" {");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            _builder.append("return nullptr;");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
        } else {
            if (const_) {
                _builder.append("const ");
            }
            _builder.append(type);
            CharSequence _className_1 = this.getClassName();
            _builder.append((Object)_className_1);
            _builder.append("::");
            _builder.append(function);
            _builder.append("(const size_t paIndex)");
            if (const_) {
                _builder.append(" const");
            }
            _builder.append(" {");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            _builder.append("switch(paIndex) {");
            _builder.newLine();
            for (IInterfaceElement iInterfaceElement : variables) {
                _builder.append("    ");
                _builder.append("case ");
                int _indexOf = variables.indexOf(iInterfaceElement);
                _builder.append((Object)_indexOf, "    ");
                _builder.append(": return &");
                CharSequence _generateName = ForteNgExportUtil.generateName(iInterfaceElement);
                _builder.append((Object)_generateName, "    ");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("  ");
            _builder.append("}");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("return nullptr;");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence generateVariableDefaultValue(VarDeclaration decl) {
        try {
            ILanguageSupport _get = this.variableLanguageSupport.get(decl);
            CharSequence _generate = null;
            if (_get != null) {
                _generate = _get.generate(CollectionLiterals.emptyMap());
            }
            return _generate;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public CharSequence generateVariableTypeName(VarDeclaration decl) {
        try {
            ILanguageSupport _get = this.variableLanguageSupport.get(decl);
            CharSequence _generate = null;
            if (_get != null) {
                Pair _mappedTo = Pair.of((Object)"type", (Object)Boolean.TRUE);
                _generate = _get.generate(Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{_mappedTo})));
            }
            return _generate;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public CharSequence generateVariableTypeNameAsInputParameter(VarDeclaration decl) {
        try {
            ILanguageSupport _get = this.variableLanguageSupport.get(decl);
            CharSequence _generate = null;
            if (_get != null) {
                Pair _mappedTo = Pair.of((Object)"type_in_param", (Object)Boolean.TRUE);
                _generate = _get.generate(Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{_mappedTo})));
            }
            return _generate;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public CharSequence generateVariableTypeNameAsInOutParameter(VarDeclaration decl) {
        try {
            ILanguageSupport _get = this.variableLanguageSupport.get(decl);
            CharSequence _generate = null;
            if (_get != null) {
                Pair _mappedTo = Pair.of((Object)"type_in_out_param", (Object)Boolean.TRUE);
                _generate = _get.generate(Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{_mappedTo})));
            }
            return _generate;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public CharSequence generateVariableTypeNameAsOutputParameter(VarDeclaration decl) {
        try {
            ILanguageSupport _get = this.variableLanguageSupport.get(decl);
            CharSequence _generate = null;
            if (_get != null) {
                Pair _mappedTo = Pair.of((Object)"type_out_param", (Object)Boolean.TRUE);
                _generate = _get.generate(Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{_mappedTo})));
            }
            return _generate;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected CharSequence generateParameters(ICallable callable) {
        StringConcatenation _builder = new StringConcatenation();
        Iterable<VarDeclaration> _callableParameters = this.getCallableParameters(callable);
        boolean _hasElements = false;
        for (VarDeclaration param : _callableParameters) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            CharSequence _generateParameter = this.generateParameter(param);
            _builder.append((Object)_generateParameter);
        }
        return _builder;
    }

    protected CharSequence generateForwardArguments(ICallable callable) {
        StringConcatenation _builder = new StringConcatenation();
        Iterable<VarDeclaration> _callableParameters = this.getCallableParameters(callable);
        boolean _hasElements = false;
        for (VarDeclaration param : _callableParameters) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            CharSequence _generateForwardArgument = this.generateForwardArgument(param);
            _builder.append((Object)_generateForwardArgument);
        }
        return _builder;
    }

    protected CharSequence generateParameter(VarDeclaration param) {
        StringConcatenation _xifexpression = null;
        boolean _isInOutVar = param.isInOutVar();
        if (_isInOutVar) {
            StringConcatenation _builder = new StringConcatenation();
            CharSequence _generateVariableTypeNameAsInOutParameter = this.generateVariableTypeNameAsInOutParameter(param);
            _builder.append((Object)_generateVariableTypeNameAsInOutParameter);
            _builder.append(" &");
            CharSequence _generateNameAsParameter = ForteNgExportUtil.generateNameAsParameter(param);
            _builder.append((Object)_generateNameAsParameter);
            _xifexpression = _builder;
        } else {
            StringConcatenation _xifexpression_1 = null;
            boolean _isIsInput = param.isIsInput();
            if (_isIsInput) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("const ");
                CharSequence _generateVariableTypeNameAsInputParameter = this.generateVariableTypeNameAsInputParameter(param);
                _builder_1.append((Object)_generateVariableTypeNameAsInputParameter);
                _builder_1.append(" &");
                CharSequence _generateNameAsParameter_1 = ForteNgExportUtil.generateNameAsParameter(param);
                _builder_1.append((Object)_generateNameAsParameter_1);
                _xifexpression_1 = _builder_1;
            } else {
                StringConcatenation _builder_2 = new StringConcatenation();
                CharSequence _generateVariableTypeNameAsOutputParameter = this.generateVariableTypeNameAsOutputParameter(param);
                _builder_2.append((Object)_generateVariableTypeNameAsOutputParameter);
                _builder_2.append(" ");
                CharSequence _generateNameAsParameter_2 = ForteNgExportUtil.generateNameAsParameter(param);
                _builder_2.append((Object)_generateNameAsParameter_2);
                _xifexpression_1 = _builder_2;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    protected CharSequence generateForwardArgument(VarDeclaration param) {
        StringConcatenation _xifexpression = null;
        boolean _isInOutVar = param.isInOutVar();
        if (_isInOutVar) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("std::forward<");
            CharSequence _generateVariableTypeNameAsInOutParameter = this.generateVariableTypeNameAsInOutParameter(param);
            _builder.append((Object)_generateVariableTypeNameAsInOutParameter);
            _builder.append(" &>(");
            CharSequence _generateNameAsParameter = ForteNgExportUtil.generateNameAsParameter(param);
            _builder.append((Object)_generateNameAsParameter);
            _builder.append(")");
            _xifexpression = _builder;
        } else {
            StringConcatenation _xifexpression_1 = null;
            boolean _isIsInput = param.isIsInput();
            if (_isIsInput) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("std::forward<const ");
                CharSequence _generateVariableTypeNameAsInputParameter = this.generateVariableTypeNameAsInputParameter(param);
                _builder_1.append((Object)_generateVariableTypeNameAsInputParameter);
                _builder_1.append(" &>(");
                CharSequence _generateNameAsParameter_1 = ForteNgExportUtil.generateNameAsParameter(param);
                _builder_1.append((Object)_generateNameAsParameter_1);
                _builder_1.append(")");
                _xifexpression_1 = _builder_1;
            } else {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("std::forward<");
                CharSequence _generateVariableTypeNameAsOutputParameter = this.generateVariableTypeNameAsOutputParameter(param);
                _builder_2.append((Object)_generateVariableTypeNameAsOutputParameter);
                _builder_2.append(">(");
                CharSequence _generateNameAsParameter_2 = ForteNgExportUtil.generateNameAsParameter(param);
                _builder_2.append((Object)_generateNameAsParameter_2);
                _builder_2.append(")");
                _xifexpression_1 = _builder_2;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    protected Iterable<VarDeclaration> getCallableParameters(ICallable callable) {
        EList _inputParameters = callable.getInputParameters();
        EList _inOutParameters = callable.getInOutParameters();
        Iterable _plus = Iterables.concat((Iterable)_inputParameters, (Iterable)_inOutParameters);
        EList _outputParameters = callable.getOutputParameters();
        return Iterables.filter((Iterable)Iterables.concat((Iterable)_plus, (Iterable)_outputParameters), VarDeclaration.class);
    }

    protected CharSequence generateOutputGuard(VarDeclaration variable) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("COutputGuard guard_");
        String _name = variable.getName();
        _builder.append(_name);
        _builder.append("(");
        CharSequence _generateNameAsParameter = ForteNgExportUtil.generateNameAsParameter(variable);
        _builder.append((Object)_generateNameAsParameter);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected String getFORTENameList(List<? extends INamedElement> elements) {
        Functions.Function1 _function = it -> ForteNgExportUtil.getFORTEStringId(it.getName());
        return IterableExtensions.join((Iterable)ListExtensions.map(elements, (Functions.Function1)_function), (CharSequence)", ");
    }

    protected String getFORTEEventTypeList(List<? extends Event> elements) {
        Functions.Function1 _function = it -> ForteNgExportUtil.getFORTEStringId(it.getTypeName());
        return IterableExtensions.join((Iterable)ListExtensions.map(elements, (Functions.Function1)_function), (CharSequence)", ");
    }

    public List<String> getErrors() {
        List _errors = super.getErrors();
        Functions.Function1 _function = it -> it.getErrors();
        Set _set = IterableExtensions.toSet((Iterable)IterableExtensions.flatMap((Iterable)IterableExtensions.filterNull(this.variableLanguageSupport.values()), (Functions.Function1)_function));
        return IterableExtensions.toList((Iterable)Iterables.concat((Iterable)_errors, (Iterable)_set));
    }

    public List<String> getWarnings() {
        List _warnings = super.getWarnings();
        Functions.Function1 _function = it -> it.getWarnings();
        Set _set = IterableExtensions.toSet((Iterable)IterableExtensions.flatMap((Iterable)IterableExtensions.filterNull(this.variableLanguageSupport.values()), (Functions.Function1)_function));
        return IterableExtensions.toList((Iterable)Iterables.concat((Iterable)_warnings, (Iterable)_set));
    }

    public List<String> getInfos() {
        List _infos = super.getInfos();
        Functions.Function1 _function = it -> it.getInfos();
        Set _set = IterableExtensions.toSet((Iterable)IterableExtensions.flatMap((Iterable)IterableExtensions.filterNull(this.variableLanguageSupport.values()), (Functions.Function1)_function));
        return IterableExtensions.toList((Iterable)Iterables.concat((Iterable)_infos, (Iterable)_set));
    }

    public Set<INamedElement> getDependencies(Map<?, ?> options) {
        Functions.Function1 _function = it -> it.getDependencies(options);
        return IterableExtensions.toSet((Iterable)IterableExtensions.flatMap((Iterable)IterableExtensions.filterNull(this.variableLanguageSupport.values()), (Functions.Function1)_function));
    }

    protected CharSequence generateTypeHash() {
        try {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("constexpr std::string_view TypeHash =\"");
            String _typeHash = this.type.getTypeEntry().getTypeHash();
            _builder.append(_typeHash);
            _builder.append("\"sv;");
            _builder.newLineIfNotEmpty();
            return _builder;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Pure
    protected T getType() {
        return this.type;
    }
}

