/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring.handler;

import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.typemanagement.refactoring.connection.ConnectionsToStructRefactoring;
import org.eclipse.fordiac.ide.typemanagement.wizards.ConnectionsToStructWizardPage;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.ui.handlers.HandlerUtil;

public class ConnectionsToStructHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            ISelection iSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            if (iSelection instanceof IStructuredSelection) {
                IStructuredSelection selection = (IStructuredSelection)iSelection;
                List<Connection> connections = selection.stream().filter(EditPart.class::isInstance).map(EditPart.class::cast).map(EditPart::getModel).filter(Connection.class::isInstance).map(Connection.class::cast).toList();
                FBType sourceType = connections.get(0).getSourceElement().getType();
                FBType destinationType = connections.get(0).getDestinationElement().getType();
                HashMap<String, String> replacableConMap = new HashMap<String, String>();
                connections.stream().forEach(con -> {
                    String string = replacableConMap.put(con.getSource().getName(), con.getDestination().getName());
                });
                ConnectionsToStructRefactoring refactoring = new ConnectionsToStructRefactoring(sourceType, destinationType, replacableConMap);
                RefactoringWizard wizard = new RefactoringWizard(refactoring, 36){

                    protected void addUserInputPages() {
                        this.addPage((IWizardPage)new ConnectionsToStructWizardPage());
                    }
                };
                RefactoringWizardOpenOperation openOperation = new RefactoringWizardOpenOperation(wizard);
                openOperation.run(HandlerUtil.getActiveShell((ExecutionEvent)event), refactoring.getName());
            }
        }
        catch (Exception e) {
            FordiacLogHelper.logError((String)"Error during ReplaceStruct refactoring", (Throwable)e);
        }
        return null;
    }
}

