/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.handler;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.fb.interpreter.mm.FBTestRunner;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.Messages;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceSequence;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class RunServiceSequenceHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        for (Object selected : selection.toList()) {
            ServiceSequence seq = RunServiceSequenceHandler.getSequence(selected);
            if (seq == null) continue;
            FBType fbType = (FBType)EcoreUtil.copy((EObject)seq.getService().getFBType());
            Optional result = seq.getStartState() != null && !seq.getStartState().isBlank() ? FBTestRunner.runFBTest((FBType)fbType, (ServiceSequence)seq, (String)seq.getStartState()) : FBTestRunner.runFBTest((FBType)fbType, (ServiceSequence)seq);
            if (result.isEmpty()) {
                MessageDialog.openInformation((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)Messages.RunServiceSequenceHandler_Success, (String)Messages.RunServiceSequenceHandler_SequenceMatchesECC);
                continue;
            }
            MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)Messages.RunServiceSequenceHandler_InconsistencyDetected, (String)(Messages.RunServiceSequenceHandler_SequenceDoesNotMatchECC + ":\n" + (String)result.get()));
        }
        return Status.OK_STATUS;
    }

    public void setEnabled(Object evaluationContext) {
        ISelection selection = (ISelection)HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        this.setBaseEnabled(!RunServiceSequenceHandler.getSelectedSequences(selection).isEmpty());
    }

    private static List<ServiceSequence> getSelectedSequences(ISelection selection) {
        if (selection instanceof StructuredSelection) {
            StructuredSelection structSel = (StructuredSelection)selection;
            return structSel.toList().stream().map(RunServiceSequenceHandler::getSequence).filter(Objects::nonNull).toList();
        }
        return Collections.emptyList();
    }

    private static ServiceSequence getSequence(Object selected) {
        if (selected instanceof EditPart) {
            EditPart ep = (EditPart)selected;
            selected = ep.getModel();
        }
        if (selected instanceof ServiceSequence) {
            ServiceSequence serviceSeq = (ServiceSequence)selected;
            return serviceSeq;
        }
        return null;
    }
}

