/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.common.OCLCommon;
import org.eclipse.ocl.common.preferences.PreferenceableOption;
import org.eclipse.ocl.internal.OCLPlugin;
import org.eclipse.ocl.internal.evaluation.NumberUtil;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.options.Customizable;
import org.eclipse.ocl.options.Option;
import org.eclipse.ocl.types.TupleType;
import org.eclipse.ocl.util.Adaptable;
import org.eclipse.ocl.util.CollectionUtil;
import org.eclipse.ocl.util.OCLUtil;
import org.eclipse.ocl.util.Tuple;

public abstract class AbstractEvaluationEnvironment<C, O, P, CLS, E>
implements EvaluationEnvironment<C, O, P, CLS, E>,
Adaptable,
Customizable {
    private final EvaluationEnvironment<C, O, P, CLS, E> parent;
    private final Map<String, Object> map = new HashMap<String, Object>();
    private final Map<Option<?>, Object> options = new HashMap();

    protected AbstractEvaluationEnvironment() {
        this(null);
    }

    protected AbstractEvaluationEnvironment(EvaluationEnvironment<C, O, P, CLS, E> parent) {
        this.parent = parent;
    }

    protected EvaluationEnvironment<C, O, P, CLS, E> getParent() {
        return this.parent;
    }

    @Override
    public Object getValueOf(String name) {
        return this.map.get(name);
    }

    @Override
    public void replace(String name, Object value) {
        this.map.put(name, value);
    }

    @Override
    public void add(String name, Object value) {
        if (this.map.containsKey(name)) {
            String message = OCLMessages.bind(OCLMessages.BindingExist_ERROR_, name, this.map.get(name));
            throw new IllegalArgumentException(message);
        }
        this.map.put(name, value);
    }

    @Override
    public Object remove(String name) {
        return this.map.remove(name);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public boolean overrides(O operation, int opcode) {
        return this.getParent() != null ? this.getParent().overrides(operation, opcode) : false;
    }

    @Override
    public Object callOperation(O operation, int opcode, Object source, Object[] args) throws IllegalArgumentException {
        if (this.getParent() != null) {
            return this.getParent().callOperation(operation, opcode, source, args);
        }
        Method method = this.getJavaMethodFor(operation, source);
        if (method != null) {
            try {
                Class<?>[] parmTypes = method.getParameterTypes();
                int i = 0;
                while (i < parmTypes.length) {
                    if (EList.class.isAssignableFrom(parmTypes[i])) {
                        if (args[i] == null) {
                            args[i] = ECollections.EMPTY_ELIST;
                        } else if (!(args[i] instanceof Collection)) {
                            BasicEList.FastCompare list = new BasicEList.FastCompare(1);
                            list.add(args[i]);
                            args[i] = list;
                        } else if (!(args[i] instanceof EList)) {
                            args[i] = new BasicEList.FastCompare((Collection)args[i]);
                        }
                    }
                    ++i;
                }
                return method.invoke(source, args);
            }
            catch (Exception e) {
                String context = "callOperation - " + method.toString();
                OCLPlugin.catching(this.getClass(), context, e);
                OCLPlugin.log(2, 10, OCLMessages.bind(OCLMessages.ErrorMessage_ERROR_, context, e.getLocalizedMessage()), e);
                return this.getInvalidResult();
            }
        }
        switch (opcode) {
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                if (!(source instanceof Comparable) || args.length != 1) break;
                Comparable comparable = (Comparable)source;
                Object other = args[0];
                switch (opcode) {
                    case 67: {
                        if (comparable.compareTo(other) < 0) {
                            return true;
                        }
                        return false;
                    }
                    case 68: {
                        if (comparable.compareTo(other) > 0) {
                            return true;
                        }
                        return false;
                    }
                    case 69: {
                        if (comparable.compareTo(other) <= 0) {
                            return true;
                        }
                        return false;
                    }
                    case 70: {
                        if (comparable.compareTo(other) >= 0) {
                            return true;
                        }
                        return false;
                    }
                }
            }
        }
        throw new IllegalArgumentException();
    }

    protected abstract Method getJavaMethodFor(O var1, Object var2);

    protected abstract Object getInvalidResult();

    @Override
    public <T> T getAdapter(Class<T> adapterType) {
        AbstractEvaluationEnvironment<C, O, P, CLS, E> result = adapterType.isInstance(this) ? this : null;
        return (T)result;
    }

    protected Map<Option<?>, Object> basicGetOptions() {
        return this.options;
    }

    @Override
    public Map<Option<?>, Object> getOptions() {
        Customizable parent = this.getParent() != null ? OCLUtil.getAdapter(this.getParent(), Customizable.class) : null;
        HashMap result = parent != null ? new HashMap(parent.getOptions()) : new HashMap();
        result.putAll(this.basicGetOptions());
        return result;
    }

    @Override
    public <T> void setOption(Option<T> option, T value) {
        this.basicGetOptions().put(option, value);
    }

    @Override
    public <T> void putOptions(Map<? extends Option<T>, ? extends T> options) {
        Map<Option<?>, Object> myOptions = this.basicGetOptions();
        myOptions.clear();
        myOptions.putAll(options);
    }

    @Override
    public <T> T removeOption(Option<T> option) {
        T result = this.getValue(option);
        this.basicGetOptions().remove(option);
        return result;
    }

    @Override
    public <T> Map<Option<T>, T> removeOptions(Collection<Option<T>> options) {
        HashMap<Option<T>, T> result = new HashMap<Option<T>, T>();
        Map<Option<?>, Object> myOptions = this.basicGetOptions();
        for (Option<T> next : options) {
            result.put(next, this.getValue(next));
            myOptions.remove(next);
        }
        return result;
    }

    @Override
    public Map<Option<?>, Object> clearOptions() {
        Map<Option<?>, Object> myOptions = this.basicGetOptions();
        HashMap result = new HashMap(myOptions);
        myOptions.clear();
        return result;
    }

    @Override
    public boolean isEnabled(Option<Boolean> option) {
        Boolean result = this.getValue(option);
        return result == null ? false : result;
    }

    @Override
    public <T> T getValue(Option<T> option) {
        Map<Option<?>, Object> options = this.basicGetOptions();
        Object result = options.get(option);
        if (result == null && !options.containsKey(option)) {
            Customizable parent;
            Customizable customizable = parent = this.getParent() != null ? OCLUtil.getAdapter(this.getParent(), Customizable.class) : null;
            if (parent != null) {
                result = parent.getValue(option);
            } else {
                if (option instanceof PreferenceableOption) {
                    PreferenceableOption preferenceOption = (PreferenceableOption)option;
                    result = OCLCommon.getPreference((PreferenceableOption)preferenceOption, null);
                } else {
                    result = option.getDefaultValue();
                }
                options.put(option, result);
            }
        }
        return (T)result;
    }

    protected static abstract class AbstractTuple<O, P>
    implements Tuple<O, P> {
        private final TupleType<O, P> type;
        private final Map<String, Object> parts = new HashMap<String, Object>();
        private Integer hashCode = null;

        protected AbstractTuple(TupleType<O, P> type, Map<P, Object> values) {
            this.type = type;
            for (Map.Entry<P, Object> entry : values.entrySet()) {
                this.parts.put(this.getName(entry.getKey()), entry.getValue());
            }
        }

        protected abstract String getName(P var1);

        @Override
        public TupleType<O, P> getTupleType() {
            return this.type;
        }

        @Override
        public Object getValue(String partName) {
            Object partValue = this.parts.get(partName);
            if (partValue instanceof Number) {
                partValue = NumberUtil.coerceNumber((Number)partValue);
            }
            return partValue;
        }

        @Override
        public Object getValue(P part) {
            return this.getValue(this.getName(part));
        }

        public boolean equals(Object o) {
            boolean result = o instanceof AbstractTuple;
            if (result) {
                AbstractTuple other = (AbstractTuple)o;
                result &= other.type.equals(this.type);
                result &= other.parts.equals(this.parts);
            }
            return result;
        }

        public int hashCode() {
            if (this.hashCode == null) {
                int typeHashCode = this.type.hashCode();
                int partsHashCode = this.parts.hashCode();
                this.hashCode = 37 * typeHashCode + 17 * partsHashCode;
            }
            return this.hashCode;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("Tuple{");
            Iterator iter = this.getTupleType().oclProperties().iterator();
            while (iter.hasNext()) {
                Object p = iter.next();
                result.append(this.getName(p));
                result.append(" = ");
                result.append(this.toString(this.getValue(p)));
                if (!iter.hasNext()) continue;
                result.append(", ");
            }
            result.append("}");
            return result.toString();
        }

        private String toString(Object o) {
            if (o instanceof String) {
                return "'" + (String)o + "'";
            }
            if (o instanceof Collection) {
                return CollectionUtil.toString((Collection)o);
            }
            if (o == null) {
                return "null";
            }
            return o.toString();
        }
    }
}

