/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.html;

import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.text.html.RGB;

public class HTMLBuilder {
    private static volatile RGB DEFAULT_BG_COLOR_RGB = new RGB(255, 255, 225);
    private static volatile RGB DEFAULT_FG_COLOR_RGB = new RGB(0, 0, 0);
    private static volatile RGB DEFAULT_LINK_COLOR_RGB = new RGB(0, 0, 255);
    private static volatile RGB DEFAULT_ACTIVE_LINK_COLOR_RGB = new RGB(0, 0, 128);
    private static final String UNIT = Platform.OS.isMac() ? "px" : "pt";
    private RGB bgColor;
    private RGB fgColor;
    private RGB linkColor;
    private RGB alinkColor;

    public HTMLBuilder() {
        this(DEFAULT_BG_COLOR_RGB, DEFAULT_FG_COLOR_RGB, DEFAULT_LINK_COLOR_RGB, DEFAULT_ACTIVE_LINK_COLOR_RGB);
    }

    public HTMLBuilder(RGB bg, RGB fg, RGB link, RGB alink) {
        this.setColors(bg, fg, link, alink);
    }

    public void setColors(RGB bg, RGB fg, RGB link, RGB alink) {
        this.bgColor = bg != null ? bg : DEFAULT_BG_COLOR_RGB;
        this.fgColor = fg != null ? fg : DEFAULT_FG_COLOR_RGB;
        this.linkColor = link != null ? link : DEFAULT_LINK_COLOR_RGB;
        this.alinkColor = alink != null ? alink : DEFAULT_ACTIVE_LINK_COLOR_RGB;
    }

    private static String replace(String text, char c, String s) {
        int previous = 0;
        int current = text.indexOf(c, previous);
        if (current == -1) {
            return text;
        }
        StringBuilder buffer = new StringBuilder();
        while (current > -1) {
            buffer.append(text.substring(previous, current));
            buffer.append(s);
            previous = current + 1;
            current = text.indexOf(c, previous);
        }
        buffer.append(text.substring(previous));
        return buffer.toString();
    }

    public static String convertToHTMLContent(String content) {
        content = HTMLBuilder.replace(content, '&', "&amp;");
        content = HTMLBuilder.replace(content, '\"', "&quot;");
        content = HTMLBuilder.replace(content, '<', "&lt;");
        return HTMLBuilder.replace(content, '>', "&gt;");
    }

    public static String convertToHTMLContentWithWhitespace(String content) {
        content = HTMLBuilder.replace(content, '&', "&amp;");
        content = HTMLBuilder.replace(content, '\"', "&quot;");
        content = HTMLBuilder.replace(content, '<', "&lt;");
        content = HTMLBuilder.replace(content, '>', "&gt;");
        return "<span style='white-space:pre'>" + content + "</span>";
    }

    public static String read(Reader rd) {
        StringBuilder buffer = new StringBuilder();
        char[] readBuffer = new char[2048];
        try {
            int n = rd.read(readBuffer);
            while (n > 0) {
                buffer.append(readBuffer, 0, n);
                n = rd.read(readBuffer);
            }
            return buffer.toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void insertPageProlog(StringBuilder buffer, int position, RGB fgRGB, RGB bgRGB, String styleSheet) {
        if (fgRGB == null) {
            fgRGB = this.fgColor;
        }
        if (bgRGB == null) {
            bgRGB = this.bgColor;
        }
        StringBuilder pageProlog = new StringBuilder(300);
        pageProlog.append("<html>");
        this.appendStyleSheet(pageProlog, styleSheet, fgRGB, bgRGB);
        this.appendColors(pageProlog, fgRGB, bgRGB);
        buffer.insert(position, pageProlog.toString());
    }

    private void appendColors(StringBuilder pageProlog, RGB fgRGB, RGB bgRGB) {
        pageProlog.append("<body text=\"");
        this.appendColor(pageProlog, fgRGB);
        pageProlog.append("\" bgcolor=\"");
        this.appendColor(pageProlog, bgRGB);
        pageProlog.append("\">");
    }

    private void appendColor(StringBuilder buffer, RGB rgb) {
        buffer.append('#');
        this.appendAsHexString(buffer, rgb.red);
        this.appendAsHexString(buffer, rgb.green);
        this.appendAsHexString(buffer, rgb.blue);
    }

    private void appendAsHexString(StringBuilder buffer, int intValue) {
        String hexValue = Integer.toHexString(intValue);
        if (hexValue.length() == 1) {
            buffer.append('0');
        }
        buffer.append(hexValue);
    }

    public void insertStyles(StringBuilder buffer, String[] styles) {
        if (styles == null || styles.length == 0) {
            return;
        }
        StringBuilder styleBuf = new StringBuilder(10 * styles.length);
        String[] stringArray = styles;
        int n = styles.length;
        int n2 = 0;
        while (n2 < n) {
            String style = stringArray[n2];
            styleBuf.append(" style=\"");
            styleBuf.append(style);
            styleBuf.append('\"');
            ++n2;
        }
        int index = buffer.indexOf("<body ");
        if (index != -1) {
            buffer.insert(index + 5, styleBuf);
            return;
        }
        index = buffer.indexOf("<body>");
        if (index != -1) {
            buffer.insert(index + 5, ' ');
            buffer.insert(index + 6, styleBuf);
            return;
        }
    }

    private void appendStyleSheet(StringBuilder buffer, String styleSheet, RGB fgRGB, RGB bgRGB) {
        if (styleSheet == null) {
            return;
        }
        StringBuilder fg = new StringBuilder();
        this.appendColor(fg, fgRGB);
        styleSheet = styleSheet.replaceAll("InfoText", fg.toString());
        StringBuilder bg = new StringBuilder();
        this.appendColor(bg, bgRGB);
        styleSheet = styleSheet.replaceAll("InfoBackground", bg.toString());
        StringBuilder lColor = new StringBuilder();
        this.appendColor(lColor, this.linkColor);
        styleSheet = styleSheet.replaceAll("hyperlinkColor", lColor.toString());
        StringBuilder activeLinkColor = new StringBuilder();
        this.appendColor(activeLinkColor, this.alinkColor);
        styleSheet = styleSheet.replaceAll("activeHyperlinkColor", activeLinkColor.toString());
        buffer.append("<head><style CHARSET=\"ISO-8859-1\" TYPE=\"text/css\">");
        buffer.append(styleSheet);
        buffer.append("</style></head>");
    }

    private static void appendStyleSheetURL(StringBuilder buffer, URL styleSheetURL) {
        if (styleSheetURL == null) {
            return;
        }
        buffer.append("<head>");
        buffer.append("<LINK REL=\"stylesheet\" HREF= \"");
        buffer.append(styleSheetURL);
        buffer.append("\" CHARSET=\"ISO-8859-1\" TYPE=\"text/css\">");
        buffer.append("</head>");
    }

    public void insertPageProlog(StringBuilder buffer, int position) {
        StringBuilder pageProlog = new StringBuilder(60);
        pageProlog.append("<html>");
        this.appendColors(pageProlog, this.fgColor, this.bgColor);
        buffer.insert(position, pageProlog.toString());
    }

    public void insertPageProlog(StringBuilder buffer, int position, URL styleSheetURL) {
        StringBuilder pageProlog = new StringBuilder(300);
        pageProlog.append("<html>");
        HTMLBuilder.appendStyleSheetURL(pageProlog, styleSheetURL);
        this.appendColors(pageProlog, this.fgColor, this.bgColor);
        buffer.insert(position, pageProlog.toString());
    }

    public void insertPageProlog(StringBuilder buffer, int position, String styleSheet) {
        this.insertPageProlog(buffer, position, null, null, styleSheet);
    }

    public void addPageProlog(StringBuilder buffer) {
        this.insertPageProlog(buffer, buffer.length());
    }

    public void addPageEpilog(StringBuilder buffer) {
        buffer.append("</body></html>");
    }

    public void startBulletList(StringBuilder buffer) {
        buffer.append("<ul>");
    }

    public void endBulletList(StringBuilder buffer) {
        buffer.append("</ul>");
    }

    public void addBullet(StringBuilder buffer, String bullet) {
        if (bullet != null) {
            buffer.append("<li>");
            buffer.append(bullet);
            buffer.append("</li>");
        }
    }

    public void addSmallHeader(StringBuilder buffer, String header) {
        if (header != null) {
            buffer.append("<h5>");
            buffer.append(header);
            buffer.append("</h5>");
        }
    }

    public void addParagraph(StringBuilder buffer, String paragraph) {
        if (paragraph != null) {
            buffer.append("<p>");
            buffer.append(paragraph);
        }
    }

    public void addPreFormatted(StringBuilder buffer, String preFormatted) {
        if (preFormatted != null) {
            buffer.append("<pre>");
            buffer.append(preFormatted);
            buffer.append("</pre>");
        }
    }

    public void addParagraph(StringBuilder buffer, Reader paragraphReader) {
        if (paragraphReader != null) {
            this.addParagraph(buffer, HTMLBuilder.read(paragraphReader));
        }
    }

    public static String convertTopLevelFont(String styles, boolean bold, boolean italic, int height, String fontName) {
        String size = Integer.toString(height) + UNIT;
        String family = "'" + fontName + "',sans-serif";
        styles = styles.replaceFirst("(html\\s*\\{.*(?:\\s|;)font-size:\\s*)\\d+pt(\\;?.*\\})", "$1" + size + "$2");
        styles = styles.replaceFirst("(html\\s*\\{.*(?:\\s|;)font-weight:\\s*)\\w+(\\;?.*\\})", "$1" + (bold ? "bold" : "normal") + "$2");
        styles = styles.replaceFirst("(html\\s*\\{.*(?:\\s|;)font-style:\\s*)\\w+(\\;?.*\\})", "$1" + (italic ? "italic" : "normal") + "$2");
        styles = styles.replaceFirst("(html\\s*\\{.*(?:\\s|;)font-family:\\s*).+?(;.*\\})", "$1" + family + "$2");
        return styles;
    }
}

