/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.model.edit;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.formatting2.regionaccess.ITextReplacement;
import org.eclipse.xtext.ide.serializer.IEmfResourceChange;
import org.eclipse.xtext.ide.serializer.ITextDocumentChange;
import org.eclipse.xtext.ide.serializer.impl.ChangeSerializer;
import org.eclipse.xtext.ui.editor.model.edit.ITextEditComposer;

public class ChangeSerializerTextEditComposer
extends ChangeSerializer
implements ITextEditComposer {
    private Resource recording;
    private TextEdit result;

    public ChangeSerializerTextEditComposer() {
        this.setUpdateCrossReferences(false);
        this.setUpdateRelatedFiles(false);
    }

    @Override
    public void beginRecording(Resource resource) {
        this.resetState();
        this.recording = resource;
        super.beginRecordChanges(resource);
    }

    protected void collectChanges(IEmfResourceChange e, List<TextEdit> edits) {
        if (e instanceof ITextDocumentChange && e.getResource() == this.recording) {
            ITextDocumentChange change = (ITextDocumentChange)e;
            for (ITextReplacement c : change.getReplacements()) {
                ReplaceEdit edit = new ReplaceEdit(c.getOffset(), c.getLength(), c.getReplacementText());
                edits.add((TextEdit)edit);
            }
        }
    }

    @Override
    public TextEdit endRecording() {
        if (this.recording == null) {
            return null;
        }
        this.result = this.endRecordingAndCompose();
        this.recording = null;
        return this.result;
    }

    protected TextEdit endRecordingAndCompose() {
        ArrayList edits = Lists.newArrayList();
        super.endRecordChanges(change -> this.collectChanges((IEmfResourceChange)change, edits));
        if (edits.isEmpty()) {
            return null;
        }
        if (edits.size() == 1) {
            return (TextEdit)edits.get(0);
        }
        MultiTextEdit multi = new MultiTextEdit();
        for (TextEdit e : edits) {
            multi.addChild(e);
        }
        return multi;
    }

    @Override
    public TextEdit getTextEdit() {
        return this.result;
    }

    protected void resetState() {
        super.resetState();
        this.recording = null;
        this.result = null;
    }
}

