/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.preferences;

import org.eclipse.fordiac.ide.gef.Messages;
import org.eclipse.fordiac.ide.gef.preferences.GefPreferenceConstants;
import org.eclipse.fordiac.ide.model.preferences.ModelPreferenceConstants;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class DiagramPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private boolean changesOnLabelSize = false;
    private static int maxDefaultValueLength = GefPreferenceConstants.STORE.getInt("MaxDefaultValueLength");

    public DiagramPreferencePage() {
        super(1);
        this.setPreferenceStore(GefPreferenceConstants.STORE);
    }

    public void createFieldEditors() {
        this.createGroupRulerGrid();
        this.createGroupLabelSize();
        this.createGroupInterfacePins();
        this.createGroupLayoutOptionsPins();
        this.createGroupBlockMargins();
        this.createExpandedInterfaceOptionsPins();
    }

    private Group createGroup(String title) {
        Group group = new Group(this.getFieldEditorParent(), 0);
        group.setText(title);
        return group;
    }

    private static void configGroup(Group group) {
        GridLayout gridLayout = new GridLayout(2, false);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)gridData);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() instanceof FieldEditor && DiagramPreferencePage.matchPreferenceName(event)) {
            this.changesOnLabelSize = true;
        }
    }

    private static boolean matchPreferenceName(PropertyChangeEvent event) {
        String sourcePrefName = ((FieldEditor)event.getSource()).getPreferenceName();
        return sourcePrefName.equalsIgnoreCase("MinPinLabelSize") || sourcePrefName.equalsIgnoreCase("MaxPinLabelSize") || sourcePrefName.equalsIgnoreCase("MaxTypeLabelSize") || sourcePrefName.equalsIgnoreCase("MaxValueLabelSize") || sourcePrefName.equalsIgnoreCase("MaxDefaultValueLength") || sourcePrefName.equalsIgnoreCase("MaxHiddenConnectionLabelSize") || sourcePrefName.equalsIgnoreCase("PinLabelStyle") || sourcePrefName.equalsIgnoreCase("MaxInterfaceBarSize") || sourcePrefName.equalsIgnoreCase("MinInterfaceBarSize") || sourcePrefName.equalsIgnoreCase("ExpandedInterfaceEventsTop") || sourcePrefName.equalsIgnoreCase("ExpandedInterfaceOldDirectBehaviour");
    }

    public boolean performOk() {
        super.performOk();
        if (this.changesOnLabelSize) {
            this.changesOnLabelSize = false;
            DiagramPreferencePage.showMessageBox();
        }
        return true;
    }

    private static void showMessageBox() {
        MessageBox msgBox = new MessageBox(Display.getDefault().getActiveShell(), 192);
        Display.getDefault().getActiveShell();
        msgBox.setText("4diac IDE");
        msgBox.setMessage(Messages.DiagramPreferences_Restart);
        switch (msgBox.open()) {
            case 128: {
                break;
            }
            case 64: {
                PlatformUI.getWorkbench().restart();
                break;
            }
        }
    }

    private void createGroupLabelSize() {
        Group labelSize = this.createGroup(Messages.DiagramPreferences_LabelSize);
        IntegerFieldEditor integerFieldEditorLabel = new IntegerFieldEditor("MaxValueLabelSize", Messages.DiagramPreferences_MaximumValueLabelSize, (Composite)labelSize);
        integerFieldEditorLabel.setValidRange(0, 120);
        this.addField((FieldEditor)integerFieldEditorLabel);
        IntegerFieldEditor integerFieldEditorValue = new IntegerFieldEditor("MaxDefaultValueLength", Messages.DiagramPreferences_MaximumDefaultValueSize, (Composite)labelSize);
        integerFieldEditorValue.setValidRange(120, 100000);
        this.addField((FieldEditor)integerFieldEditorValue);
        IntegerFieldEditor integerFieldEditorTypeLabel = new IntegerFieldEditor("MaxTypeLabelSize", Messages.DiagramPreferences_MaximumTypeLabelSize, (Composite)labelSize);
        integerFieldEditorTypeLabel.setValidRange(0, 120);
        this.addField((FieldEditor)integerFieldEditorTypeLabel);
        IntegerFieldEditor integerFieldEditorMinPin = new IntegerFieldEditor("MinPinLabelSize", Messages.DiagramPreferences_MinimumPinLabelSize, (Composite)labelSize);
        integerFieldEditorMinPin.setValidRange(0, 60);
        this.addField((FieldEditor)integerFieldEditorMinPin);
        IntegerFieldEditor integerFieldEditorMaxPin = new IntegerFieldEditor("MaxPinLabelSize", Messages.DiagramPreferences_MaximumPinLabelSize, (Composite)labelSize);
        integerFieldEditorMaxPin.setValidRange(0, 60);
        this.addField((FieldEditor)integerFieldEditorMaxPin);
        IntegerFieldEditor integerFieldEditorMinInterfaceBarWidth = new IntegerFieldEditor("MinInterfaceBarSize", Messages.DiagramPreferences_MinimumInterfaceBarSize, (Composite)labelSize);
        integerFieldEditorMinInterfaceBarWidth.setValidRange(0, 100);
        this.addField((FieldEditor)integerFieldEditorMinInterfaceBarWidth);
        IntegerFieldEditor integerFieldEditorInterfaceBar = new IntegerFieldEditor("MaxInterfaceBarSize", Messages.DiagramPreferences_MaximumInterfaceBarSize, (Composite)labelSize);
        integerFieldEditorInterfaceBar.setValidRange(0, 100);
        this.addField((FieldEditor)integerFieldEditorInterfaceBar);
        IntegerFieldEditor integerFieldEditorConnection = new IntegerFieldEditor("MaxHiddenConnectionLabelSize", Messages.DiagramPreferences_MaximumHiddenConnectionLabelSize, (Composite)labelSize);
        integerFieldEditorConnection.setValidRange(0, 100);
        this.addField((FieldEditor)integerFieldEditorConnection);
        DiagramPreferencePage.configGroup(labelSize);
    }

    private void createGroupRulerGrid() {
        Group group = this.createGroup(Messages.DiagramPreferences_FieldEditors_RulerAndGrid);
        BooleanFieldEditor showRulers = new BooleanFieldEditor("ShowRulers", Messages.DiagramPreferences_FieldEditors_ShowRuler, (Composite)group);
        this.addField((FieldEditor)showRulers);
        BooleanFieldEditor showGrid = new BooleanFieldEditor("ShowGrid", Messages.DiagramPreferences_FieldEditors_ShowGrid, (Composite)group);
        this.addField((FieldEditor)showGrid);
        BooleanFieldEditor snapToGrid = new BooleanFieldEditor("SnapToGrid", Messages.DiagramPreferences_FieldEditors_SnapToGrid, (Composite)group);
        this.addField((FieldEditor)snapToGrid);
        DiagramPreferencePage.configGroup(group);
    }

    private void createGroupLayoutOptionsPins() {
        Group group = this.createGroup(Messages.DiagramPreferences_LayoutOptions);
        BooleanFieldEditor connectionAutoLayout = new BooleanFieldEditor("ConnectionAutoLayout", Messages.DiagramPreferences_LayoutConnectionsAutomatically, (Composite)group);
        this.addField((FieldEditor)connectionAutoLayout);
        DiagramPreferencePage.configGroup(group);
    }

    private void createGroupInterfacePins() {
        this.addField((FieldEditor)new RadioGroupFieldEditor("PinLabelStyle", Messages.DiagramPreferences_PinLabelText, 1, (String[][])new String[][]{{Messages.DiagramPreferences_ShowPinName, "PinLabelStyle_PinName"}, {Messages.DiagramPreferences_ShowPinComment, "PinLabelStyle_PinComment"}, {Messages.DiagramPreferences_ShowConnectedOutputPinName, "PinLabelStyle_SourcePinName"}}, this.getFieldEditorParent(), true));
    }

    private void createGroupBlockMargins() {
        Group group = this.createGroup(Messages.DiagramPreferences_BlockMargins);
        IPreferenceStore modelStore = ModelPreferenceConstants.STORE;
        IntegerFieldEditor integerFieldEditorTopBottom = new IntegerFieldEditor("MarginTopBottom", Messages.DiagramPreferences_TopBottom, (Composite)group);
        integerFieldEditorTopBottom.setValidRange(0, 1000);
        integerFieldEditorTopBottom.setPreferenceStore(modelStore);
        this.addField((FieldEditor)integerFieldEditorTopBottom);
        IntegerFieldEditor integerFieldEditorLeftRight = new IntegerFieldEditor("MarginLeftRight", Messages.DiagramPreferences_LeftRight, (Composite)group);
        integerFieldEditorLeftRight.setValidRange(0, 1000);
        integerFieldEditorLeftRight.setPreferenceStore(modelStore);
        this.addField((FieldEditor)integerFieldEditorLeftRight);
        DiagramPreferencePage.configGroup(group);
    }

    private void createExpandedInterfaceOptionsPins() {
        Group group = this.createGroup(Messages.DiagramPreferences_ExpandedInterfaceGroupText);
        BooleanFieldEditor direct = new BooleanFieldEditor("ExpandedInterfaceOldDirectBehaviour", Messages.DiagramPreferences_ExpandedInterfaceStackPins, (Composite)group);
        BooleanFieldEditor events = new BooleanFieldEditor("ExpandedInterfaceEventsTop", Messages.DiagramPreferences_ExpandedInterfaceEvents, (Composite)group);
        this.addField((FieldEditor)direct);
        this.addField((FieldEditor)events);
        DiagramPreferencePage.configGroup(group);
        events.setEnabled(this.getPreferenceStore().getBoolean("ExpandedInterfaceOldDirectBehaviour"), (Composite)group);
        direct.getDescriptionControl((Composite)group).addListener(13, event -> {
            Button button = (Button)event.widget;
            boolean selection = button.getSelection();
            Button eventsButton = (Button)events.getDescriptionControl((Composite)group);
            events.setEnabled(selection, (Composite)group);
            eventsButton.setSelection(selection);
        });
    }

    public void init(IWorkbench workbench) {
    }

    public static int getMaxDefaultValueLength() {
        return maxDefaultValueLength;
    }
}

