/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.annotation;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationModelManager;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationProvider;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalMarkerAnnotation;
import org.eclipse.fordiac.ide.gef.annotation.ResourceMarkerGraphicalAnnotationModel;
import org.eclipse.fordiac.ide.model.errormarker.FordiacErrorMarker;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.ui.editors.text.EditorsUI;

public class FordiacMarkerGraphicalAnnotationModel
extends ResourceMarkerGraphicalAnnotationModel {
    private final Supplier<LibraryElement> libraryElementSupplier;
    private final List<GraphicalAnnotationProvider> providers;

    public FordiacMarkerGraphicalAnnotationModel(IResource resource, Supplier<LibraryElement> libraryElementSupplier) {
        super(resource);
        this.libraryElementSupplier = Objects.requireNonNull(libraryElementSupplier);
        this.providers = GraphicalAnnotationModelManager.getInstance().getProviders(this, resource);
        this.reload();
    }

    @Override
    protected GraphicalMarkerAnnotation createMarkerAnnotation(IMarker marker) {
        Object target;
        String type = EditorsUI.getAnnotationTypeLookup().getAnnotationType(marker);
        if (type != null && (target = this.findTarget(marker)) != null) {
            return new GraphicalMarkerAnnotation(marker, type, target);
        }
        return null;
    }

    protected Object findTarget(IMarker marker) {
        try {
            return FordiacErrorMarker.getTargetRelative((IMarker)marker, (LibraryElement)this.libraryElementSupplier.get());
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    protected boolean isTargetChanged(IMarkerDelta delta) {
        return delta.getKind() == 4 && !Objects.equals(delta.getAttribute("org.eclipse.fordiac.ide.model.iec61499.targetUri", null), delta.getMarker().getAttribute("org.eclipse.fordiac.ide.model.iec61499.targetUri", null));
    }

    @Override
    public void reload() {
        super.reload();
        this.providers.forEach(GraphicalAnnotationProvider::reload);
    }

    @Override
    public void dispose() {
        this.providers.forEach(GraphicalAnnotationProvider::dispose);
        super.dispose();
    }

    public LibraryElement getLibraryElement() {
        return this.libraryElementSupplier.get();
    }
}

