/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring;

import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.fordiac.ide.model.commands.change.ChangeAttributeValueCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.fordiac.ide.typemanagement.refactoring.AbstractCommandChange;
import org.eclipse.gef.commands.Command;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class AttributeValueChange
extends AbstractCommandChange<Attribute> {
    private final String newValue;
    private String oldValue;

    public AttributeValueChange(String name, URI elementURI, String newValue) {
        super(name, elementURI, Attribute.class);
        this.newValue = newValue;
    }

    @Override
    protected Command createCommand(Attribute element) {
        return new ChangeAttributeValueCommand(element, this.newValue);
    }

    @Override
    public void initializeValidationData(Attribute element, IProgressMonitor pm) {
        this.oldValue = element.getValue();
    }

    @Override
    public RefactoringStatus isValid(Attribute element, IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        if (!Objects.equals(element.getValue(), this.oldValue)) {
            status.addFatalError(Messages.AttributeValueChange_AttributeValueChanged);
        }
        return status;
    }
}

