/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.preferences;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.fordiac.ide.model.libraryElement.Identification;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.VersionInfo;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public final class TypeManagementPreferencesHelper {
    private TypeManagementPreferencesHelper() {
    }

    public static void setupVersionInfo(LibraryElement type) {
        VersionInfo versionInfo = LibraryElementFactory.eINSTANCE.createVersionInfo();
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.fordiac.ide.typemanagement");
        TypeManagementPreferencesHelper.setupVersion(versionInfo, (IPreferenceStore)store);
        TypeManagementPreferencesHelper.setupOrganization(versionInfo, (IPreferenceStore)store);
        TypeManagementPreferencesHelper.setupAuthor(versionInfo, (IPreferenceStore)store);
        TypeManagementPreferencesHelper.setupDate(versionInfo);
        TypeManagementPreferencesHelper.setupRemarks(versionInfo, (IPreferenceStore)store);
        type.getVersionInfo().clear();
        type.getVersionInfo().add((Object)versionInfo);
    }

    private static void setupVersion(VersionInfo versionInfo, IPreferenceStore store) {
        versionInfo.setVersion(store.getString("Version"));
    }

    private static void setupOrganization(VersionInfo versionInfo, IPreferenceStore store) {
        versionInfo.setOrganization(store.getString("Organization"));
    }

    private static void setupAuthor(VersionInfo versionInfo, IPreferenceStore store) {
        versionInfo.setAuthor(store.getString("Author"));
    }

    private static void setupDate(VersionInfo versionInfo) {
        versionInfo.setDate(new SimpleDateFormat("yyyy-MM-dd").format(new Date(System.currentTimeMillis())));
    }

    private static void setupRemarks(VersionInfo versionInfo, IPreferenceStore store) {
        versionInfo.setRemarks(store.getString("Remarks"));
    }

    public static void setupIdentification(LibraryElement type) {
        Identification identification = type.getIdentification();
        if (type.getIdentification() == null) {
            identification = LibraryElementFactory.eINSTANCE.createIdentification();
        }
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.fordiac.ide.typemanagement");
        TypeManagementPreferencesHelper.setupStandard(identification, (IPreferenceStore)store);
        TypeManagementPreferencesHelper.setupClassification(identification, (IPreferenceStore)store);
        TypeManagementPreferencesHelper.setupTypeDomain(identification, (IPreferenceStore)store);
        TypeManagementPreferencesHelper.setupFunction(identification, (IPreferenceStore)store);
        TypeManagementPreferencesHelper.setupType(identification, (IPreferenceStore)store);
        TypeManagementPreferencesHelper.setupDescription(identification, (IPreferenceStore)store);
        type.setIdentification(identification);
    }

    public static void setupStandard(Identification identification, IPreferenceStore store) {
        if (!store.getString("Standard").isEmpty()) {
            identification.setStandard(store.getString("Standard"));
        }
    }

    public static void setupClassification(Identification identification, IPreferenceStore store) {
        identification.setClassification(store.getString("Classification"));
    }

    public static void setupTypeDomain(Identification identification, IPreferenceStore store) {
        identification.setApplicationDomain(store.getString("Application Domain"));
    }

    public static void setupFunction(Identification identification, IPreferenceStore store) {
        identification.setFunction(store.getString("Function"));
    }

    public static void setupType(Identification identification, IPreferenceStore store) {
        identification.setType(store.getString("Type"));
    }

    public static void setupDescription(Identification identification, IPreferenceStore store) {
        identification.setDescription(store.getString("Description"));
    }
}

