/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.ui.widget;

import org.eclipse.fordiac.ide.ui.providers.RowHeaderDataProvider;
import org.eclipse.fordiac.ide.ui.widget.CutDataFromTableAction;
import org.eclipse.fordiac.ide.ui.widget.DefaultRegistryConfiguration;
import org.eclipse.fordiac.ide.ui.widget.FordiacCopyDataCommandHandler;
import org.eclipse.fordiac.ide.ui.widget.FordiacSelectionModel;
import org.eclipse.fordiac.ide.ui.widget.I4diacNatTableUtil;
import org.eclipse.fordiac.ide.ui.widget.PasteDataFromClipboardCommandHandler;
import org.eclipse.fordiac.ide.ui.widget.PasteFromClipboardDataCommandHandler;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.AbstractLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.AbstractUiBindingConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IEditableRule;
import org.eclipse.nebula.widgets.nattable.copy.action.CopyDataAction;
import org.eclipse.nebula.widgets.nattable.copy.action.PasteDataAction;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.edit.action.KeyEditAction;
import org.eclipse.nebula.widgets.nattable.edit.action.MouseEditAction;
import org.eclipse.nebula.widgets.nattable.edit.command.DeleteSelectionCommandHandler;
import org.eclipse.nebula.widgets.nattable.edit.config.DefaultEditConfiguration;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.config.DefaultGridLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.grid.layer.config.DefaultRowStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.layer.CompositeLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.config.DefaultColumnHeaderStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.layer.config.DefaultRowHeaderLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.layer.config.DefaultRowHeaderStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.painter.IOverlayPainter;
import org.eclipse.nebula.widgets.nattable.painter.NatTableBorderOverlayPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.BackgroundPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.CheckBoxPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.PaddingDecorator;
import org.eclipse.nebula.widgets.nattable.painter.layer.ILayerPainter;
import org.eclipse.nebula.widgets.nattable.painter.layer.NatGridLayerPainter;
import org.eclipse.nebula.widgets.nattable.selection.ISelectionModel;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.config.DefaultSelectionBindings;
import org.eclipse.nebula.widgets.nattable.selection.config.DefaultSelectionLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.selection.config.DefaultSelectionStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.style.HorizontalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.tree.ITreeData;
import org.eclipse.nebula.widgets.nattable.tree.ITreeRowModel;
import org.eclipse.nebula.widgets.nattable.tree.TreeLayer;
import org.eclipse.nebula.widgets.nattable.tree.TreeRowModel;
import org.eclipse.nebula.widgets.nattable.tree.config.TreeLayerExpandCollapseKeyBindings;
import org.eclipse.nebula.widgets.nattable.ui.action.IKeyAction;
import org.eclipse.nebula.widgets.nattable.ui.action.IMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.CellEditorMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.CellPainterMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IKeyEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.KeyEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.LetterOrDigitKeyEventMatcher;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class NatTableWidgetFactory {
    public static final String DEFAULT_CELL = "DEFAULT_CELL";
    public static final String ERROR_CELL = "ERROR_CELL";
    public static final String WARNING_CELL = "WARNING_CELL";
    public static final String DISABLED_CELL = "DISABLED_CELL";
    public static final String PROPOSAL_CELL = "PROPOSAL_CELL";
    public static final String ATTRIBUTE_PROPOSAL_CELL = "ATTRIBUTE_PROPOSAL_CELL";
    public static final String DISABLED_HEADER = "DISABLED_HEADER";
    public static final String VISIBILITY_CELL = "VISIBILITY_CELL";
    public static final String LEFT_ALIGNMENT = "LEFT_ALIGNMENT";
    public static final String CHECKBOX_CELL = "CHECKBOX_CELL";
    public static final String VAR_GONFIGURATION_CELL = "VAR_GONFIGURATION_CELL";
    public static final String RETAIN_CONFIG_CELL = "RETAIN_CONFIG_CELL";
    static final char[] ACTIVATION_CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '_', '.', '\b'};

    public static char[] getActivationChars() {
        return ACTIVATION_CHARS;
    }

    public static NatTable createNatTable(Composite parent, DataLayer dataLayer, IDataProvider headerDataProvider) {
        return NatTableWidgetFactory.createNatTable(parent, dataLayer, headerDataProvider, IEditableRule.NEVER_EDITABLE);
    }

    public static NatTable createNatTable(Composite parent, DataLayer dataLayer, IDataProvider headerDataProvider, IEditableRule editableRule) {
        return NatTableWidgetFactory.createNatTable(parent, dataLayer, headerDataProvider, editableRule, null);
    }

    public static NatTable createNatTable(Composite parent, DataLayer dataLayer, IDataProvider headerDataProvider, IEditableRule editableRule, ICellEditor proposalCellEditor) {
        NatTableWidgetFactory.setColumnWidths(dataLayer);
        SelectionLayer selectionLayer = new SelectionLayer((IUniqueIndexLayer)dataLayer);
        selectionLayer.setSelectionModel((ISelectionModel)new FordiacSelectionModel(selectionLayer));
        selectionLayer.addConfiguration((IConfiguration)new DefaultSelectionBindings(){

            public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
                uiBindingRegistry.registerKeyBinding((IKeyEventMatcher)new KeyEventMatcher(SWT.MOD1, 118), (IKeyAction)new PasteDataAction());
                uiBindingRegistry.registerKeyBinding((IKeyEventMatcher)new KeyEventMatcher(SWT.MOD1, 120), (IKeyAction)new CutDataFromTableAction());
                uiBindingRegistry.registerKeyBinding((IKeyEventMatcher)new KeyEventMatcher(SWT.MOD1, 99), (IKeyAction)new CopyDataAction());
            }
        });
        selectionLayer.registerCommandHandler((ILayerCommandHandler)new FordiacCopyDataCommandHandler(selectionLayer));
        selectionLayer.registerCommandHandler((ILayerCommandHandler)new PasteDataFromClipboardCommandHandler(selectionLayer));
        selectionLayer.registerCommandHandler((ILayerCommandHandler)new DeleteSelectionCommandHandler(selectionLayer));
        ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)selectionLayer);
        DataLayer columnHeaderDataLayer = new DataLayer(headerDataProvider);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)columnHeaderDataLayer, (ILayer)viewportLayer, selectionLayer);
        CompositeLayer compositeLayer = new CompositeLayer(1, 2);
        compositeLayer.setChildLayer("COLUMN_HEADER", (ILayer)columnHeaderLayer, 0, 0);
        compositeLayer.setChildLayer("BODY", (ILayer)viewportLayer, 0, 1);
        compositeLayer.addConfiguration((IConfiguration)new DefaultEditConfiguration());
        compositeLayer.addConfiguration((IConfiguration)new DefaultUiBindingConfiguration());
        compositeLayer.addConfiguration((IConfiguration)new DefaultRegistryConfiguration(editableRule, proposalCellEditor));
        NatTableWidgetFactory.addEditDisabledLabel(dataLayer, editableRule, false);
        NatTable table = new NatTable(parent, (ILayer)compositeLayer, false);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)table);
        NatTableWidgetFactory.setNatTableStyle(table);
        return table;
    }

    public static NatTable createRowNatTable(Composite parent, DataLayer bodyDataLayer, IDataProvider columnHeaderProvider, IEditableRule editableRule, ICellEditor proposalCellEditor, final I4diacNatTableUtil section, boolean isInput) {
        NatTableWidgetFactory.setColumnWidths(bodyDataLayer);
        SelectionLayer selectionLayer = new SelectionLayer((IUniqueIndexLayer)bodyDataLayer);
        selectionLayer.setSelectionModel((ISelectionModel)new FordiacSelectionModel(selectionLayer));
        selectionLayer.addConfiguration((IConfiguration)new DefaultSelectionBindings(){

            public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
                uiBindingRegistry.unregisterKeyBinding((IKeyEventMatcher)new KeyEventMatcher(SWT.MOD1, 99));
                uiBindingRegistry.unregisterKeyBinding((IKeyEventMatcher)new KeyEventMatcher(SWT.MOD1, 120));
                uiBindingRegistry.registerKeyBinding((IKeyEventMatcher)new KeyEventMatcher(SWT.MOD1, 99), (IKeyAction)new CopyDataAction());
                uiBindingRegistry.registerKeyBinding((IKeyEventMatcher)new KeyEventMatcher(SWT.MOD1, 118), (IKeyAction)new PasteDataAction());
                uiBindingRegistry.registerKeyBinding((IKeyEventMatcher)new KeyEventMatcher(SWT.MOD1, 120), (IKeyAction)new CutDataFromTableAction(section));
            }
        });
        selectionLayer.registerCommandHandler((ILayerCommandHandler)new FordiacCopyDataCommandHandler(selectionLayer));
        selectionLayer.registerCommandHandler((ILayerCommandHandler)new DeleteSelectionCommandHandler(selectionLayer));
        ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)selectionLayer);
        DataLayer columnHeaderDataLayer = new DataLayer(columnHeaderProvider);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)columnHeaderDataLayer, (ILayer)viewportLayer, selectionLayer);
        RowHeaderDataProvider rowHeaderProvider = new RowHeaderDataProvider(bodyDataLayer.getDataProvider(), isInput);
        selectionLayer.registerCommandHandler((ILayerCommandHandler)new PasteDataFromClipboardCommandHandler(selectionLayer, section, rowHeaderProvider));
        DataLayer rowHeaderDataLayer = new DataLayer((IDataProvider)rowHeaderProvider, 25, 20);
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)rowHeaderDataLayer, (ILayer)viewportLayer, selectionLayer, false);
        rowHeaderLayer.addConfiguration((IConfiguration)new DefaultRowHeaderLayerConfiguration(){

            protected void addRowHeaderUIBindings() {
            }
        });
        DataLayer cornerDataLayer = new DataLayer((IDataProvider)new DefaultCornerDataProvider(columnHeaderProvider, (IDataProvider)rowHeaderProvider));
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)cornerDataLayer, (ILayer)rowHeaderLayer, (ILayer)columnHeaderLayer);
        GridLayer gridLayer = new GridLayer((ILayer)viewportLayer, (ILayer)columnHeaderLayer, (ILayer)rowHeaderLayer, (ILayer)cornerLayer, false);
        gridLayer.addConfiguration((IConfiguration)new DefaultGridLayerConfiguration((CompositeLayer)gridLayer){

            protected void addEditingUIConfig() {
                this.addConfiguration((IConfiguration)new DefaultUiBindingConfiguration());
            }

            protected void addAlternateRowColoringConfig(CompositeLayer gridLayer) {
                this.addConfiguration((IConfiguration)new DefaultRowStyleConfiguration());
            }
        });
        gridLayer.addConfiguration((IConfiguration)new DefaultRegistryConfiguration(editableRule, proposalCellEditor));
        NatTableWidgetFactory.addEditDisabledLabel(bodyDataLayer, editableRule, false);
        NatTable table = new NatTable(parent, (ILayer)gridLayer, false);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)table);
        NatTableWidgetFactory.setNatTableStyle(table);
        table.setLayerPainter((ILayerPainter)new NatGridLayerPainter(table, 20){

            protected void paintBackground(ILayer natLayer, GC gc, int xOffset, int yOffset, Rectangle rectangle, IConfigRegistry configRegistry) {
                super.paintBackground(natLayer, gc, xOffset, yOffset, rectangle, configRegistry);
                gc.drawLine(0, rectangle.y, 0, rectangle.y + rectangle.height);
            }
        });
        return table;
    }

    public static <T> NatTable createTreeNatTable(Composite parent, DataLayer bodyDataLayer, ITreeData<T> treeData, IDataProvider columnHeaderDataProvider, IEditableRule editableRule) {
        NatTableWidgetFactory.setColumnWidths(bodyDataLayer);
        TreeRowModel treeRowModel = new TreeRowModel(treeData);
        TreeLayer treeLayer = new TreeLayer((IUniqueIndexLayer)bodyDataLayer, (ITreeRowModel)treeRowModel);
        SelectionLayer selectionLayer = new SelectionLayer((IUniqueIndexLayer)treeLayer, false);
        selectionLayer.addConfiguration((IConfiguration)new DefaultTreeSelectionLayerConfiguration(selectionLayer, (IUniqueIndexLayer)selectionLayer));
        ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)selectionLayer);
        DefaultColumnHeaderDataLayer columnHeaderDataLayer = new DefaultColumnHeaderDataLayer(columnHeaderDataProvider);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)columnHeaderDataLayer, (ILayer)viewportLayer, selectionLayer);
        CompositeLayer compositeLayer = new CompositeLayer(1, 2);
        compositeLayer.setChildLayer("COLUMN_HEADER", (ILayer)columnHeaderLayer, 0, 0);
        compositeLayer.setChildLayer("BODY", (ILayer)viewportLayer, 0, 1);
        compositeLayer.addConfiguration((IConfiguration)new DefaultEditConfiguration());
        compositeLayer.addConfiguration((IConfiguration)new DefaultUiBindingConfiguration());
        compositeLayer.addConfiguration((IConfiguration)new DefaultRegistryConfiguration(editableRule, null));
        NatTableWidgetFactory.addEditDisabledLabel(bodyDataLayer, editableRule, false);
        NatTable natTable = new NatTable(parent, (ILayer)compositeLayer, false);
        natTable.addConfiguration((IConfiguration)new TreeLayerExpandCollapseKeyBindings((IUniqueIndexLayer)treeLayer, selectionLayer));
        NatTableWidgetFactory.setNatTableStyle(natTable);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)natTable);
        return natTable;
    }

    public static DataLayer getDataLayer(NatTable table) {
        SelectionLayer selectionLayer = NatTableWidgetFactory.getSelectionLayer(table);
        if (selectionLayer != null) {
            return (DataLayer)selectionLayer.getUnderlyingLayerByPosition(0, 0);
        }
        return null;
    }

    public static SelectionLayer getSelectionLayer(NatTable table) {
        ILayer viewportLayer = null;
        ILayer iLayer = table.getLayer();
        if (iLayer instanceof GridLayer) {
            GridLayer gridLayer = (GridLayer)iLayer;
            viewportLayer = gridLayer.getBodyLayer();
        } else {
            CompositeLayer compLayer;
            ILayer iLayer2;
            ILayer iLayer3 = table.getLayer();
            if (iLayer3 instanceof CompositeLayer && (iLayer2 = (compLayer = (CompositeLayer)iLayer3).getChildLayerByRegionName("BODY")) instanceof ViewportLayer) {
                ViewportLayer vpl = (ViewportLayer)iLayer2;
                viewportLayer = vpl;
            }
        }
        if (viewportLayer != null) {
            return (SelectionLayer)viewportLayer.getUnderlyingLayerByPosition(0, 0);
        }
        return null;
    }

    public static Object getLastSelectedVariable(NatTable table) {
        int[] rows;
        SelectionLayer selectionLayer = NatTableWidgetFactory.getSelectionLayer(table);
        if (selectionLayer != null && (rows = selectionLayer.getFullySelectedRowPositions()).length > 0) {
            DataLayer dataLayer = (DataLayer)selectionLayer.getUnderlyingLayerByPosition(0, 0);
            return ((ListDataProvider)dataLayer.getDataProvider()).getRowObject(rows[rows.length - 1]);
        }
        return null;
    }

    private static void setColumnWidths(DataLayer dataLayer) {
        dataLayer.setColumnPercentageSizing(true);
        switch (dataLayer.getColumnCount()) {
            case 3: {
                dataLayer.setColumnWidthPercentageByPosition(0, 33);
                dataLayer.setColumnWidthPercentageByPosition(1, 34);
                dataLayer.setColumnWidthPercentageByPosition(2, 33);
                break;
            }
            case 4: {
                dataLayer.setColumnWidthPercentageByPosition(0, 20);
                dataLayer.setColumnWidthPercentageByPosition(1, 20);
                dataLayer.setColumnWidthPercentageByPosition(2, 20);
                dataLayer.setColumnWidthPercentageByPosition(3, 40);
                break;
            }
            case 5: {
                dataLayer.setColumnWidthPercentageByPosition(0, 20);
                dataLayer.setColumnWidthPercentageByPosition(1, 20);
                dataLayer.setColumnWidthPercentageByPosition(2, 15);
                dataLayer.setColumnWidthPercentageByPosition(3, 35);
                dataLayer.setColumnWidthPercentageByPosition(4, 10);
                break;
            }
            case 6: {
                dataLayer.setColumnWidthPercentageByPosition(0, 20);
                dataLayer.setColumnWidthPercentageByPosition(1, 20);
                dataLayer.setColumnWidthPercentageByPosition(2, 15);
                dataLayer.setColumnWidthPercentageByPosition(3, 15);
                dataLayer.setColumnWidthPercentageByPosition(4, 15);
                dataLayer.setColumnWidthPercentageByPosition(5, 15);
                break;
            }
            default: {
                return;
            }
        }
    }

    private static void addEditDisabledLabel(DataLayer dataLayer, IEditableRule editableRule, boolean isHeader) {
        IConfigLabelAccumulator dataLayerLabelAccumulator = dataLayer.getConfigLabelAccumulator();
        dataLayer.setConfigLabelAccumulator((configLabels, columnPosition, rowPosition) -> {
            if (dataLayerLabelAccumulator != null) {
                dataLayerLabelAccumulator.accumulateConfigLabels(configLabels, columnPosition, rowPosition);
            }
            if (!editableRule.isEditable(columnPosition, rowPosition)) {
                if (isHeader) {
                    configLabels.addLabel(DISABLED_HEADER);
                } else {
                    configLabels.addLabel(DISABLED_CELL);
                }
            }
        });
    }

    private static void setNatTableStyle(NatTable table) {
        DefaultNatTableStyleConfiguration tableStyle = new DefaultNatTableStyleConfiguration();
        DefaultSelectionStyleConfiguration selectionStyle = new DefaultSelectionStyleConfiguration();
        DefaultColumnHeaderStyleConfiguration columnHeaderStyle = new DefaultColumnHeaderStyleConfiguration();
        DefaultRowHeaderStyleConfiguration rowHeaderStyle = new DefaultRowHeaderStyleConfiguration();
        tableStyle.bgColor = GUIHelper.COLOR_WHITE;
        tableStyle.cellPainter = new TextPainter();
        selectionStyle.fullySelectedHeaderBgColor = GUIHelper.COLOR_WHITE;
        selectionStyle.selectedHeaderBgColor = GUIHelper.COLOR_WHITE;
        selectionStyle.selectedHeaderFgColor = GUIHelper.COLOR_BLACK;
        selectionStyle.selectedHeaderFont = GUIHelper.DEFAULT_FONT;
        selectionStyle.selectionFont = GUIHelper.DEFAULT_FONT;
        columnHeaderStyle.font = GUIHelper.DEFAULT_FONT;
        columnHeaderStyle.bgColor = GUIHelper.COLOR_WHITE;
        columnHeaderStyle.renderGridLines = Boolean.TRUE;
        columnHeaderStyle.cellPainter = new TextPainter();
        rowHeaderStyle.font = GUIHelper.DEFAULT_FONT;
        rowHeaderStyle.bgColor = GUIHelper.COLOR_WHITE;
        rowHeaderStyle.cellPainter = new TextPainter();
        table.setBackground(GUIHelper.COLOR_WHITE);
        table.addOverlayPainter((IOverlayPainter)new NatTableBorderOverlayPainter());
        table.addConfiguration((IConfiguration)tableStyle);
        table.addConfiguration((IConfiguration)selectionStyle);
        table.addConfiguration((IConfiguration)columnHeaderStyle);
        table.addConfiguration((IConfiguration)rowHeaderStyle);
        table.addConfiguration((IConfiguration)new AbstractRegistryConfiguration(){

            public void configureRegistry(IConfigRegistry configRegistry) {
                Style cellStyle = new Style();
                cellStyle.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, (Object)GUIHelper.COLOR_DARK_GRAY);
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.NORMAL, NatTableWidgetFactory.DEFAULT_CELL);
                cellStyle = new Style();
                cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)GUIHelper.COLOR_RED);
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.NORMAL, NatTableWidgetFactory.ERROR_CELL);
                cellStyle = new Style();
                cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)GUIHelper.getColor((int)255, (int)100, (int)100));
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.SELECT, NatTableWidgetFactory.ERROR_CELL);
                cellStyle = new Style();
                cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)GUIHelper.COLOR_YELLOW);
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.NORMAL, NatTableWidgetFactory.WARNING_CELL);
                cellStyle = new Style();
                cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)GUIHelper.getColor((int)255, (int)255, (int)100));
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.SELECT, NatTableWidgetFactory.WARNING_CELL);
                cellStyle = new Style();
                cellStyle.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, (Object)HorizontalAlignmentEnum.LEFT);
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.NORMAL, NatTableWidgetFactory.LEFT_ALIGNMENT);
                cellStyle = new Style();
                Font font = GUIHelper.getFont((FontData[])new FontData[]{new FontData(GUIHelper.DEFAULT_FONT.toString(), 10, 1)});
                cellStyle.setAttributeValue(CellStyleAttributes.FONT, (Object)font);
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.NORMAL, "COLUMN_HEADER");
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.SELECT, "COLUMN_HEADER");
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.EDIT, "COLUMN_HEADER");
                cellStyle = new Style();
                cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)GUIHelper.COLOR_WIDGET_LIGHT_SHADOW);
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.NORMAL, NatTableWidgetFactory.DISABLED_CELL);
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.NORMAL, NatTableWidgetFactory.DISABLED_HEADER);
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.SELECT, NatTableWidgetFactory.DISABLED_HEADER);
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new BackgroundPainter((ICellPainter)new PaddingDecorator((ICellPainter)new TextPainter(false, true, false, true), 2, 2, 2, 2)));
                configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.SELECT, "selectionAnchor");
            }
        });
        table.configure();
    }

    private NatTableWidgetFactory() {
        throw new UnsupportedOperationException("Helper class should not be insantiated!");
    }

    private static class DefaultTreePasteLayerConfiguration
    extends AbstractLayerConfiguration<SelectionLayer> {
        private final SelectionLayer selectionLayer;
        private final IUniqueIndexLayer pasteLayer;

        public DefaultTreePasteLayerConfiguration(SelectionLayer selectionLayer, IUniqueIndexLayer pasteLayer) {
            this.selectionLayer = selectionLayer;
            this.pasteLayer = pasteLayer;
        }

        public void configureTypedLayer(SelectionLayer layer) {
            layer.registerCommandHandler((ILayerCommandHandler)new PasteFromClipboardDataCommandHandler(this.selectionLayer, this.pasteLayer));
        }
    }

    private static class DefaultTreeSelectionBindings
    extends DefaultSelectionBindings {
        private DefaultTreeSelectionBindings() {
        }

        public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
            super.configureUiBindings(uiBindingRegistry);
            uiBindingRegistry.registerKeyBinding((IKeyEventMatcher)new KeyEventMatcher(SWT.MOD1, 118), (IKeyAction)new PasteDataAction());
        }
    }

    private static class DefaultTreeSelectionLayerConfiguration
    extends DefaultSelectionLayerConfiguration {
        private final SelectionLayer selectionLayer;
        private final IUniqueIndexLayer pasteLayer;

        public DefaultTreeSelectionLayerConfiguration(SelectionLayer selectionLayer, IUniqueIndexLayer pasteLayer) {
            this.selectionLayer = selectionLayer;
            this.pasteLayer = pasteLayer;
            this.addPasteLayerConfiguration();
        }

        protected void addSelectionUIBindings() {
            this.addConfiguration((IConfiguration)new DefaultTreeSelectionBindings());
        }

        protected void addPasteLayerConfiguration() {
            this.addConfiguration((IConfiguration)new DefaultTreePasteLayerConfiguration(this.selectionLayer, this.pasteLayer));
        }
    }

    private static class DefaultUiBindingConfiguration
    extends AbstractUiBindingConfiguration {
        private DefaultUiBindingConfiguration() {
        }

        public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
            uiBindingRegistry.registerKeyBinding((IKeyEventMatcher)new KeyEventMatcher(0, 32), (IKeyAction)new KeyEditAction());
            uiBindingRegistry.registerKeyBinding((IKeyEventMatcher)new KeyEventMatcher(0, 0x100000B), (IKeyAction)new KeyEditAction());
            uiBindingRegistry.registerKeyBinding((IKeyEventMatcher)new LetterOrDigitKeyEventMatcher(), (IKeyAction)new KeyEditAction());
            uiBindingRegistry.registerKeyBinding((IKeyEventMatcher)new LetterOrDigitKeyEventMatcher(SWT.MOD2), (IKeyAction)new KeyEditAction());
            uiBindingRegistry.registerFirstSingleClickBinding((IMouseEventMatcher)new CellPainterMouseEventMatcher("BODY", 1, CheckBoxPainter.class), (IMouseAction)new MouseEditAction());
            uiBindingRegistry.registerDoubleClickBinding((IMouseEventMatcher)new CellEditorMouseEventMatcher("BODY"), (IMouseAction)new MouseEditAction());
        }
    }
}

