/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.filterrow.combobox;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.nebula.widgets.nattable.data.convert.ConversionFailedException;
import org.eclipse.nebula.widgets.nattable.edit.EditController;
import org.eclipse.nebula.widgets.nattable.edit.editor.ComboBoxCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.IComboBoxDataProvider;
import org.eclipse.nebula.widgets.nattable.filterrow.combobox.FilterNatCombo;
import org.eclipse.nebula.widgets.nattable.filterrow.combobox.FilterRowComboBoxDataProvider;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;
import org.eclipse.nebula.widgets.nattable.widget.EditModeEnum;
import org.eclipse.nebula.widgets.nattable.widget.NatCombo;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterRowComboBoxCellEditor
extends ComboBoxCellEditor {
    private static final Logger LOG = LoggerFactory.getLogger(FilterRowComboBoxCellEditor.class);
    private Object currentCanonicalValue = null;
    private boolean applyFilterOnDropdownFilter = false;
    private boolean closeOnEnterInDropdownFilter = false;
    private List<?> notVisibleSelected;
    private Listener resizeListener = new Listener(){

        public void handleEvent(Event event) {
            ILayer layer = FilterRowComboBoxCellEditor.this.layerCell.getLayer();
            Rectangle bounds = FilterRowComboBoxCellEditor.this.layerCell.getBounds();
            int colEnd = bounds.x + bounds.width - 1;
            int colPos = layer.getColumnPositionByX(colEnd);
            ILayerCell cell = layer.getCellByPosition(colPos, FilterRowComboBoxCellEditor.this.getRowPosition());
            if (FilterRowComboBoxCellEditor.this.getColumnPosition() < colPos || cell != null && !cell.getBounds().equals((Object)bounds)) {
                FilterRowComboBoxCellEditor.this.close();
                EditController.editCell(cell, FilterRowComboBoxCellEditor.this.parent, FilterRowComboBoxCellEditor.this.currentCanonicalValue, FilterRowComboBoxCellEditor.this.configRegistry);
            }
        }
    };

    public FilterRowComboBoxCellEditor(IComboBoxDataProvider dataProvider) {
        this(dataProvider, 5);
    }

    public FilterRowComboBoxCellEditor(IComboBoxDataProvider dataProvider, int maxVisibleItems) {
        super(dataProvider, maxVisibleItems);
        this.multiselect = true;
        this.useCheckbox = true;
    }

    @Override
    public NatCombo createEditorControl(Composite parent) {
        int style = 42;
        FilterNatCombo combo = this.iconImage == null ? new FilterNatCombo(parent, this.cellStyle, this.maxVisibleItems, style, this.showDropdownFilter, this.isLinkItemAndCheckbox()) : new FilterNatCombo(parent, this.cellStyle, this.maxVisibleItems, style, this.iconImage, this.showDropdownFilter, this.isLinkItemAndCheckbox());
        combo.setMultiselectValueSeparator(this.multiselectValueSeparator);
        combo.setMultiselectTextBracket(this.multiselectTextPrefix, this.multiselectTextSuffix);
        this.addNatComboListener(combo);
        parent.addListener(11, this.resizeListener);
        return combo;
    }

    protected void addNatComboListener(FilterNatCombo combo) {
        super.addNatComboListener(combo);
        combo.addCheckStateListener(event -> {
            if (event.getChecked()) {
                this.setEditorValue(new String[]{"SELECT_ALL"});
            }
            this.commit(SelectionLayer.MoveDirectionEnum.NONE, !this.multiselect && this.editMode == EditModeEnum.INLINE);
        });
        if (this.applyFilterOnDropdownFilter) {
            combo.setFilterModifyAction(() -> this.commit(SelectionLayer.MoveDirectionEnum.NONE, !this.multiselect && this.editMode == EditModeEnum.INLINE));
        }
        if (this.closeOnEnterInDropdownFilter) {
            combo.setDropdownFilterKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent event) {
                    if (event.keyCode == 13 || event.keyCode == 0x1000050 || event.keyCode == 27) {
                        FilterRowComboBoxCellEditor.this.close();
                    }
                }
            });
        }
        combo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 32) {
                    FilterRowComboBoxCellEditor.this.commit(SelectionLayer.MoveDirectionEnum.NONE, !FilterRowComboBoxCellEditor.this.multiselect && FilterRowComboBoxCellEditor.this.editMode == EditModeEnum.INLINE);
                }
            }
        });
    }

    @Override
    public void close() {
        super.close();
        if (!this.parent.isDisposed()) {
            this.parent.removeListener(11, this.resizeListener);
        }
    }

    @Override
    public void setCanonicalValue(Object canonicalValue) {
        this.currentCanonicalValue = canonicalValue;
        if (this.getComboBoxDataProvider() != null && this.getComboBoxDataProvider() instanceof FilterRowComboBoxDataProvider && ((FilterRowComboBoxDataProvider)this.getComboBoxDataProvider()).getFilterCollection() != null) {
            List<?> allValues = ((FilterRowComboBoxDataProvider)this.getComboBoxDataProvider()).getAllValues(this.getColumnIndex());
            List<?> visibleValues = this.getComboBoxDataProvider().getValues(this.getColumnIndex(), this.getRowIndex());
            ArrayList diffValues = new ArrayList(allValues);
            diffValues.removeAll(visibleValues);
            if (canonicalValue instanceof Collection) {
                Collection cValues = (Collection)canonicalValue;
                Iterator it = diffValues.iterator();
                while (it.hasNext()) {
                    Object object = it.next();
                    if (cValues.contains(object)) continue;
                    it.remove();
                }
            }
            if ("SELECT_ALL".equals(canonicalValue)) {
                this.currentCanonicalValue = allValues;
            }
            this.notVisibleSelected = diffValues.stream().map(v -> this.handleConversion(v, this.conversionEditErrorHandler)).collect(Collectors.toList());
        }
        super.setCanonicalValue(canonicalValue);
    }

    @Override
    public Object getCanonicalValue() {
        Object canonicalValue = super.getCanonicalValue();
        if (canonicalValue instanceof Collection && this.notVisibleSelected != null) {
            ((Collection)canonicalValue).addAll(this.notVisibleSelected);
        }
        return canonicalValue;
    }

    @Override
    public boolean commit(SelectionLayer.MoveDirectionEnum direction, boolean closeAfterCommit) {
        boolean dropdownFilterActive = false;
        NatCombo editorControl = this.getEditorControl();
        if (editorControl != null && editorControl instanceof FilterNatCombo && ((FilterNatCombo)editorControl).isFilterActive()) {
            dropdownFilterActive = true;
        }
        if (dropdownFilterActive) {
            if (closeAfterCommit) {
                this.close();
            }
            return true;
        }
        if (!this.isClosed()) {
            block11: {
                Object canonicalValue = this.getCanonicalValue();
                if (this.canonicalValuesEquals(canonicalValue)) break block11;
                if (super.commit(direction, closeAfterCommit)) {
                    this.currentCanonicalValue = canonicalValue;
                    if (!dropdownFilterActive && ((FilterNatCombo)editorControl).initialSelection != null) {
                        ((FilterNatCombo)editorControl).initialSelection = editorControl.getSelection();
                    }
                    return true;
                }
            }
            try {
                if (closeAfterCommit) {
                    this.close();
                }
                return true;
            }
            catch (ConversionFailedException canonicalValue) {
            }
            catch (Exception e) {
                LOG.error("Error on updating cell value: {}", (Object)e.getLocalizedMessage(), (Object)e);
            }
        }
        return false;
    }

    private boolean canonicalValuesEquals(Object canonicalValue) {
        if (canonicalValue != null && this.currentCanonicalValue == null) {
            return false;
        }
        if (canonicalValue == null && this.currentCanonicalValue != null) {
            return false;
        }
        if (canonicalValue != null && this.currentCanonicalValue != null) {
            if (canonicalValue instanceof Collection && !(this.currentCanonicalValue instanceof Collection)) {
                return false;
            }
            if (!(canonicalValue instanceof Collection) && this.currentCanonicalValue instanceof Collection) {
                return false;
            }
            if (canonicalValue instanceof Collection && this.currentCanonicalValue instanceof Collection) {
                return ObjectUtils.collectionsEqual((Collection)canonicalValue, (Collection)this.currentCanonicalValue);
            }
            return canonicalValue.equals(this.currentCanonicalValue);
        }
        return true;
    }

    public void configureDropdownFilter(boolean applyFilter, boolean closeOnEnter) {
        this.configureDropdownFilter(applyFilter, closeOnEnter, false);
    }

    public void configureDropdownFilter(boolean applyFilter, boolean closeOnEnter, boolean focusOnDropDownFilter) {
        this.setShowDropdownFilter(true);
        this.setFocusOnDropdownFilter(focusOnDropDownFilter);
        this.applyFilterOnDropdownFilter = applyFilter;
        this.closeOnEnterInDropdownFilter = closeOnEnter;
    }

    protected boolean isApplyFilterOnDropdownFilter() {
        return this.applyFilterOnDropdownFilter;
    }

    protected boolean isCloseOnEnterInDropdownFilter() {
        return this.closeOnEnterInDropdownFilter;
    }
}

