/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataexport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.datatype.helper.InternalAttributeDeclarations;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.AttributeDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.ColorizableElement;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerInterface;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.Identification;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.PositionableElement;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.VersionInfo;
import org.eclipse.fordiac.ide.model.typelibrary.ErrorTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;

public class CommonElementExporter {
    public static final String LINE_END = "\n";
    public static final String TAB = "\t";
    private static final Pattern CDATA_END_PATTERN = Pattern.compile("\\]\\]>");
    protected static final DecimalFormat positionFormater = new DecimalFormat("#.##");
    private final XMLStreamWriter writer;
    private final ByteBufferOutputStream outputStream;
    private final Set<TypeEntry> dependencies;
    private int tabCount = 0;

    protected CommonElementExporter() {
        this.outputStream = new ByteBufferOutputStream();
        this.writer = this.createEventWriter();
        this.dependencies = new HashSet<TypeEntry>();
    }

    protected CommonElementExporter(CommonElementExporter parent) {
        this.writer = parent.writer;
        this.outputStream = parent.outputStream;
        this.dependencies = parent.dependencies;
        this.tabCount = parent.tabCount;
    }

    protected XMLStreamWriter getWriter() {
        return this.writer;
    }

    protected ByteBufferOutputStream getOutputStream() {
        return this.outputStream;
    }

    public Set<TypeEntry> getDependencies() {
        return this.dependencies;
    }

    protected void addStartElement(String name) throws XMLStreamException {
        this.addTabs();
        this.writer.writeStartElement(name);
        ++this.tabCount;
    }

    protected void addEmptyStartElement(String name) throws XMLStreamException {
        this.addTabs();
        this.writer.writeEmptyElement(name);
    }

    private void addTabs() throws XMLStreamException {
        this.writer.writeCharacters(LINE_END);
        int i = 0;
        while (i < this.tabCount) {
            this.writer.writeCharacters(TAB);
            ++i;
        }
    }

    protected void addEndElement() throws XMLStreamException {
        --this.tabCount;
        this.addTabs();
        this.writer.writeEndElement();
    }

    protected void addInlineEndElement() throws XMLStreamException {
        --this.tabCount;
        this.writer.writeEndElement();
    }

    private XMLStreamWriter createEventWriter() {
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        try {
            XMLStreamWriter newWriter = outputFactory.createXMLStreamWriter(this.outputStream, StandardCharsets.UTF_8.name());
            newWriter.writeStartDocument(StandardCharsets.UTF_8.name(), "1.0");
            return newWriter;
        }
        catch (XMLStreamException e) {
            FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    protected void addColorAttributeElement(ColorizableElement colElement) throws XMLStreamException {
        if (colElement.getColor() != null) {
            String colorValue = colElement.getColor().getRed() + "," + colElement.getColor().getGreen() + "," + colElement.getColor().getBlue();
            this.addAttributeElement("Color", IecTypes.ElementaryTypes.STRING, colorValue, null);
        }
    }

    protected void addAttributeElement(String name, DataType type, String value, String comment) throws XMLStreamException {
        if (IecTypes.HelperTypes.CDATA == type) {
            this.addStartElement("Attribute");
        } else {
            this.addEmptyStartElement("Attribute");
        }
        this.addNameAttribute(name);
        if (type != null && !(type.eContainer() instanceof AttributeDeclaration)) {
            this.addTypeAttribute(type);
        }
        if (IecTypes.HelperTypes.CDATA != type) {
            this.getWriter().writeAttribute("Value", value);
        }
        if (comment != null && !comment.isBlank()) {
            this.getWriter().writeAttribute("Comment", comment);
        }
        if (IecTypes.HelperTypes.CDATA == type) {
            this.writeCDataSection(value);
            this.addInlineEndElement();
        }
    }

    protected void createNamedElementEntry(INamedElement namedElement, String elemName) throws XMLStreamException {
        this.addStartElement(elemName);
        this.addNameAndCommentAttribute(namedElement);
    }

    protected void addIdentification(LibraryElement libraryelement) throws XMLStreamException {
        if (libraryelement.getIdentification() != null) {
            this.addStartElement("Identification");
            Identification ident = libraryelement.getIdentification();
            if (ident.getStandard() != null && !ident.getStandard().equals("")) {
                this.writer.writeAttribute("Standard", ident.getStandard());
            }
            if (ident.getClassification() != null && !ident.getClassification().equals("")) {
                this.writer.writeAttribute("Classification", ident.getClassification());
            }
            if (ident.getApplicationDomain() != null && !ident.getApplicationDomain().equals("")) {
                this.writer.writeAttribute("ApplicationDomain", ident.getApplicationDomain());
            }
            if (ident.getFunction() != null && !ident.getFunction().equals("")) {
                this.writer.writeAttribute("Function", ident.getFunction());
            }
            if (ident.getType() != null && !ident.getType().equals("")) {
                this.writer.writeAttribute("Type", ident.getType());
            }
            if (ident.getDescription() != null && !ident.getDescription().equals("")) {
                this.writeAttributeRaw("Description", ident.getDescription());
            }
            this.addEndElement();
        }
    }

    protected void addVersionInfo(LibraryElement libraryelement) throws XMLStreamException {
        if (!libraryelement.getVersionInfo().isEmpty()) {
            for (VersionInfo info : libraryelement.getVersionInfo()) {
                this.addStartElement("VersionInfo");
                if (info.getOrganization() != null && !info.getOrganization().equals("")) {
                    this.writer.writeAttribute("Organization", info.getOrganization());
                }
                if (info.getVersion() != null && !info.getVersion().equals("")) {
                    this.writer.writeAttribute("Version", info.getVersion());
                }
                if (info.getAuthor() != null && !info.getAuthor().equals("")) {
                    this.writer.writeAttribute("Author", info.getAuthor());
                }
                if (info.getDate() != null && !info.getDate().equals("")) {
                    this.writer.writeAttribute("Date", info.getDate());
                }
                if (info.getRemarks() != null && !info.getRemarks().equals("")) {
                    this.writer.writeAttribute("Remarks", info.getRemarks());
                }
                this.addEndElement();
            }
        }
    }

    protected void addCommentAttribute(String comment) throws XMLStreamException {
        if (comment != null && !comment.isBlank()) {
            this.writeAttributeRaw("Comment", comment);
        }
    }

    protected void addNameAndCommentAttribute(INamedElement namedElement) throws XMLStreamException {
        this.addNameAttribute(namedElement.getName());
        this.addCommentAttribute(namedElement.getComment());
    }

    protected void addNameTypeCommentAttribute(INamedElement namedElement, LibraryElement type) throws XMLStreamException {
        this.addNameAttribute(namedElement.getName());
        this.addTypeAttribute(type);
        this.addCommentAttribute(namedElement.getComment());
    }

    protected void addAttributes(EList<Attribute> attributes) throws XMLStreamException {
        for (Attribute attribute : attributes) {
            String name = attribute.getAttributeDeclaration() != null ? PackageNameHelper.getFullTypeName(this.addDependency(attribute.getAttributeDeclaration())) : attribute.getName();
            this.addAttributeElement(name, attribute.getType(), attribute.getValue(), attribute.getComment());
        }
    }

    protected void writeAttributeRaw(String attributeName, String attributeValue) throws XMLStreamException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (OutputStreamWriter osWriter = new OutputStreamWriter((OutputStream)this.outputStream, StandardCharsets.UTF_8);){
                osWriter.write(" ");
                osWriter.write(attributeName);
                osWriter.write("=\"");
                osWriter.write(CommonElementExporter.fullyEscapeValue(attributeValue));
                osWriter.write("\" ");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new XMLStreamException("Could not write raw attribute", e);
        }
    }

    protected static String fullyEscapeValue(String value) {
        String escapedValue = value.replace("\r\n", LINE_END);
        escapedValue = escapedValue.replace("&", "&amp;");
        escapedValue = escapedValue.replace("<", "&lt;");
        escapedValue = escapedValue.replace(">", "&gt;");
        escapedValue = escapedValue.replace("\"", "&quot;");
        escapedValue = escapedValue.replace("'", "&apos;");
        escapedValue = escapedValue.replace(LINE_END, "&#10;");
        escapedValue = escapedValue.replace(TAB, "&#9;");
        return escapedValue;
    }

    protected void addTypeAttribute(LibraryElement type) throws XMLStreamException {
        this.addTypeAttribute(PackageNameHelper.getFullTypeName(this.addDependency(type)));
    }

    protected void addTypeAttribute(String type) throws XMLStreamException {
        this.writer.writeAttribute("Type", type != null ? type : "");
    }

    protected void addNameAttribute(String name) throws XMLStreamException {
        this.writer.writeAttribute("Name", name != null ? name : "");
    }

    protected void addParamsConfig(InterfaceList interfaces) throws XMLStreamException {
        for (IInterfaceElement ie : interfaces.getAllInterfaceElements()) {
            this.addParam(ie);
        }
    }

    protected void addParamsConfig(EList<VarDeclaration> inputVars) throws XMLStreamException {
        for (VarDeclaration inVar : inputVars) {
            this.addParam(inVar);
        }
    }

    protected void addErrorMarkerParamsConfig(EList<ErrorMarkerInterface> errorPins) throws XMLStreamException {
        for (ErrorMarkerInterface ep : errorPins) {
            this.addParam(ep.getName(), ep.getValue());
        }
    }

    private void addParam(IInterfaceElement ie) throws XMLStreamException {
        boolean hasComment;
        VarDeclaration varDecl;
        boolean hasAttributes = CommonElementExporter.hasNonTrivialAttributes(ie);
        boolean hasInitalValue = ie instanceof VarDeclaration && (varDecl = (VarDeclaration)ie).getValue() != null && varDecl.getValue().getValue() != null && !varDecl.getValue().getValue().isBlank();
        boolean bl = hasComment = ie.getComment() != null && !ie.getComment().isBlank();
        if (hasAttributes) {
            this.addStartElement("Parameter");
        } else if (hasInitalValue || hasComment) {
            this.addEmptyStartElement("Parameter");
        } else {
            return;
        }
        this.addNameAttribute(ie.getName());
        String value = "";
        if (hasInitalValue) {
            value = ((VarDeclaration)ie).getValue().getValue();
        }
        this.writer.writeAttribute("Value", value);
        this.addCommentAttribute(ie.getComment());
        if (hasAttributes) {
            for (Attribute attribute : ie.getAttributes()) {
                VarDeclaration varDecl2;
                if (attribute.getAttributeDeclaration() == InternalAttributeDeclarations.VAR_CONFIG && ie instanceof VarDeclaration && !(varDecl2 = (VarDeclaration)ie).isVarConfig()) continue;
                this.addAttributeElement(attribute.getName(), attribute.getType(), attribute.getValue(), attribute.getComment());
            }
            this.addEndElement();
        }
    }

    private static boolean hasNonTrivialAttributes(IInterfaceElement ie) {
        if (ie.getAttributes().isEmpty()) {
            return false;
        }
        return ie.getAttributes().stream().anyMatch(att -> {
            VarDeclaration varDecl;
            return att.getAttributeDeclaration() != InternalAttributeDeclarations.VAR_CONFIG || ie instanceof VarDeclaration && (varDecl = (VarDeclaration)ie).isVarConfig();
        });
    }

    private void addParam(String pinName, Value value) throws XMLStreamException {
        if (value != null && value.getValue() != null && !value.getValue().isBlank()) {
            this.addEmptyStartElement("Parameter");
            this.addNameAttribute(pinName);
            this.writer.writeAttribute("Value", value.getValue());
        }
    }

    protected void addXYAttributes(PositionableElement fb) throws XMLStreamException {
        this.addXYAttributes(fb.getPosition().getX(), fb.getPosition().getY());
    }

    protected void addXYAttributes(double x, double y) throws XMLStreamException {
        this.writer.writeAttribute("x", positionFormater.format(x));
        this.writer.writeAttribute("y", positionFormater.format(y));
    }

    protected void writeCDataSection(String cdataText) throws XMLStreamException {
        Matcher endPatternMatcher = CDATA_END_PATTERN.matcher(cdataText);
        int currentPosition = 0;
        if (endPatternMatcher.find()) {
            do {
                this.getWriter().writeCData(cdataText.substring(currentPosition, endPatternMatcher.start()));
                this.getWriter().writeCharacters("]]>");
                currentPosition = endPatternMatcher.end();
            } while (endPatternMatcher.find());
            if (currentPosition < cdataText.length()) {
                this.getWriter().writeCData(cdataText.substring(currentPosition));
            }
        } else {
            this.getWriter().writeCData(cdataText);
        }
    }

    protected <T extends TypeEntry> T addDependency(T entry) {
        if (entry != null && !(entry instanceof ErrorTypeEntry)) {
            this.dependencies.add(entry);
        }
        return entry;
    }

    protected <T extends LibraryElement> T addDependency(T libraryElement) {
        if (libraryElement != null) {
            this.addDependency(libraryElement.getTypeEntry());
        }
        return libraryElement;
    }

    protected static class ByteBufferInputStream
    extends InputStream {
        private final Iterator<ByteBuffer> bufferIterator;
        private ByteBuffer currentDataBuffer;
        private final List<ByteBuffer> dataBuffers;

        public ByteBufferInputStream(List<ByteBuffer> dataBuffers) {
            this.dataBuffers = dataBuffers;
            dataBuffers.forEach(ByteBuffer::flip);
            this.bufferIterator = dataBuffers.iterator();
            this.currentDataBuffer = this.bufferIterator.next();
        }

        @Override
        public int read() throws IOException {
            if (this.currentDataBuffer.hasRemaining()) {
                return this.currentDataBuffer.get() & 0xFF;
            }
            if (this.bufferIterator.hasNext()) {
                this.currentDataBuffer = this.bufferIterator.next();
                return this.currentDataBuffer.get() & 0xFF;
            }
            return -1;
        }

        @Override
        public int read(byte[] b) throws IOException {
            if (this.currentDataBuffer.hasRemaining()) {
                return super.read(b);
            }
            if (this.bufferIterator.hasNext()) {
                this.currentDataBuffer = this.bufferIterator.next();
                return super.read(b);
            }
            return -1;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (len == 0) {
                return 0;
            }
            if (this.available() == 0) {
                return -1;
            }
            int readLen = Math.min(this.available(), len);
            this.currentDataBuffer.get(b, off, readLen);
            return readLen;
        }

        @Override
        public int available() throws IOException {
            return this.currentDataBuffer.remaining();
        }

        @Override
        public void close() throws IOException {
            this.dataBuffers.clear();
            super.close();
        }
    }

    protected static class ByteBufferOutputStream
    extends OutputStream {
        private static final int SI_PREFIX_KI = 1024;
        private static final int SI_PREFIX_MI = 0x100000;
        private static final int SINGLE_DATA_BUFFER_CAPACITY = ByteBufferOutputStream.getSingleDataBufCap();
        private static final String PLUGIN_ID = "org.eclipse.fordiac.ide.model";
        private List<ByteBuffer> dataBuffers = new ArrayList<ByteBuffer>(5);
        private ByteBuffer currentDataBuffer;

        private static int getSingleDataBufCap() {
            IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
            return preferences.getInt("allocationSize", 100) * 0x100000;
        }

        public ByteBufferOutputStream() {
            this.addNewDataBuffer();
        }

        public List<ByteBuffer> transferDataBuffers() {
            List<ByteBuffer> tmp = this.dataBuffers;
            this.dataBuffers = null;
            return tmp;
        }

        private void addNewDataBuffer() {
            this.currentDataBuffer = ByteBuffer.allocateDirect(SINGLE_DATA_BUFFER_CAPACITY);
            this.dataBuffers.add(this.currentDataBuffer);
        }

        @Override
        public void write(int arg0) throws IOException {
            if (!this.currentDataBuffer.hasRemaining()) {
                this.addNewDataBuffer();
            }
            this.currentDataBuffer.put((byte)arg0);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.currentDataBuffer.remaining() < len) {
                this.addNewDataBuffer();
            }
            this.currentDataBuffer.put(b, off, len);
        }
    }
}

