/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.data.DataFactory;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.datatype.helper.InternalAttributeDeclarations;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterConnection;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.AttributeDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableObject;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.DataConnection;
import org.eclipse.fordiac.ide.model.libraryElement.Demultiplexer;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.EventConnection;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Mapping;
import org.eclipse.fordiac.ide.model.libraryElement.MemberVarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.Multiplexer;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.Segment;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.SystemConfiguration;
import org.eclipse.fordiac.ide.model.libraryElement.TypedConfigureableObject;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.impl.VarDeclarationImpl;
import org.eclipse.fordiac.ide.model.typelibrary.AdapterTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;

public final class Annotations {
    public static AutomationSystem getAutomationSystem(Application a) {
        return (AutomationSystem)a.eContainer();
    }

    public static Algorithm getAlgorithmNamed(BaseFBType baseFBType, String name) {
        return baseFBType.getAlgorithm().stream().filter(alg -> alg.getName().equals(name)).findFirst().orElse(null);
    }

    public static FBNetworkElement getSourceElement(Connection c) {
        return c.getSource() != null ? c.getSource().getFBNetworkElement() : null;
    }

    public static FBNetworkElement getDestinationElement(Connection c) {
        return c.getDestination() != null ? c.getDestination().getFBNetworkElement() : null;
    }

    public static boolean isResourceConnection(Connection c) {
        return c.getSourceElement() != null && c.getSourceElement().getFbNetwork() != null && c.getSourceElement().getFbNetwork().eContainer() instanceof Resource;
    }

    public static boolean isInterfaceConnection(Connection c) {
        return Annotations.isInterfaceConnection(c, null);
    }

    public static boolean isInterfaceConnection(Connection c, FBNetworkElement path) {
        EList<Connection> connections;
        boolean destinationIsInterface;
        if (c == null) {
            return false;
        }
        if (c instanceof EventConnection || c instanceof AdapterConnection) {
            return false;
        }
        FBNetworkElement s = c.getSourceElement();
        FBNetworkElement d = c.getDestinationElement();
        EObject container = c.eContainer().eContainer();
        boolean sourceIsInterface = s == container;
        boolean bl = destinationIsInterface = d == container;
        if (sourceIsInterface || destinationIsInterface) {
            return true;
        }
        if (s == path) {
            sourceIsInterface = false;
        } else if (s instanceof Demultiplexer) {
            connections = ((VarDeclaration)s.getInterface().getInputVars().get(0)).getInputConnections();
            sourceIsInterface = !connections.isEmpty() && Annotations.isInterfaceConnection((Connection)connections.get(0), s);
        } else if (s instanceof Multiplexer) {
            boolean bl2 = sourceIsInterface = s.getInterface().getInputVars().stream().anyMatch(v -> !v.getInputConnections().isEmpty()) && s.getInterface().getInputVars().stream().allMatch(v -> v.getInputConnections().stream().allMatch(co -> Annotations.isInterfaceConnection(co, s)));
        }
        if (d == path) {
            destinationIsInterface = false;
        } else if (d instanceof Demultiplexer) {
            destinationIsInterface = d.getInterface().getOutputVars().stream().anyMatch(v -> !v.getOutputConnections().isEmpty()) && d.getInterface().getOutputVars().stream().allMatch(v -> v.getOutputConnections().stream().allMatch(co -> Annotations.isInterfaceConnection(co, d)));
        } else if (d instanceof Multiplexer) {
            connections = ((VarDeclaration)d.getInterface().getOutputVars().get(0)).getOutputConnections();
            boolean bl3 = destinationIsInterface = !connections.isEmpty() && Annotations.isInterfaceConnection((Connection)connections.get(0), d);
        }
        return sourceIsInterface || destinationIsInterface;
    }

    public static void checkifConnectionBroken(Connection c) {
        if (!c.isResourceConnection()) {
            Resource sourceRes = c.getSourceElement() != null ? c.getSourceElement().getResource() : null;
            Resource destinationRes = c.getDestinationElement() != null ? c.getDestinationElement().getResource() : null;
            c.setBrokenConnection(sourceRes != null && !sourceRes.equals(destinationRes) || destinationRes != null && !destinationRes.equals(sourceRes));
        }
    }

    public static AutomationSystem getAutomationSystem(Device d) {
        return d.getSystemConfiguration().getAutomationSystem();
    }

    public static SystemConfiguration getSystemConfiguration(Device d) {
        return (SystemConfiguration)d.eContainer();
    }

    public static Resource getResourceNamed(Device device, String name) {
        return device.getResource().stream().filter(resource -> resource.getName().equals(name)).findFirst().orElse(null);
    }

    public static boolean isStartState(ECState ecs) {
        return ecs.getECC() != null && ecs.equals(ecs.getECC().getStart());
    }

    public static String getConditionText(ECTransition ect) {
        String expression;
        Object retVal = "";
        Event event = ect.getConditionEvent();
        if (event != null) {
            retVal = Annotations.getTransitionEventName(event);
        }
        if ((expression = ect.getConditionExpression()) != null) {
            if ("1".equals(expression)) {
                retVal = expression;
            } else if (!expression.isBlank()) {
                retVal = (String)retVal + "[" + expression + "]";
            }
        }
        return retVal;
    }

    public static String getTransitionEventName(Event event) {
        if (event.getFBNetworkElement() instanceof AdapterFB) {
            return event.getFBNetworkElement().getName() + "." + event.getName();
        }
        return event.getName();
    }

    public static AutomationSystem getAutomationSystem(Mapping m) {
        return m.eContainer() != null ? (AutomationSystem)m.eContainer() : null;
    }

    public static AutomationSystem getAutomationSystem(Resource r) {
        AutomationSystem system = null;
        if (r.getDevice() != null) {
            system = r.getDevice().getAutomationSystem();
        }
        return system;
    }

    public static void addConnection(FBNetwork fbn, Connection connection) {
        Annotations.addConnectionWithIndex(fbn, connection, -1);
    }

    public static void addConnectionWithIndex(FBNetwork fbn, Connection connection, int index) {
        if (connection instanceof EventConnection) {
            EventConnection evCon = (EventConnection)connection;
            if (index != -1) {
                fbn.getEventConnections().add(index, (Object)evCon);
            } else {
                fbn.getEventConnections().add((Object)evCon);
            }
        }
        if (connection instanceof DataConnection) {
            DataConnection dataCon = (DataConnection)connection;
            if (index != -1) {
                fbn.getDataConnections().add(index, (Object)dataCon);
            } else {
                fbn.getDataConnections().add((Object)dataCon);
            }
        }
        if (connection instanceof AdapterConnection) {
            AdapterConnection adpCon = (AdapterConnection)connection;
            if (index != -1) {
                fbn.getAdapterConnections().add(index, (Object)adpCon);
            } else {
                fbn.getAdapterConnections().add((Object)adpCon);
            }
        }
    }

    public static void removeConnection(FBNetwork fbn, Connection connection) {
        if (connection instanceof EventConnection) {
            fbn.getEventConnections().remove((Object)connection);
        }
        if (connection instanceof DataConnection) {
            fbn.getDataConnections().remove((Object)connection);
        }
        if (connection instanceof AdapterConnection) {
            fbn.getAdapterConnections().remove((Object)connection);
        }
    }

    public static int getConnectionIndex(FBNetwork fbn, Connection connection) {
        if (connection instanceof EventConnection) {
            return fbn.getEventConnections().indexOf((Object)connection);
        }
        if (connection instanceof DataConnection) {
            return fbn.getDataConnections().indexOf((Object)connection);
        }
        if (connection instanceof AdapterConnection) {
            return fbn.getAdapterConnections().indexOf((Object)connection);
        }
        return -1;
    }

    public static boolean isApplicationNetwork(FBNetwork fbn) {
        return fbn.eContainer() instanceof Application;
    }

    public static boolean isSubApplicationNetwork(FBNetwork fbn) {
        return fbn.eContainer() instanceof SubApp;
    }

    public static boolean isResourceNetwork(FBNetwork fbn) {
        return fbn.eContainer() instanceof Resource;
    }

    public static boolean isCFBTypeNetwork(FBNetwork fbn) {
        return fbn.eContainer() instanceof CompositeFBType;
    }

    public static AutomationSystem getAutomationSystem(FBNetwork fbn) {
        AutomationSystem system;
        EObject root = EcoreUtil.getRootContainer((EObject)fbn);
        return root instanceof AutomationSystem ? (system = (AutomationSystem)root) : null;
    }

    public static Application getApplication(FBNetwork fbn) {
        if (fbn.isApplicationNetwork()) {
            return (Application)fbn.eContainer();
        }
        if (fbn.isSubApplicationNetwork() && ((SubApp)fbn.eContainer()).getFbNetwork() != null) {
            return ((SubApp)fbn.eContainer()).getFbNetwork().getApplication();
        }
        return null;
    }

    public static FB getFBNamed(FBNetwork fbn, String name) {
        return fbn.getNetworkElements().stream().filter(FB.class::isInstance).map(FB.class::cast).filter(element -> element.getName().equals(name)).findFirst().orElse(null);
    }

    public static SubApp getSubAppNamed(FBNetwork fbn, String name) {
        return fbn.getNetworkElements().stream().filter(SubApp.class::isInstance).map(SubApp.class::cast).filter(element -> element.getName().equals(name)).findFirst().orElse(null);
    }

    public static FBNetworkElement getElementNamed(FBNetwork fbn, String name) {
        return fbn.getNetworkElements().stream().filter(element -> element.getName().equals(name)).findFirst().orElse(null);
    }

    public static Device getDeviceNamed(AutomationSystem as, String name) {
        return as.getSystemConfiguration() != null ? as.getSystemConfiguration().getDeviceNamed(name) : null;
    }

    public static Application getApplicationNamed(AutomationSystem as, String name) {
        return as.getApplication().stream().filter(element -> element.getName().equals(name)).findFirst().orElse(null);
    }

    public static boolean isArray(VarDeclaration vd) {
        return vd.getArraySize() != null && vd.getArraySize().getValue() != null && !vd.getArraySize().getValue().isBlank();
    }

    public static void setVarConfig(VarDeclarationImpl varDeclarationImpl, boolean config) {
        Annotations.setVarConfig(varDeclarationImpl, Boolean.toString(config));
    }

    private static void setVarConfig(VarDeclarationImpl varDeclarationImpl, String config) {
        varDeclarationImpl.setAttribute(InternalAttributeDeclarations.VAR_CONFIG, config, "");
    }

    public static boolean isVarConfig(VarDeclaration vd) {
        String configurationAttribute = vd.getAttributeValue("VarConfig");
        return "true".equals(configurationAttribute);
    }

    public static void setTarget(AttributeDeclaration attributeDeclaration, StructuredType target) {
        String targetString = target.getMemberVariables().stream().map(member -> member.getName() + ":=" + member.getValue().getValue()).collect(Collectors.joining(",", "(", ")"));
        if (!targetString.contains("FALSE")) {
            attributeDeclaration.deleteAttribute(InternalAttributeDeclarations.TARGET.getName());
        } else {
            attributeDeclaration.setAttribute(InternalAttributeDeclarations.TARGET, targetString, "");
        }
    }

    public static StructuredType getTarget(AttributeDeclaration attributeDeclaration) {
        String[] pairs;
        String targetString = attributeDeclaration.getAttributeValue(InternalAttributeDeclarations.TARGET.getName());
        if (targetString == null) {
            return null;
        }
        StructuredType structType = DataFactory.eINSTANCE.createStructuredType();
        targetString = targetString.substring(1, targetString.length() - 1);
        String[] stringArray = pairs = targetString.split(",");
        int n = pairs.length;
        int n2 = 0;
        while (n2 < n) {
            String pair = stringArray[n2];
            String[] keyValue = pair.split(":=");
            if (keyValue.length == 2) {
                MemberVarDeclaration member = LibraryElementFactory.eINSTANCE.createMemberVarDeclaration();
                member.setName(keyValue[0]);
                member.setType(IecTypes.ElementaryTypes.BOOL);
                Value val = LibraryElementFactory.eINSTANCE.createValue();
                val.setValue(keyValue[1]);
                member.setValue(val);
                structType.getMemberVariables().add((Object)member);
            }
            ++n2;
        }
        if (structType.getMemberVariables().size() != ((StructuredType)InternalAttributeDeclarations.TARGET.getType()).getMemberVariables().size()) {
            ((StructuredType)InternalAttributeDeclarations.TARGET.getType()).getMemberVariables().forEach(varDecl -> {
                Optional<VarDeclaration> correctMember = structType.getMemberVariables().stream().filter(member -> member.getName().equals(varDecl.getName())).findFirst();
                if (correctMember.isEmpty()) {
                    structType.getMemberVariables().add((Object)((VarDeclaration)EcoreUtil.copy((EObject)varDecl)));
                }
            });
        }
        return structType;
    }

    public static boolean isValidObject(AttributeDeclaration attributeDeclaration, ConfigurableObject object) {
        StructuredType target = attributeDeclaration.getTarget();
        if (target != null) {
            ConfigurableObject configurableObject = object;
            Objects.requireNonNull(configurableObject);
            ConfigurableObject configurableObject2 = configurableObject;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IInterfaceElement.class, SubApp.class, FBType.class, Application.class, Connection.class, FB.class, DataType.class}, (Object)configurableObject2, n)) {
                case 0 -> {
                    IInterfaceElement o = (IInterfaceElement)configurableObject2;
                    yield Annotations.getValueFromClassName(target, IInterfaceElement.class);
                }
                case 1 -> {
                    SubApp o = (SubApp)configurableObject2;
                    yield Annotations.getValueFromClassName(target, SubApp.class);
                }
                case 2 -> {
                    FBType o = (FBType)configurableObject2;
                    yield Annotations.getValueFromClassName(target, FBType.class);
                }
                case 3 -> {
                    Application o = (Application)configurableObject2;
                    yield Annotations.getValueFromClassName(target, Application.class);
                }
                case 4 -> {
                    Connection o = (Connection)configurableObject2;
                    yield Annotations.getValueFromClassName(target, Connection.class);
                }
                case 5 -> {
                    FB o = (FB)configurableObject2;
                    yield Annotations.getValueFromClassName(target, FB.class);
                }
                case 6 -> {
                    DataType o = (DataType)configurableObject2;
                    yield Annotations.getValueFromClassName(target, DataType.class);
                }
                default -> false;
            };
        }
        return true;
    }

    private static boolean getValueFromClassName(StructuredType lock, Class<?> clazz) {
        Optional<VarDeclaration> correctMember = lock.getMemberVariables().stream().filter(member -> member.getName().equals(clazz.getSimpleName())).findFirst();
        if (correctMember.isPresent()) {
            Value val = correctMember.get().getValue();
            return Boolean.parseBoolean(val.getValue());
        }
        return true;
    }

    public static void setAttribute(ConfigurableObject object, String attributeName, DataType type, String value, String comment) {
        Attribute attribute = Annotations.getAttribute(object, attributeName);
        if (attribute == null) {
            attribute = LibraryElementFactory.eINSTANCE.createAttribute();
            attribute.setName(attributeName);
            attribute.setType(type);
            attribute.setValue(value);
            if (comment != null) {
                attribute.setComment(comment);
            }
            object.getAttributes().add((Object)attribute);
        } else {
            attribute.setValue(value);
            if (comment != null) {
                attribute.setComment(comment);
            }
        }
    }

    public static void setAttribute(ConfigurableObject object, AttributeDeclaration attributeDeclaration, String value, String comment) {
        Attribute attribute = Annotations.getAttribute(object, attributeDeclaration.getName());
        if (attribute == null) {
            attribute = LibraryElementFactory.eINSTANCE.createAttribute();
            attribute.setName(attributeDeclaration.getName());
            attribute.setAttributeDeclaration(attributeDeclaration);
            attribute.setType(attributeDeclaration.getType());
            attribute.setValue(value);
            if (comment != null) {
                attribute.setComment(comment);
            }
            object.getAttributes().add((Object)attribute);
        } else {
            attribute.setValue(value);
            if (comment != null) {
                attribute.setComment(comment);
            }
        }
    }

    public static boolean deleteAttribute(ConfigurableObject object, String attributeName) {
        if (object != null && attributeName != null) {
            List<Attribute> toDelete = object.getAttributes().stream().filter(attr -> attributeName.equals(attr.getName())).toList();
            if (toDelete.isEmpty()) {
                return false;
            }
            toDelete.forEach(attr -> {
                boolean bl = object.getAttributes().remove(attr);
            });
            return true;
        }
        return false;
    }

    public static String getAttributeValue(ConfigurableObject object, String attributeName) {
        Attribute a = Annotations.getAttribute(object, attributeName);
        return a != null ? a.getValue() : null;
    }

    public static Attribute getAttribute(ConfigurableObject object, String attributeName) {
        return attributeName != null ? (Attribute)object.getAttributes().stream().filter(attribute -> attribute.getName().equalsIgnoreCase(attributeName)).findFirst().orElse(null) : null;
    }

    public static VarDeclaration getDataSource(DataConnection dc) {
        return (VarDeclaration)dc.getSource();
    }

    public static VarDeclaration getDataDestination(DataConnection dc) {
        return (VarDeclaration)dc.getDestination();
    }

    public static Event getEventSource(EventConnection ec) {
        return (Event)ec.getSource();
    }

    public static Event getEventDestination(EventConnection ec) {
        return (Event)ec.getDestination();
    }

    public static AdapterDeclaration getAdapterSource(AdapterConnection ac) {
        return (AdapterDeclaration)ac.getSource();
    }

    public static AdapterDeclaration getAdapterDestination(AdapterConnection ac) {
        return (AdapterDeclaration)ac.getDestination();
    }

    public static FBNetworkElement getFBNetworkElement(IInterfaceElement iie) {
        FBNetworkElement fBNetworkElement;
        EObject eObject = iie.eContainer();
        if (eObject instanceof InterfaceList) {
            InterfaceList il = (InterfaceList)eObject;
            fBNetworkElement = il.getFBNetworkElement();
        } else {
            fBNetworkElement = null;
        }
        return fBNetworkElement;
    }

    public static AutomationSystem getAutomationSystem(SystemConfiguration sc) {
        return (AutomationSystem)sc.eContainer();
    }

    public static Segment getSegmentNamed(SystemConfiguration sc, String name) {
        return sc.getSegments().stream().filter(segment -> segment.getName().equals(name)).findFirst().orElse(null);
    }

    public static Device getDeviceNamed(SystemConfiguration sc, String name) {
        return sc.getDevices().stream().filter(device -> device.getName().equals(name)).findFirst().orElse(null);
    }

    public static boolean isResourceTypeFB() {
        return true;
    }

    public static String getTypeName(TypedConfigureableObject tco) {
        return tco.getTypeEntry() != null ? tco.getTypeEntry().getTypeName() : null;
    }

    public static LibraryElement getType(TypedConfigureableObject tco) {
        return tco.getTypeEntry() != null ? tco.getTypeEntry().getType() : null;
    }

    public static TypeLibrary getTypeLibrary(TypedConfigureableObject tco) {
        return tco.getTypeEntry() != null ? tco.getTypeEntry().getTypeLibrary() : null;
    }

    public static boolean isSocket(AdapterFB afb) {
        return !afb.isPlug();
    }

    public static FBType getType(AdapterFB afb) {
        TypeEntry typeEntry = afb.getTypeEntry();
        if (typeEntry instanceof AdapterTypeEntry) {
            AdapterTypeEntry adpTypeEntry = (AdapterTypeEntry)typeEntry;
            if (afb.getAdapterDecl() != null) {
                if (afb.isPlug()) {
                    return adpTypeEntry.getType().getPlugType();
                }
                return adpTypeEntry.getType();
            }
        }
        return null;
    }

    public static boolean isPlug(AdapterFB afb) {
        return !afb.getAdapterDecl().isIsInput();
    }

    private Annotations() {
        throw new UnsupportedOperationException("The utility class Annotations should not be instatiated");
    }
}

