/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.ConnectionLayoutTagger;
import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.commands.QualNameAffectedCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeAttributeDeclarationCommand;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public class ChangeNameCommand
extends Command
implements ConnectionLayoutTagger,
QualNameAffectedCommand {
    private final INamedElement element;
    private final String name;
    private String oldName;
    private final String oldQualName;
    private final CompoundCommand additionalCommands = new CompoundCommand();
    private boolean validateName;

    private ChangeNameCommand(INamedElement element, String name) {
        this(element, name, true);
    }

    private ChangeNameCommand(INamedElement element, String name, boolean validateName) {
        this.element = Objects.requireNonNull(element);
        this.name = name;
        this.validateName = validateName;
        this.oldQualName = element.getQualifiedName();
    }

    public static ChangeNameCommand forName(INamedElement element, String name) {
        VarDeclaration varDecl;
        INamedElement toRename = element;
        if (element instanceof VarDeclaration && (varDecl = (VarDeclaration)element).isInOutVar() && !varDecl.isIsInput()) {
            toRename = varDecl.getInOutVarOpposite();
        }
        ChangeNameCommand result = new ChangeNameCommand(toRename, name);
        ChangeNameCommand.addAdditionalRenames(toRename, name, result);
        return result;
    }

    private static void addAdditionalRenames(INamedElement element, String name, ChangeNameCommand result) {
        SubApp subApp;
        IInterfaceElement interfaceElement;
        FBNetworkElement fBNetworkElement;
        FBNetworkElement fbne;
        if (element instanceof FBNetworkElement && (fbne = (FBNetworkElement)element).isMapped()) {
            result.getAdditionalCommands().add((Command)new ChangeNameCommand((INamedElement)fbne.getOpposite(), name));
        }
        if (element instanceof IInterfaceElement && (fBNetworkElement = (interfaceElement = (IInterfaceElement)element).getFBNetworkElement()) instanceof SubApp && (subApp = (SubApp)fBNetworkElement).isMapped()) {
            result.getAdditionalCommands().add((Command)new ChangeNameCommand((INamedElement)subApp.getOpposite().getInterfaceElement(interfaceElement.getName()), name));
        }
        if (element instanceof AdapterDeclaration) {
            AdapterDeclaration adapterDeclaration = (AdapterDeclaration)element;
            ChangeNameCommand.handleAdapterDeclarationRename(name, result, adapterDeclaration);
        }
        if (element instanceof AdapterFB) {
            AdapterFB adapterFB = (AdapterFB)element;
            result.getAdditionalCommands().add((Command)new ChangeNameCommand((INamedElement)adapterFB.getAdapterDecl(), name));
        }
        if (element instanceof Attribute) {
            Attribute attribute = (Attribute)element;
            result.setValidateName(false);
            if (ChangeAttributeDeclarationCommand.attributeDeclarationChanged(attribute, name)) {
                result.getAdditionalCommands().add((Command)ChangeAttributeDeclarationCommand.forName(attribute, name));
            }
        }
    }

    private static void handleAdapterDeclarationRename(String name, ChangeNameCommand result, AdapterDeclaration adapterDeclaration) {
        result.getAdditionalCommands().add((Command)new ChangeNameCommand((INamedElement)adapterDeclaration.getAdapterFB(), name, adapterDeclaration.getAdapterFB().eContainer() instanceof FBNetwork));
    }

    public boolean canExecute() {
        FBNetworkElement fbne;
        INamedElement iNamedElement;
        return !(this.isValidateName() && !NameRepository.isValidName((INamedElement)this.element, (String)this.name) || !this.additionalCommands.isEmpty() && !this.additionalCommands.canExecute() || (iNamedElement = this.element) instanceof FBNetworkElement && (fbne = (FBNetworkElement)iNamedElement).isContainedInTypedInstance());
    }

    public boolean canRedo() {
        return super.canRedo() && Objects.equals(this.oldName, this.element.getName()) && (this.additionalCommands.isEmpty() || this.additionalCommands.canRedo());
    }

    public boolean canUndo() {
        return super.canUndo() && Objects.equals(this.name, this.element.getName()) && (this.additionalCommands.isEmpty() || this.additionalCommands.canUndo());
    }

    public void execute() {
        this.oldName = this.element.getName();
        this.setName(this.name);
        this.additionalCommands.execute();
    }

    public void undo() {
        this.additionalCommands.undo();
        this.setName(this.oldName);
    }

    public void redo() {
        this.setName(this.name);
        this.additionalCommands.redo();
    }

    private void setName(String name) {
        this.element.setName(name);
    }

    public INamedElement getElement() {
        return this.element;
    }

    public CompoundCommand getAdditionalCommands() {
        return this.additionalCommands;
    }

    protected boolean isValidateName() {
        return this.validateName;
    }

    protected void setValidateName(boolean validateName) {
        this.validateName = validateName;
    }

    @Override
    public Set<EObject> getAffectedObjects() {
        INamedElement container = this.element;
        do {
            if (!((container = container.eContainer()) instanceof INamedElement)) continue;
            INamedElement namedContainer = container;
            return Set.of(namedContainer);
        } while (container != null);
        return Set.of(this.element);
    }

    @Override
    public List<INamedElement> getChangedElements() {
        return List.of(this.getElement());
    }

    @Override
    public String getOldQualName(INamedElement elemt) {
        if (elemt != this.element) {
            return null;
        }
        return this.oldQualName;
    }

    @Override
    public String getNewQualName(INamedElement element) {
        if (element != this.element) {
            return null;
        }
        return this.oldQualName.substring(0, this.oldQualName.length() - this.oldName.length()) + this.name;
    }
}

