/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.utilities;

import org.eclipse.core.resources.IProject;
import org.eclipse.fordiac.ide.application.utilities.FBTypeTemplateCreationFactory;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.FBTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.SubAppTypeEntry;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.gef.dnd.TemplateTransferDropTargetListener;
import org.eclipse.gef.requests.CreationFactory;

public class FbTypeTemplateTransferDropTargetListener
extends TemplateTransferDropTargetListener {
    private final IProject targetProject;

    public FbTypeTemplateTransferDropTargetListener(EditPartViewer viewer, IProject targetProject) {
        super(viewer);
        this.targetProject = targetProject;
    }

    protected void handleDragOver() {
        super.handleDragOver();
        this.getCurrentEvent().feedback = 24;
        Object template = TemplateTransfer.getInstance().getTemplate();
        if (template == null) {
            this.getCurrentEvent().detail = 0;
            this.getCurrentEvent().operations = 0;
        } else if (template instanceof FBTypeEntry) {
            FBTypeEntry entry = (FBTypeEntry)TemplateTransfer.getInstance().getTemplate();
            IProject srcProject = entry.getFile().getProject();
            if (this.targetProject != null && this.targetProject.equals((Object)srcProject)) {
                this.getCurrentEvent().detail = 1;
            } else {
                this.getCurrentEvent().detail = 0;
                this.getCurrentEvent().operations = 0;
            }
        } else {
            DataTypeEntry dataTypeEntry;
            Object object = TemplateTransfer.getInstance().getTemplate();
            if (object instanceof DataTypeEntry && (dataTypeEntry = (DataTypeEntry)object).getType() instanceof StructuredType && this.getTargetEditPart() != null) {
                Object model = this.getTargetEditPart().getModel();
                if (model instanceof StructManipulator) {
                    this.getCurrentEvent().detail = 1;
                } else {
                    this.getCurrentEvent().detail = 0;
                    this.getCurrentEvent().operations = 0;
                }
            }
        }
    }

    protected void handleDrop() {
        DataTypeEntry dataTypeEntry;
        Object object;
        if (!(this.getCurrentEvent().data instanceof FBTypeEntry || this.getCurrentEvent().data instanceof SubAppTypeEntry || (object = this.getCurrentEvent().data) instanceof DataTypeEntry && (dataTypeEntry = (DataTypeEntry)object).getType() instanceof StructuredType)) {
            return;
        }
        super.handleDrop();
        TemplateTransfer.getInstance().setTemplate(null);
    }

    protected CreationFactory getFactory(Object template) {
        DataTypeEntry dataTypeEntry;
        this.getCurrentEvent().detail = 1;
        if (template instanceof FBType || template instanceof FBTypeEntry || template instanceof SubAppTypeEntry || template instanceof DataTypeEntry && (dataTypeEntry = (DataTypeEntry)template).getType() instanceof StructuredType) {
            return new FBTypeTemplateCreationFactory(template);
        }
        return null;
    }
}

