/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.eval.fb;

import java.lang.runtime.SwitchBootstraps;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.eclipse.fordiac.ide.deployment.data.FBDeploymentData;
import org.eclipse.fordiac.ide.deployment.devResponse.Data;
import org.eclipse.fordiac.ide.deployment.devResponse.Port;
import org.eclipse.fordiac.ide.deployment.devResponse.Response;
import org.eclipse.fordiac.ide.deployment.devResponse.Watches;
import org.eclipse.fordiac.ide.deployment.eval.DeploymentEvaluatorSharedState;
import org.eclipse.fordiac.ide.deployment.eval.Messages;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.model.eval.Evaluator;
import org.eclipse.fordiac.ide.model.eval.EvaluatorException;
import org.eclipse.fordiac.ide.model.eval.fb.FBEvaluator;
import org.eclipse.fordiac.ide.model.eval.fb.FBEvaluatorCountingEventQueue;
import org.eclipse.fordiac.ide.model.eval.fb.FBEvaluatorEventQueue;
import org.eclipse.fordiac.ide.model.eval.function.StandardFunctions;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.ICallable;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public class DeploymentFBEvaluator<T extends FBType>
extends FBEvaluator<T> {
    private static final String FAKE_TIME_DEV_PARAM_NAME = "FakeTime";
    private DeploymentEvaluatorSharedState sharedState;
    private FBDeploymentData deploymentData;
    private boolean outputEvent;
    private final Map<Event, Integer> eventCounters = new HashMap<Event, Integer>();

    public DeploymentFBEvaluator(T type, Variable<?> context, Iterable<Variable<?>> variables, Evaluator parent) {
        super(type, context, variables, parent);
    }

    public void prepare() {
        if (this.sharedState == null) {
            this.sharedState = DeploymentEvaluatorSharedState.fromContext(this.getType().getTypeLibrary());
            this.deploymentData = this.createFBDeploymentData(this.sharedState.getResource());
            try {
                this.sharedState.prepare();
                this.sharedState.createFBInstance(this.deploymentData);
                this.sharedState.startFB(this.deploymentData);
                for (IInterfaceElement element : this.deploymentData.getFb().getInterface().getAllInterfaceElements()) {
                    this.sharedState.addWatch(this.sharedState.getResource(), this.getResourceRelativeName(element));
                }
                this.writeVariables((Iterable<VarDeclaration>)this.getType().getInterfaceList().getInputVars());
                this.writeVariables((Iterable<VarDeclaration>)this.getType().getInterfaceList().getInOutVars());
                this.updateWatches(this.sharedState.readWatches());
                this.outputEvent = false;
            }
            catch (DeploymentException e) {
                throw new EvaluatorException(e.getMessage(), (Throwable)e, (Evaluator)this);
            }
        }
    }

    public void cleanup() {
        if (this.sharedState != null) {
            try {
                try {
                    for (IInterfaceElement element : this.deploymentData.getFb().getInterface().getAllInterfaceElements()) {
                        this.sharedState.removeWatch(this.sharedState.getResource(), this.getResourceRelativeName(element));
                    }
                    this.sharedState.deleteFB(this.deploymentData);
                    this.sharedState.getResource().getFBNetwork().getNetworkElements().remove((Object)this.deploymentData.getFb());
                }
                catch (DeploymentException e) {
                    throw new EvaluatorException(e.getMessage(), (Throwable)e, (Evaluator)this);
                }
            }
            finally {
                this.sharedState = null;
            }
        }
    }

    protected FBDeploymentData createFBDeploymentData(Resource resource) {
        FB fb = LibraryElementFactory.eINSTANCE.createFB();
        fb.setName(this.getName() + "_" + UUID.randomUUID().toString());
        fb.setTypeEntry(this.getType().getTypeEntry());
        fb.setInterface(this.getType().getInterfaceList().copy());
        resource.getFBNetwork().getNetworkElements().add((Object)fb);
        return new FBDeploymentData("", (FBNetworkElement)fb);
    }

    public void evaluate(Event event) throws EvaluatorException, InterruptedException {
        this.prepare();
        Event instanceEvent = this.deploymentData.getFb().getInterface().getEvent(event.getName());
        if (instanceEvent == null) {
            throw new EvaluatorException(MessageFormat.format(Messages.DeploymentFBEvaluator_NoSuchInstanceEvent, event.getQualifiedName()), (Evaluator)this);
        }
        try {
            this.writeVariables((Iterable<VarDeclaration>)this.getType().getInterfaceList().getInputVars());
            this.writeVariables((Iterable<VarDeclaration>)this.getType().getInterfaceList().getInOutVars());
            this.sharedState.writeDeviceParameter(FAKE_TIME_DEV_PARAM_NAME, StandardFunctions.NOW_MONOTONIC().toString());
            this.sharedState.triggerEvent(this.sharedState.getResource(), this.getResourceRelativeName((IInterfaceElement)instanceEvent));
            this.pollWatches();
            this.update(this.getVariables().values());
        }
        catch (DeploymentException e) {
            throw new EvaluatorException(e.getMessage(), (Throwable)e, (Evaluator)this);
        }
    }

    protected void writeVariables(Iterable<VarDeclaration> varDeclarations) throws DeploymentException {
        for (VarDeclaration varDeclaration : varDeclarations) {
            Variable variable = (Variable)this.getVariables().get(varDeclaration.getName());
            this.sharedState.writeFBParameter(variable.toString(false), this.deploymentData, varDeclaration);
        }
    }

    protected void pollWatches() throws DeploymentException, InterruptedException {
        do {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            this.updateWatches(this.sharedState.readWatches());
        } while (!this.outputEvent);
        this.outputEvent = false;
    }

    protected void updateWatches(Response response) {
        Optional.ofNullable(response.getWatches()).map(Watches::getResources).stream().flatMap(Collection::stream).filter(resource -> this.sharedState.getResource().getName().equals(resource.getName())).map(org.eclipse.fordiac.ide.deployment.devResponse.Resource::getFbs).flatMap(Collection::stream).filter(fb -> this.deploymentData.getFb().getName().equals(fb.getName())).map(org.eclipse.fordiac.ide.deployment.devResponse.FB::getPorts).flatMap(Collection::stream).forEachOrdered(this::updateWatch);
    }

    protected void updateWatch(Port port) {
        IInterfaceElement element;
        if (port.getDataValues().isEmpty()) {
            return;
        }
        String newValue = ((Data)port.getDataValues().getLast()).getValue();
        IInterfaceElement iInterfaceElement = element = this.getType().getInterfaceList().getInterfaceElement(port.getName());
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{VarDeclaration.class, Event.class}, (Object)iInterfaceElement, n)) {
            case 0: {
                VarDeclaration varDeclaration = (VarDeclaration)iInterfaceElement;
                this.updateDataWatch(varDeclaration, newValue);
                break;
            }
            case 1: {
                Event event = (Event)iInterfaceElement;
                this.updateEventWatch(event, newValue);
                break;
            }
        }
    }

    protected void updateDataWatch(VarDeclaration varDeclaration, String newValue) throws IllegalArgumentException {
        Variable variable = (Variable)this.getVariables().get(varDeclaration.getName());
        if (variable != null) {
            variable.setValue(newValue, this.getType().getTypeLibrary());
        }
    }

    protected void updateEventWatch(Event event, String newValue) {
        Integer eventCount;
        try {
            eventCount = Integer.valueOf(newValue);
        }
        catch (NumberFormatException e) {
            this.error(Messages.DeploymentFBEvaluator_InvalidEventCounter, e);
            return;
        }
        if (eventCount.equals(this.eventCounters.put(event, eventCount))) {
            return;
        }
        FBEvaluatorEventQueue fBEvaluatorEventQueue = this.getEventQueue();
        if (fBEvaluatorEventQueue instanceof FBEvaluatorCountingEventQueue) {
            FBEvaluatorCountingEventQueue countingEventQueue = (FBEvaluatorCountingEventQueue)fBEvaluatorEventQueue;
            try {
                countingEventQueue.getCount(event).set(eventCount);
            }
            catch (NumberFormatException e) {
                this.error(Messages.DeploymentFBEvaluator_InvalidEventCounter, e);
            }
        }
        if (!event.isIsInput()) {
            this.outputEvent = true;
        }
    }

    protected String getResourceRelativeName(IInterfaceElement element) {
        String resourceName;
        String qualifiedName = element.getQualifiedName();
        if (qualifiedName.startsWith(resourceName = this.sharedState.getResource().getName())) {
            return qualifiedName.substring(resourceName.length() + 1);
        }
        return qualifiedName;
    }

    protected DeploymentEvaluatorSharedState getSharedState() {
        return this.sharedState;
    }

    protected FBDeploymentData getDeploymentData() {
        return this.deploymentData;
    }

    public Map<ICallable, Evaluator> getChildren() {
        return Collections.emptyMap();
    }
}

