/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.handlers;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.application.editparts.AbstractFBNElementEditPart;
import org.eclipse.fordiac.ide.application.editparts.ConnectionEditPart;
import org.eclipse.fordiac.ide.application.editparts.TargetInterfaceElementEditPart;
import org.eclipse.fordiac.ide.gef.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.model.commands.change.HideConnectionCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.HiddenElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;

public class ToggleConnectionsHandler
extends AbstractHandler
implements IElementUpdater {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structSel = (IStructuredSelection)selection;
            CompoundCommand commands = new CompoundCommand();
            IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
            CommandStack stack = (CommandStack)editor.getAdapter(CommandStack.class);
            GraphicalViewer viewer = (GraphicalViewer)editor.getAdapter(GraphicalViewer.class);
            boolean isVisible = ToggleConnectionsHandler.checkVisibilityOfSelection(structSel.toList());
            ToggleConnectionsHandler.toggleConnections(commands, (IStructuredSelection)selection, isVisible);
            if (stack != null) {
                stack.execute((Command)commands);
            }
            if (viewer != null) {
                ((GraphicalEditPart)viewer.getRootEditPart()).getFigure().invalidateTree();
            }
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    private static boolean checkVisibilityOfSelection(List<?> selection) {
        HashSet<Boolean> visibility = new HashSet<Boolean>();
        for (Object obj : selection) {
            if (obj instanceof ConnectionEditPart) {
                ConnectionEditPart conep = (ConnectionEditPart)((Object)obj);
                visibility.add(!conep.getFigure().isHidden());
                continue;
            }
            if (obj instanceof AbstractFBNElementEditPart) {
                AbstractFBNElementEditPart fbEP = (AbstractFBNElementEditPart)((Object)obj);
                for (IInterfaceElement element : fbEP.getModel().getInterface().getAllInterfaceElements()) {
                    if (element.isIsInput() && !element.getInputConnections().isEmpty()) {
                        element.getInputConnections().forEach(conn -> {
                            boolean bl = visibility.add(conn.isVisible());
                        });
                    }
                    if (element.isIsInput() || element.getOutputConnections().isEmpty()) continue;
                    element.getOutputConnections().forEach(conn -> {
                        boolean bl = visibility.add(conn.isVisible());
                    });
                }
                continue;
            }
            if (!(obj instanceof InterfaceEditPart)) continue;
            InterfaceEditPart iep = (InterfaceEditPart)obj;
            visibility.add(ToggleConnectionsHandler.checkPinVisibility(iep.getModel()));
        }
        if (visibility.size() == 2) {
            return true;
        }
        return visibility.contains(Boolean.TRUE);
    }

    private static void toggleConnections(CompoundCommand commands, IStructuredSelection selection, boolean isVisible) {
        for (Object obj : selection.toList()) {
            if (obj instanceof ConnectionEditPart) {
                ConnectionEditPart conEP = (ConnectionEditPart)((Object)obj);
                ToggleConnectionsHandler.addHideCommand(commands, conEP.getModel(), !isVisible);
                continue;
            }
            if (obj instanceof AbstractFBNElementEditPart) {
                AbstractFBNElementEditPart fbEP = (AbstractFBNElementEditPart)((Object)obj);
                fbEP.getModel().getInterface().getAllInterfaceElements().forEach(pin -> ToggleConnectionsHandler.togglePinConnections(commands, pin, isVisible));
                continue;
            }
            if (obj instanceof TargetInterfaceElementEditPart) {
                TargetInterfaceElementEditPart iep = (TargetInterfaceElementEditPart)((Object)obj);
                ToggleConnectionsHandler.togglePinConnections(commands, iep.getModel().getHost(), isVisible);
                continue;
            }
            if (!(obj instanceof InterfaceEditPart)) continue;
            InterfaceEditPart iep = (InterfaceEditPart)obj;
            ToggleConnectionsHandler.togglePinConnections(commands, iep.getModel(), isVisible);
        }
    }

    private static boolean checkPinVisibility(IInterfaceElement iel) {
        if (iel.isIsInput()) {
            if (iel.getInputConnections().isEmpty()) {
                return true;
            }
            return iel.getInputConnections().stream().allMatch(HiddenElement::isVisible);
        }
        if (iel.getOutputConnections().isEmpty()) {
            return true;
        }
        return iel.getOutputConnections().stream().allMatch(HiddenElement::isVisible);
    }

    private static void togglePinConnections(CompoundCommand commands, IInterfaceElement iel, boolean isVisible) {
        if (iel.isIsInput()) {
            iel.getInputConnections().forEach(conn -> {
                if (conn.isVisible() == isVisible) {
                    ToggleConnectionsHandler.addHideCommand(commands, conn, !isVisible);
                }
            });
        } else {
            iel.getOutputConnections().forEach(conn -> {
                if (conn.isVisible() == isVisible) {
                    ToggleConnectionsHandler.addHideCommand(commands, conn, !isVisible);
                }
            });
        }
    }

    private static void addHideCommand(CompoundCommand commands, Connection conn, boolean hide) {
        HideConnectionCommand hideConCmd = new HideConnectionCommand(conn, hide);
        if (hideConCmd.canExecute()) {
            commands.add((Command)hideConCmd);
        }
    }

    public void setEnabled(Object evaluationContext) {
        ISelection selection = (ISelection)HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        IEditorPart editor = (IEditorPart)HandlerUtil.getVariable((Object)evaluationContext, (String)"activeEditor");
        this.setBaseEnabled(selection != null && ToggleConnectionsHandler.validEditor(editor) && ToggleConnectionsHandler.selectionContainsConnectionsOrFbs(selection));
    }

    private static boolean selectionContainsConnectionsOrFbs(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structSel = (IStructuredSelection)selection;
            if (!selection.isEmpty()) {
                return structSel.toList().stream().anyMatch(ep -> ToggleConnectionsHandler.isConnection(ep) || ToggleConnectionsHandler.hasConnection(ep));
            }
        }
        return false;
    }

    private static boolean hasConnection(Object ep) {
        InterfaceEditPart iep;
        TargetInterfaceElementEditPart tiep;
        if (ep instanceof AbstractFBNElementEditPart) {
            AbstractFBNElementEditPart fbEP = (AbstractFBNElementEditPart)((Object)ep);
            for (IInterfaceElement ie : fbEP.getModel().getInterface().getAllInterfaceElements()) {
                if (!ToggleConnectionsHandler.hasConnection(ie)) continue;
                return true;
            }
        }
        return ep instanceof TargetInterfaceElementEditPart && ToggleConnectionsHandler.hasConnection((tiep = (TargetInterfaceElementEditPart)((Object)ep)).getModel().getHost()) || ep instanceof InterfaceEditPart && ToggleConnectionsHandler.hasConnection((iep = (InterfaceEditPart)ep).getModel());
    }

    private static boolean hasConnection(IInterfaceElement ie) {
        return ie.isIsInput() && !ie.getInputConnections().isEmpty() || !ie.isIsInput() && !ie.getOutputConnections().isEmpty();
    }

    private static boolean isConnection(Object ep) {
        ConnectionEditPart cep;
        return ep instanceof ConnectionEditPart && (cep = (ConnectionEditPart)((Object)ep)).getFigure() != null;
    }

    public void updateElement(UIElement element, Map parameters) {
        GraphicalViewer viewer;
        IEditorPart currentActiveEditor = EditorUtils.getCurrentActiveEditor();
        if (currentActiveEditor != null && (viewer = (GraphicalViewer)currentActiveEditor.getAdapter(GraphicalViewer.class)) != null) {
            boolean isVisible = ToggleConnectionsHandler.checkVisibilityOfSelection(viewer.getSelectedEditParts());
            if (viewer.getSelectedEditParts().size() == 1) {
                ToggleConnectionsHandler.setElementText(element, isVisible, viewer.getSelectedEditParts().get(0) instanceof ConnectionEditPart, viewer.getSelectedEditParts().get(0) instanceof TargetInterfaceElementEditPart);
            }
        }
    }

    private static void setElementText(UIElement element, boolean isVisible, boolean isSingular, boolean isTargetInterface) {
        if (isVisible) {
            element.setText(isSingular ? Messages.ToggleConnections_Singular_Hide : Messages.ToggleConnections_Hide);
        } else if (isTargetInterface) {
            element.setText(Messages.ToggleConnections_Target_Show);
        } else {
            element.setText(isSingular ? Messages.ToggleConnections_Singular_Show : Messages.ToggleConnections_Show);
        }
    }

    private static boolean validEditor(IEditorPart editor) {
        return editor != null && editor.getAdapter(FBNetwork.class) != null;
    }
}

