/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.api.subscriptions;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.eclipse.milo.opcua.sdk.client.api.subscriptions.UaMonitoredItem;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MonitoringMode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemCreateRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemModifyRequest;

public interface UaSubscription {
    public UInteger getSubscriptionId();

    public double getRequestedPublishingInterval();

    public double getRevisedPublishingInterval();

    public UInteger getRequestedLifetimeCount();

    public UInteger getRevisedLifetimeCount();

    public UInteger getRequestedMaxKeepAliveCount();

    public UInteger getRevisedMaxKeepAliveCount();

    public UInteger getMaxNotificationsPerPublish();

    public boolean isPublishingEnabled();

    public UByte getPriority();

    public ImmutableList<UaMonitoredItem> getMonitoredItems();

    public UInteger nextClientHandle();

    public CompletableFuture<List<UaMonitoredItem>> createMonitoredItems(TimestampsToReturn var1, List<MonitoredItemCreateRequest> var2);

    public CompletableFuture<List<UaMonitoredItem>> createMonitoredItems(TimestampsToReturn var1, List<MonitoredItemCreateRequest> var2, ItemCreationCallback var3);

    public CompletableFuture<List<StatusCode>> modifyMonitoredItems(TimestampsToReturn var1, List<MonitoredItemModifyRequest> var2);

    public CompletableFuture<List<StatusCode>> deleteMonitoredItems(List<UaMonitoredItem> var1);

    public CompletableFuture<List<StatusCode>> setMonitoringMode(MonitoringMode var1, List<UaMonitoredItem> var2);

    public CompletableFuture<StatusCode> setPublishingMode(boolean var1);

    public CompletableFuture<List<StatusCode>> addTriggeringLinks(UInteger var1, List<UInteger> var2);

    default public CompletableFuture<List<StatusCode>> addTriggeringLinks(UaMonitoredItem triggeringItem, List<UaMonitoredItem> linksToAdd) {
        return this.addTriggeringLinks(triggeringItem.getMonitoredItemId(), linksToAdd.stream().map(UaMonitoredItem::getMonitoredItemId).collect(Collectors.toList()));
    }

    public CompletableFuture<List<StatusCode>> removeTriggeringLinks(UInteger var1, List<UInteger> var2);

    default public CompletableFuture<List<StatusCode>> removeTriggeringLinks(UaMonitoredItem triggeringItem, List<UaMonitoredItem> linksToRemove) {
        return this.removeTriggeringLinks(triggeringItem.getMonitoredItemId(), linksToRemove.stream().map(UaMonitoredItem::getMonitoredItemId).collect(Collectors.toList()));
    }

    public void addNotificationListener(NotificationListener var1);

    public void removeNotificationListener(NotificationListener var1);

    public static interface NotificationListener {
        default public void onDataChangeNotification(UaSubscription subscription, List<UaMonitoredItem> monitoredItems, List<DataValue> dataValues, DateTime publishTime) {
        }

        default public void onEventNotification(UaSubscription subscription, List<UaMonitoredItem> monitoredItems, List<Variant[]> eventFields, DateTime publishTime) {
        }

        default public void onKeepAliveNotification(UaSubscription subscription, DateTime publishTime) {
        }

        default public void onStatusChangedNotification(UaSubscription subscription, StatusCode status) {
        }

        default public void onNotificationDataLost(UaSubscription subscription) {
        }

        default public void onSubscriptionTransferFailed(UaSubscription subscription, StatusCode statusCode) {
        }

        default public void onSubscriptionWatchdogTimerElapsed(UaSubscription subscription) {
        }
    }

    public static interface ItemCreationCallback {
        public void onItemCreated(UaMonitoredItem var1, int var2);
    }
}

