/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.options;

import org.eclipse.ocl.common.preferences.PreferenceableOption;
import org.eclipse.ocl.options.BasicOption;

public class ClassOption<T>
extends BasicOption<Class<? extends T>>
implements PreferenceableOption<Class<? extends T>> {
    protected final Class<? extends T> classType;

    public ClassOption(String pluginId, String key, Class<? extends T> defaultValue, Class<? extends T> classType) {
        super(pluginId, key, defaultValue);
        this.classType = classType;
    }

    public Class<? extends T> getValueOf(String string) {
        if (string == null || string.length() <= 0) {
            return null;
        }
        try {
            ClassLoader classLoader = this.classType.getClassLoader();
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            return classLoader.loadClass(string);
        }
        catch (ClassNotFoundException e) {
            return (Class)this.getDefaultValue();
        }
    }
}

