/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.runtime.SwitchBootstraps;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Objects;
import javax.xml.stream.XMLStreamException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.data.AnyDerivedType;
import org.eclipse.fordiac.ide.model.dataexport.AbstractTypeExporter;
import org.eclipse.fordiac.ide.model.dataexport.AdapterExporter;
import org.eclipse.fordiac.ide.model.dataexport.AttributeTypeExporter;
import org.eclipse.fordiac.ide.model.dataexport.DataTypeExporter;
import org.eclipse.fordiac.ide.model.dataexport.FCTExporter;
import org.eclipse.fordiac.ide.model.dataexport.FbtExporter;
import org.eclipse.fordiac.ide.model.dataexport.GlobalConstantsExporter;
import org.eclipse.fordiac.ide.model.dataexport.SubApplicationTypeExporter;
import org.eclipse.fordiac.ide.model.dataexport.SystemExporter;
import org.eclipse.fordiac.ide.model.dataimport.ADPImporter;
import org.eclipse.fordiac.ide.model.dataimport.AttributeTypeImporter;
import org.eclipse.fordiac.ide.model.dataimport.CommonElementImporter;
import org.eclipse.fordiac.ide.model.dataimport.DEVImporter;
import org.eclipse.fordiac.ide.model.dataimport.DataTypeImporter;
import org.eclipse.fordiac.ide.model.dataimport.FBTImporter;
import org.eclipse.fordiac.ide.model.dataimport.FCTImporter;
import org.eclipse.fordiac.ide.model.dataimport.GlobalConstantsImporter;
import org.eclipse.fordiac.ide.model.dataimport.RESImporter;
import org.eclipse.fordiac.ide.model.dataimport.SEGImporter;
import org.eclipse.fordiac.ide.model.dataimport.SubAppTImporter;
import org.eclipse.fordiac.ide.model.dataimport.SystemImporter;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.AttributeDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.FunctionFBType;
import org.eclipse.fordiac.ide.model.libraryElement.GlobalConstants;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.resource.TypeImportDiagnostic;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;

public class FordiacTypeResource
extends ResourceImpl {
    public FordiacTypeResource(URI uri) {
        super(uri);
    }

    protected void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        IFile typeFile = null;
        if (this.uri.isPlatformResource()) {
            typeFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.uri.toPlatformString(true)));
        } else if (this.uri.isFile()) {
            typeFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.uri.toFileString()));
            if (!typeFile.exists()) {
                throw new IOException(MessageFormat.format(Messages.FordiacTypeResource_NotInWorkspace, this.uri.toString()));
            }
        } else {
            throw new IOException(MessageFormat.format(Messages.FordiacTypeResource_LoadFromUnsupportedURI, this.uri.toString()));
        }
        try {
            CommonElementImporter importer = FordiacTypeResource.createImporterByFileExtensions(inputStream, typeFile);
            importer.loadElement();
            this.getErrors().addAll(importer.getErrors());
            this.getWarnings().addAll(importer.getWarnings());
            LibraryElement element = importer.getElement();
            if (element != null) {
                TypeEntry typeEntryForFile = TypeLibraryManager.INSTANCE.getTypeEntryForFile(typeFile);
                if (typeEntryForFile != null) {
                    element.setTypeEntry(typeEntryForFile);
                }
                this.getContents().add((Object)element);
            }
        }
        catch (TypeImportException e) {
            this.getErrors().add((Object)new TypeImportDiagnostic(e.getMessage(), Messages.FordiacTypeResource_TypeImportError));
        }
        catch (XMLStreamException e) {
            if (e.getLocation() != null) {
                this.getErrors().add((Object)new TypeImportDiagnostic(e.getMessage(), Messages.FordiacTypeResource_XMLError, e.getLocation().getLineNumber()));
            } else {
                this.getErrors().add((Object)new TypeImportDiagnostic(e.getMessage(), Messages.FordiacTypeResource_XMLError));
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Resource.IOWrappedException(e);
        }
    }

    protected void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
        if (!this.uri.isPlatformResource()) {
            throw new IOException(MessageFormat.format(Messages.FordiacTypeResource_SaveToUnsupportedURI, this.uri.toString()));
        }
        AbstractTypeExporter exporter = FordiacTypeResource.getTypeExporter((EObject)this.getContents().get(0));
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream inputStream = exporter.getFileContent();){
            inputStream.transferTo(outputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static AbstractTypeExporter getTypeExporter(EObject content) throws IOException {
        EObject eObject = content;
        Objects.requireNonNull(eObject);
        EObject eObject2 = eObject;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FunctionFBType.class, AdapterType.class, SubAppType.class, FBType.class, AnyDerivedType.class, AutomationSystem.class, GlobalConstants.class, AttributeDeclaration.class}, (Object)eObject2, n)) {
            case 0 -> {
                FunctionFBType funcType = (FunctionFBType)eObject2;
                yield new FCTExporter(funcType);
            }
            case 1 -> {
                AdapterType adpType = (AdapterType)eObject2;
                yield new AdapterExporter(adpType);
            }
            case 2 -> {
                SubAppType subAppType = (SubAppType)eObject2;
                yield new SubApplicationTypeExporter(subAppType);
            }
            case 3 -> {
                FBType fbType = (FBType)eObject2;
                yield new FbtExporter(fbType);
            }
            case 4 -> {
                AnyDerivedType dataType = (AnyDerivedType)eObject2;
                yield new DataTypeExporter(dataType);
            }
            case 5 -> {
                AutomationSystem system = (AutomationSystem)eObject2;
                yield new SystemExporter(system);
            }
            case 6 -> {
                GlobalConstants globalConstants = (GlobalConstants)eObject2;
                yield new GlobalConstantsExporter(globalConstants);
            }
            case 7 -> {
                AttributeDeclaration attributeType = (AttributeDeclaration)eObject2;
                yield new AttributeTypeExporter(attributeType);
            }
            default -> throw new IOException(MessageFormat.format(Messages.FordiacTypeResource_UnsupportedContent, content.toString()));
        };
    }

    protected void doUnload() {
        this.getContents().clear();
    }

    private static CommonElementImporter createImporterByFileExtensions(InputStream inputStream, IFile typeFile) throws IOException {
        TypeLibrary typeLib = TypeLibraryManager.INSTANCE.getTypeLibrary(typeFile.getProject());
        return switch (typeFile.getFileExtension().toUpperCase()) {
            case "SYS" -> new SystemImporter(inputStream, typeLib);
            case "FBT" -> new FBTImporter(inputStream, typeLib);
            case "FCT" -> new FCTImporter(inputStream, typeLib);
            case "ADP" -> new ADPImporter(inputStream, typeLib);
            case "ATP" -> new AttributeTypeImporter(inputStream, typeLib);
            case "DTP" -> new DataTypeImporter(inputStream, typeLib);
            case "DEV" -> new DEVImporter(inputStream, typeLib);
            case "RES" -> new RESImporter(inputStream, typeLib);
            case "SEG" -> new SEGImporter(inputStream, typeLib);
            case "SUB" -> new SubAppTImporter(inputStream, typeLib);
            case "GCF" -> new GlobalConstantsImporter(inputStream, typeLib);
            default -> throw new IOException(MessageFormat.format(Messages.FordiacTypeResource_UnsupportedFileType, typeFile));
        };
    }
}

