/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.helpers;

import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.typelibrary.AdapterTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.ErrorTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.FBTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.SubAppTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;

public final class BlockInstanceFactory {
    public static FBNetworkElement createBlockInstanceForTypeEntry(TypeEntry entry) {
        if (entry == null || entry instanceof ErrorTypeEntry) {
            return LibraryElementFactory.eINSTANCE.createErrorMarkerFBNElement();
        }
        if (entry instanceof SubAppTypeEntry) {
            return LibraryElementFactory.eINSTANCE.createTypedSubApp();
        }
        if (entry instanceof AdapterTypeEntry) {
            return LibraryElementFactory.eINSTANCE.createAdapterFB();
        }
        if (entry instanceof FBTypeEntry) {
            FBTypeEntry fbEntry = (FBTypeEntry)entry;
            return BlockInstanceFactory.createFBInstanceForTypeEntry(fbEntry);
        }
        return null;
    }

    public static FB createFBInstanceForTypeEntry(FBTypeEntry entry) {
        if (entry.getTypeName().startsWith("COMM_MESSAGE")) {
            return LibraryElementFactory.eINSTANCE.createCommunicationChannel();
        }
        if ("STRUCT_MUX".equals(entry.getTypeName())) {
            return LibraryElementFactory.eINSTANCE.createMultiplexer();
        }
        if ("STRUCT_DEMUX".equals(entry.getTypeName())) {
            return LibraryElementFactory.eINSTANCE.createDemultiplexer();
        }
        if ("F_MOVE".equals(entry.getTypeName())) {
            return LibraryElementFactory.eINSTANCE.createConfigurableMoveFB();
        }
        if (entry.getType() instanceof CompositeFBType) {
            return LibraryElementFactory.eINSTANCE.createCFBInstance();
        }
        return LibraryElementFactory.eINSTANCE.createFB();
    }

    private BlockInstanceFactory() {
        throw new UnsupportedOperationException();
    }
}

