/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.elk;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.util.ElkGraphUtil;
import org.eclipse.fordiac.ide.application.editparts.AbstractFBNElementEditPart;
import org.eclipse.fordiac.ide.application.editparts.ConnectionEditPart;
import org.eclipse.fordiac.ide.application.editparts.GroupContentEditPart;
import org.eclipse.fordiac.ide.application.editparts.GroupEditPart;
import org.eclipse.fordiac.ide.application.editparts.UnfoldedSubappContentEditPart;
import org.eclipse.fordiac.ide.application.editparts.UntypedSubAppInterfaceElementEditPart;
import org.eclipse.fordiac.ide.application.figures.FBNetworkConnection;
import org.eclipse.fordiac.ide.elk.FordiacLayoutMapping;
import org.eclipse.fordiac.ide.gef.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.gef.editparts.ValueEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;

public final class FordiacGraphBuilder {
    private static final PrecisionPoint START_POINT = new PrecisionPoint();
    private static final PrecisionPoint END_POINT = new PrecisionPoint();

    public static void build(FordiacLayoutMapping mapping) {
        if (mapping.type != FordiacLayoutMapping.LayoutType.Application) {
            FordiacGraphBuilder.processParentInterfaces(mapping);
        }
        for (Object child : mapping.getParentElement().getChildren()) {
            FordiacGraphBuilder.processChild(mapping, child);
        }
        FordiacGraphBuilder.processConnections(mapping);
    }

    private static void processParentInterfaces(FordiacLayoutMapping mapping) {
        List children = switch (mapping.type) {
            case FordiacLayoutMapping.LayoutType.Typed -> mapping.getParentElement().getChildren();
            case FordiacLayoutMapping.LayoutType.Unfolded -> mapping.getParentElement().getParent().getChildren();
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)mapping.type));
        };
        children.stream().filter(InterfaceEditPart.class::isInstance).map(InterfaceEditPart.class::cast).forEach(ie -> {
            FordiacGraphBuilder.createParentElementPort(ie, mapping);
            FordiacGraphBuilder.processInterface(mapping, ie);
        });
    }

    private static void processChild(FordiacLayoutMapping mapping, Object child) {
        if (child instanceof GroupEditPart) {
            GroupEditPart groupEditPart = (GroupEditPart)child;
        }
        if (child instanceof AbstractFBNElementEditPart) {
            AbstractFBNElementEditPart fbnEl = (AbstractFBNElementEditPart)child;
            FordiacGraphBuilder.processFB(mapping, (GraphicalEditPart)fbnEl);
        }
        if (child instanceof ValueEditPart) {
            ValueEditPart value = (ValueEditPart)child;
            FordiacGraphBuilder.processValue(mapping, value);
        }
    }

    private static void processFB(FordiacLayoutMapping mapping, GraphicalEditPart ep) {
        FordiacGraphBuilder.createNode(mapping, (AbstractFBNElementEditPart)ep, mapping.getLayoutGraph());
        for (Object child : ep.getChildren()) {
            if (!(child instanceof InterfaceEditPart)) continue;
            InterfaceEditPart ie = (InterfaceEditPart)child;
            FordiacGraphBuilder.processInterface(mapping, ie);
        }
    }

    private static void processInterface(FordiacLayoutMapping mapping, Object child) {
        UntypedSubAppInterfaceElementEditPart ie;
        UntypedSubAppInterfaceElementEditPart ie2;
        if (child instanceof UntypedSubAppInterfaceElementEditPart && !(ie2 = (UntypedSubAppInterfaceElementEditPart)child).isInput() && ie2.getParent() != mapping.getNetworkEditPart().getParent()) {
            return;
        }
        if (child instanceof UntypedSubAppInterfaceElementEditPart && (ie = (UntypedSubAppInterfaceElementEditPart)child).isInput() && ie.getParent() == mapping.getNetworkEditPart().getParent()) {
            return;
        }
        ((InterfaceEditPart)child).getTargetConnections().stream().filter(ConnectionEditPart.class::isInstance).filter(con -> FordiacGraphBuilder.isVisible((ConnectionEditPart)con)).forEach(conn -> FordiacGraphBuilder.saveConnection(mapping, (ConnectionEditPart)conn));
    }

    private static void processValue(FordiacLayoutMapping mapping, ValueEditPart valueEditPart) {
        EditPart iePart = valueEditPart.getViewer().getEditPartForModel((Object)valueEditPart.getModel().getParentIE());
        Point point = ((InterfaceEditPart)iePart).getFigure().getBounds().getTopLeft();
        ElkPort port = FordiacGraphBuilder.getPort(point, (InterfaceEditPart)iePart, mapping);
        ElkLabel label = ElkGraphUtil.createLabel((String)valueEditPart.getModel().getValue(), (ElkGraphElement)port);
        Rectangle bounds = valueEditPart.getFigure().getBounds();
        label.setLocation(bounds.preciseX() - port.getX() - port.getParent().getX(), bounds.preciseY() - port.getY() - port.getParent().getY());
        label.setDimensions(bounds.preciseWidth(), bounds.preciseHeight());
    }

    private static boolean isVisible(ConnectionEditPart con) {
        FBNetworkConnection conFigure = con.getFigure();
        return conFigure.isVisible() && !conFigure.isHidden();
    }

    private static void saveConnection(FordiacLayoutMapping mapping, ConnectionEditPart conn) {
        if (!mapping.getConnections().contains(conn)) {
            EditPart sourceContainer = conn.getSource().getParent().getParent();
            EditPart targetContainer = conn.getTarget().getParent().getParent();
            if (sourceContainer instanceof UnfoldedSubappContentEditPart || targetContainer instanceof UnfoldedSubappContentEditPart) {
                mapping.getConnections().add(conn);
            } else if (!(sourceContainer instanceof GroupContentEditPart) && !(targetContainer instanceof GroupContentEditPart) || sourceContainer == targetContainer) {
                mapping.getConnections().add(conn);
            }
        }
    }

    private static void createNode(FordiacLayoutMapping mapping, AbstractFBNElementEditPart editPart, ElkNode parent) {
        ElkNode node = ElkGraphUtil.createNode((ElkNode)parent);
        Rectangle bounds = editPart.getFigure().getBounds();
        if (mapping.type != FordiacLayoutMapping.LayoutType.Application) {
            node.setLocation((double)bounds.x - mapping.getLayoutGraph().getX(), (double)bounds.y - mapping.getLayoutGraph().getY());
        } else {
            node.setLocation((double)bounds.x, (double)bounds.y);
        }
        node.setDimensions(bounds.preciseWidth(), bounds.preciseHeight());
        node.setProperty(CoreOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FIXED_POS);
        ElkLabel label = ElkGraphUtil.createLabel((String)editPart.getModel().getName(), (ElkGraphElement)node);
        Rectangle labelBounds = editPart.getFigure().getLabelBounds();
        label.setDimensions((double)labelBounds.width(), (double)labelBounds.height());
        mapping.getGraphMap().put((Object)node, (Object)editPart);
        mapping.getReverseMapping().put((GraphicalEditPart)editPart, (ElkGraphElement)node);
    }

    private static void processConnections(FordiacLayoutMapping mapping) {
        for (ConnectionEditPart conn : mapping.getConnections()) {
            FBNetworkConnection connFig = conn.getFigure();
            START_POINT.setLocation(connFig.getSourceAnchor().getLocation(connFig.getSourceAnchor().getReferencePoint()));
            END_POINT.setLocation(connFig.getTargetAnchor().getLocation(connFig.getTargetAnchor().getReferencePoint()));
            connFig.translateToRelative((Translatable)START_POINT);
            connFig.translateToRelative((Translatable)END_POINT);
            ElkPort sourcePort = FordiacGraphBuilder.getPort((Point)START_POINT, (InterfaceEditPart)conn.getSource(), mapping);
            ElkPort destinationPort = FordiacGraphBuilder.getPort((Point)END_POINT, (InterfaceEditPart)conn.getTarget(), mapping);
            ElkEdge edge = ElkGraphUtil.createSimpleEdge((ElkConnectableShape)sourcePort, (ElkConnectableShape)destinationPort);
            mapping.getGraphMap().put((Object)edge, (Object)conn);
            mapping.getReverseMapping().put((GraphicalEditPart)conn, (ElkGraphElement)edge);
        }
    }

    private static ElkPort getPort(Point point, InterfaceEditPart interfaceEditPart, FordiacLayoutMapping mapping) {
        return (ElkPort)mapping.getReverseMapping().computeIfAbsent((GraphicalEditPart)interfaceEditPart, ie -> FordiacGraphBuilder.createPort(interfaceEditPart, mapping));
    }

    private static ElkPort createPort(InterfaceEditPart interfaceEditPart, FordiacLayoutMapping mapping) {
        EditPart parent = interfaceEditPart.getParent();
        ElkNode parentNode = FordiacGraphBuilder.determineParentNode(parent, mapping);
        ElkPort port = ElkGraphUtil.createPort((ElkNode)parentNode);
        FordiacGraphBuilder.configurePortDimensions(port, interfaceEditPart);
        FordiacGraphBuilder.setPortLocation(port, interfaceEditPart, parentNode, mapping);
        port.setProperty(CoreOptions.PORT_SIDE, (Object)(interfaceEditPart.isInput() ? PortSide.WEST : PortSide.EAST));
        mapping.getGraphMap().put((Object)port, (Object)interfaceEditPart.getModel());
        return port;
    }

    private static ElkNode determineParentNode(EditPart parent, FordiacLayoutMapping mapping) {
        ElkNode parentNode = (ElkNode)mapping.getReverseMapping().get(parent);
        if (parent == mapping.getParentElement().getParent()) {
            parentNode = mapping.getLayoutGraph();
        }
        return parentNode;
    }

    private static void configurePortDimensions(ElkPort port, InterfaceEditPart interfaceEditPart) {
        IFigure figure = interfaceEditPart.getFigure();
        port.setDimensions(1.0, figure.getBounds().preciseHeight());
    }

    private static void setPortLocation(ElkPort port, InterfaceEditPart interfaceEditPart, ElkNode parentNode, FordiacLayoutMapping mapping) {
        int x = interfaceEditPart.isInput() ? 0 : (int)parentNode.getWidth();
        int yOffset = interfaceEditPart.getFigure().getLocation().y - (int)parentNode.getY();
        int y = mapping.type == FordiacLayoutMapping.LayoutType.Application ? yOffset : yOffset - (int)mapping.getLayoutGraph().getY();
        port.setLocation((double)x, (double)y);
    }

    private static ElkPort createParentElementPort(InterfaceEditPart ie, FordiacLayoutMapping mapping) {
        boolean isInput;
        ElkNode layoutGraph = mapping.getLayoutGraph();
        ElkPort port = ElkGraphUtil.createPort((ElkNode)layoutGraph);
        port.setDimensions(1.0, (double)ie.getFigure().getBounds().height);
        int y = ie.getFigure().getLocation().y;
        boolean bl = mapping.type == FordiacLayoutMapping.LayoutType.Unfolded ? ie.isInput() : (isInput = !ie.isInput());
        if (isInput) {
            port.setLocation(0.0, (double)y - layoutGraph.getY());
        } else {
            port.setLocation(layoutGraph.getWidth() - 1.0, (double)y - layoutGraph.getY());
        }
        port.setProperty(CoreOptions.PORT_SIDE, (Object)(isInput ? PortSide.WEST : PortSide.EAST));
        mapping.getGraphMap().put((Object)port, (Object)ie.getModel());
        mapping.getReverseMapping().put((GraphicalEditPart)ie, (ElkGraphElement)port);
        return port;
    }

    private FordiacGraphBuilder() {
        throw new UnsupportedOperationException("Utility Class should not be instantiated!");
    }
}

