/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.util;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerDataType;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.typemanagement.util.TypeFromTemplateCreator;

public class ErrorMarkerResolver {
    public static final String TEMPLATE_PATH = Platform.getInstallLocation().getURL().getFile() + File.separatorChar + "template";

    public static void repairMissingStructuredDataType(VarDeclaration target) {
        DataType type;
        File template = new File(TEMPLATE_PATH + File.separatorChar + "Struct.dtp");
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)target);
        IPath fullPath = null;
        if (rootContainer instanceof LibraryElement) {
            LibraryElement le = (LibraryElement)rootContainer;
            fullPath = le.getTypeEntry().getTypeLibrary().getProject().getFullPath();
        }
        if ((type = target.getType()) instanceof ErrorMarkerDataType) {
            IFile targetFile = ErrorMarkerResolver.getTargetFile(type.getName(), fullPath, ".dtp");
            TypeFromTemplateCreator creator = new TypeFromTemplateCreator(targetFile, template, "");
            creator.createTypeFromTemplate((IProgressMonitor)new NullProgressMonitor());
        }
    }

    private static IFile getTargetFile(String typeName, IPath path, String fileEnding) {
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(String.valueOf(path) + File.separator + "Type Library" + File.separator + typeName + fileEnding));
    }
}

