/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring;

import java.util.EnumSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.typemanagement.refactoring.ConfigurableChange;
import org.eclipse.fordiac.ide.typemanagement.refactoring.IFordiacPreviewChange;
import org.eclipse.fordiac.ide.typemanagement.refactoring.ReconnectPinByName;
import org.eclipse.gef.commands.Command;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class ReconnectPinChange
extends ConfigurableChange<FBNetworkElement> {
    private final String newName;
    private final String oldName;

    public ReconnectPinChange(URI elementURI, Class<FBNetworkElement> elementClass, String newName, String oldName) {
        super("Handle connection of : " + oldName, elementURI, elementClass);
        this.newName = newName;
        this.oldName = oldName;
    }

    @Override
    protected Command createCommand(FBNetworkElement element) {
        return new ReconnectPinByName(this.oldName, this.newName, element, this.getState());
    }

    @Override
    public EnumSet<IFordiacPreviewChange.ChangeState> getAllowedChoices() {
        return EnumSet.of(IFordiacPreviewChange.ChangeState.RECONNECT, IFordiacPreviewChange.ChangeState.NO_CHANGE, IFordiacPreviewChange.ChangeState.DELETE);
    }

    @Override
    public EnumSet<IFordiacPreviewChange.ChangeState> getDefaultSelection() {
        return EnumSet.of(IFordiacPreviewChange.ChangeState.RECONNECT);
    }

    @Override
    public void initializeValidationData(FBNetworkElement element, IProgressMonitor pm) {
    }

    @Override
    public RefactoringStatus isValid(FBNetworkElement element, IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return super.isValid(element, pm);
    }
}

