/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typeeditor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.ui.editors.ITypeEditorInput;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.FileEditorInputFactory;

public class TypeEditorInput
implements ITypeEditorInput,
IPersistableElement {
    private LibraryElement type;
    private final TypeEntry entry;
    private final IFile file;

    public TypeEditorInput(LibraryElement type, TypeEntry entry) {
        this(type, entry, entry.getFile());
    }

    public TypeEditorInput(LibraryElement type, TypeEntry entry, IFile file) {
        this.type = type;
        this.entry = entry;
        this.file = file;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageDescriptor.getMissingImageDescriptor();
    }

    public String getName() {
        return this.type.getName() == null ? "" : this.type.getName();
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    public String getToolTipText() {
        return this.type.getComment() == null ? "" : this.type.getComment() + " (" + this.getFile().getProjectRelativePath().toString() + ")";
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    public LibraryElement getContent() {
        return this.type;
    }

    public TypeEntry getTypeEntry() {
        return this.entry;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IFileEditorInput) {
            IFileEditorInput other = (IFileEditorInput)obj;
            return this.getFile().equals((Object)other.getFile());
        }
        return false;
    }

    public int hashCode() {
        return this.getFile().hashCode();
    }

    public void saveState(IMemento memento) {
        FileEditorInputFactory.saveState((IMemento)memento, (FileEditorInput)new FileEditorInput(this.getFile()));
    }

    public void setType(LibraryElement fbType) {
        this.type = fbType;
    }

    public IStorage getStorage() throws CoreException {
        return this.getFile();
    }

    public String getFactoryId() {
        return FileEditorInputFactory.getFactoryId();
    }

    public IFile getFile() {
        return this.file;
    }
}

