/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.widgets;

import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editors.IAlgorithmEditor;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editors.TextEditor;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.TextAlgorithm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class AlgorithmEditingComposite {
    private Composite codeEditors;
    private final StackLayout stack = new StackLayout();
    private IAlgorithmEditor editor;
    private Algorithm currentAlgorithm;

    protected AlgorithmEditingComposite() {
    }

    public void createControls(Composite parent, FormToolkit toolkit) {
        GridData codeEditorsGridData = new GridData(4, 4, true, true);
        codeEditorsGridData.horizontalSpan = 1;
        codeEditorsGridData.minimumHeight = 250;
        this.codeEditors = new Group(parent, 32);
        this.codeEditors.setBackground(toolkit.getColors().getBackground());
        this.codeEditors.setForeground(toolkit.getColors().getForeground());
        toolkit.adapt(this.codeEditors);
        this.codeEditors.setLayout((Layout)this.stack);
        this.codeEditors.setLayoutData((Object)codeEditorsGridData);
        this.editor = new TextEditor(this.codeEditors, null, null);
        this.disableAllFields();
    }

    protected BaseFBType getFBType() {
        return (BaseFBType)this.currentAlgorithm.eContainer();
    }

    protected Algorithm getAlgorithm() {
        return this.currentAlgorithm;
    }

    public void setAlgorithm(Algorithm algorithm) {
        if (this.currentAlgorithm != algorithm) {
            this.currentAlgorithm = algorithm;
            if (this.currentAlgorithm != null) {
                this.initializeEditor();
                this.enableAllFields();
            } else {
                this.stack.topControl = null;
                this.codeEditors.layout();
                this.disableAllFields();
            }
        }
        this.updateAlgFields();
    }

    protected void enableAllFields() {
    }

    protected void disableAllFields() {
    }

    protected void updateAlgFields() {
        Algorithm alg = this.getAlgorithm();
        if (alg instanceof TextAlgorithm) {
            this.editor.setAlgorithmText(((TextAlgorithm)alg).getText());
        }
    }

    private void initializeEditor() {
        this.stack.topControl = this.editor.getControl();
        this.codeEditors.layout();
    }
}

