/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.variable;

import org.eclipse.fordiac.ide.model.data.EventType;
import org.eclipse.fordiac.ide.model.eval.value.EventValue;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.variable.AbstractVariable;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.value.TypedValue;

public class EventVariable
extends AbstractVariable<EventValue> {
    private EventValue value;

    public EventVariable(String name, EventType type) {
        super(name, (INamedElement)type);
        this.value = new EventValue(type);
    }

    public EventVariable(String name, EventType type, long value) {
        super(name, (INamedElement)type);
        this.setValue(value);
    }

    public EventVariable(String name, EventType type, String value) {
        super(name, (INamedElement)type);
        this.setValue(value);
    }

    public EventVariable(String name, EventType type, Value value) {
        super(name, (INamedElement)type);
        this.setValue(value);
    }

    @Override
    public void setValue(Value value) {
        EventValue eventValue;
        if (!(value instanceof EventValue) || (eventValue = (EventValue)value).getType() != this.getType()) {
            throw this.createCastException(value);
        }
        this.value = eventValue;
    }

    @Override
    public void setValue(String value, TypeLibrary typeLibrary) {
        this.setValue(Long.parseLong(value));
    }

    @Override
    public void setValue(TypedValue value) {
        if (!this.getType().isAssignableFrom(value.type())) {
            this.createCastException(value);
        }
        this.setValue(((Number)value.value()).longValue());
    }

    public void setValue(long value) {
        this.value = new EventValue(this.getType(), value);
    }

    @Override
    public boolean validateValue(String value, TypeLibrary typeLibrary) {
        try {
            Long.parseLong(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public EventType getType() {
        return (EventType)super.getType();
    }

    @Override
    public EventValue getValue() {
        return this.value;
    }
}

