/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.libraryElement.impl;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.datatype.helper.TypeDeclarationParser;
import org.eclipse.fordiac.ide.model.errormarker.FordiacMarkerHelper;
import org.eclipse.fordiac.ide.model.helpers.VarInOutHelper;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public class VarDeclarationAnnotations {
    public static boolean validateMultipleInputConnections(VarDeclaration varDeclaration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (varDeclaration.isIsInput() && varDeclaration.getInputConnections().size() > 1) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.fordiac.ide.model.libraryElement", 25, Messages.VarDeclarationAnnotations_MultipleInputConnections, FordiacMarkerHelper.getDiagnosticData((EObject)varDeclaration, (EStructuralFeature)LibraryElementPackage.Literals.IINTERFACE_ELEMENT__INPUT_CONNECTIONS, new String[0])));
            }
            return false;
        }
        return true;
    }

    public static boolean validateNoValueForGenericTypeVariable(VarDeclaration varDeclaration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (IecTypes.GenericTypes.isAnyType(varDeclaration.getType()) && VarDeclarationAnnotations.hasValue(varDeclaration) && varDeclaration.getFBNetworkElement() == null) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.fordiac.ide.model.libraryElement", 26, Messages.VarDeclarationAnnotations_ShouldNotSpecifyValueForGenericVariableInType, FordiacMarkerHelper.getDiagnosticData((EObject)varDeclaration, new String[0])));
            }
            return false;
        }
        return true;
    }

    public static boolean validateNoValueForVariableLengthArrayVariable(VarDeclaration varDeclaration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (varDeclaration.isArray() && VarDeclarationAnnotations.hasValue(varDeclaration) && TypeDeclarationParser.isVariableArrayBounds(varDeclaration.getArraySize().getValue())) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.fordiac.ide.model.libraryElement", 27, Messages.VarDeclarationAnnotations_MustNotSpecifyValueForVariableWithVariableArrayBounds, FordiacMarkerHelper.getDiagnosticData((EObject)varDeclaration, new String[0])));
            }
            return false;
        }
        return true;
    }

    public static boolean validateValueForGenericInstanceVariable(VarDeclaration varDeclaration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (varDeclaration.isIsInput() && varDeclaration.getInputConnections().isEmpty() && IecTypes.GenericTypes.isAnyType(varDeclaration.getType()) && !VarDeclarationAnnotations.hasValue(varDeclaration) && varDeclaration.getFBNetworkElement() != null && varDeclaration.getFBNetworkElement().eContainingFeature() != LibraryElementPackage.Literals.BASE_FB_TYPE__INTERNAL_FBS) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.fordiac.ide.model.libraryElement", 28, Messages.VarDeclarationAnnotations_ShouldSpecifyValueForGenericVariableInInstance, FordiacMarkerHelper.getDiagnosticData((EObject)varDeclaration, new String[0])));
            }
            return false;
        }
        return true;
    }

    public static boolean validateVarInOutSourceTypeIsWellDefined(VarDeclaration varDeclaration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (varDeclaration.isInOutVar() && varDeclaration.isIsInput() && varDeclaration.getFBNetworkElement() != null && varDeclaration.getInputConnections().isEmpty() && (varDeclaration.isArray() && TypeDeclarationParser.isVariableArrayBounds(varDeclaration.getArraySize().getValue()) || IecTypes.GenericTypes.isAnyType(varDeclaration.getType()))) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.fordiac.ide.model.libraryElement", 29, MessageFormat.format(Messages.ConnectionValidator_VarInOutSourceNotWellDefined, varDeclaration.getFullTypeName()), FordiacMarkerHelper.getDiagnosticData((EObject)varDeclaration, new String[0])));
            }
            return false;
        }
        return true;
    }

    public static boolean validateVarInOutIsWithed(VarDeclaration varDeclaration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (varDeclaration.isInOutVar() && varDeclaration.getWiths().isEmpty() && varDeclaration.getFBNetworkElement() == null && !VarDeclarationAnnotations.isSubappTypeInterface(varDeclaration)) {
            if (diagnostics != null) {
                String string;
                EObject eObject = varDeclaration.eContainer().eContainer();
                if (eObject instanceof FB) {
                    FB fb = (FB)eObject;
                    string = fb.getName();
                } else {
                    string = ((INamedElement)varDeclaration.eContainer().eContainer()).getName();
                }
                String typeName = string;
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.fordiac.ide.model.libraryElement", 30, MessageFormat.format(varDeclaration.isIsInput() ? Messages.ConnectionValidator_VarInOutInputSideHasNoWith : Messages.ConnectionValidator_VarInOutOutputSideHasNoWith, varDeclaration.getName(), typeName), FordiacMarkerHelper.getDiagnosticData((EObject)varDeclaration, new String[0])));
            }
            return false;
        }
        return true;
    }

    public static boolean validateVarInOutSubappInterface(VarDeclaration varDeclaration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (varDeclaration.isInOutVar() && varDeclaration.getFBNetworkElement() instanceof SubApp && VarDeclarationAnnotations.hasAnyOutputConnections(varDeclaration) && !VarDeclarationAnnotations.hasAnyInputConnections(varDeclaration)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.fordiac.ide.model.libraryElement", 31, MessageFormat.format(varDeclaration.isIsInput() ? Messages.VarDeclarationAnnotations_VarInOutLeftNotConnected : Messages.VarDeclarationAnnotations_VarInOutRightNotConnected, varDeclaration.getName()), FordiacMarkerHelper.getDiagnosticData((EObject)varDeclaration, new String[0])));
            }
            return false;
        }
        return true;
    }

    public static boolean validateVarInOutSubappNetwork(VarDeclaration varDeclaration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        VarDeclaration source;
        if (varDeclaration.isInOutVar() && !varDeclaration.isIsInput() && (VarDeclarationAnnotations.isUntypedSubappInterface(varDeclaration) || VarDeclarationAnnotations.isSubappTypeInterface(varDeclaration)) && !varDeclaration.getInOutVarOpposite().getOutputConnections().isEmpty() && (source = VarInOutHelper.getDefiningVarInOutDeclaration(varDeclaration)) != null && source.eContainer() != varDeclaration.eContainer()) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.fordiac.ide.model.libraryElement", 32, MessageFormat.format(Messages.VarDeclarationAnnotations_VarInOutSubappNetwork, varDeclaration.getName()), FordiacMarkerHelper.getDiagnosticData((EObject)varDeclaration, new String[0])));
            }
            return false;
        }
        return true;
    }

    public static VarDeclaration getInOutVarOpposite(VarDeclaration inOutVar) {
        InterfaceList interfaceList = (InterfaceList)inOutVar.eContainer();
        if (inOutVar.isInOutVar()) {
            if (inOutVar.isIsInput()) {
                return (VarDeclaration)interfaceList.getOutMappedInOutVars().get(interfaceList.getInOutVars().indexOf((Object)inOutVar));
            }
            return (VarDeclaration)interfaceList.getInOutVars().get(interfaceList.getOutMappedInOutVars().indexOf((Object)inOutVar));
        }
        return inOutVar;
    }

    static boolean hasValue(VarDeclaration varDeclaration) {
        return varDeclaration.getValue() != null && varDeclaration.getValue().getValue() != null && !varDeclaration.getValue().getValue().isEmpty();
    }

    static boolean isSubappTypeInterface(VarDeclaration varDeclaration) {
        InterfaceList interfaceList;
        EObject eObject = varDeclaration.eContainer();
        return eObject instanceof InterfaceList && (interfaceList = (InterfaceList)eObject).eContainer() instanceof SubAppType;
    }

    static boolean isUntypedSubappInterface(VarDeclaration varDeclaration) {
        SubApp subapp;
        FBNetworkElement fBNetworkElement = varDeclaration.getFBNetworkElement();
        return fBNetworkElement instanceof SubApp && !(subapp = (SubApp)fBNetworkElement).isTyped();
    }

    static boolean hasAnyInputConnections(VarDeclaration varDeclaration) {
        return varDeclaration != null && (!varDeclaration.getInputConnections().isEmpty() || !VarDeclarationAnnotations.getTypeVariable(varDeclaration).getInputConnections().isEmpty());
    }

    static boolean hasAnyOutputConnections(VarDeclaration varDeclaration) {
        return varDeclaration != null && (!varDeclaration.getOutputConnections().isEmpty() || !VarDeclarationAnnotations.getTypeVariable(varDeclaration).getOutputConnections().isEmpty());
    }

    public static VarDeclaration getTypeVariable(VarDeclaration varDeclaration) {
        FBType type;
        FBNetworkElement fbne;
        if (varDeclaration != null && (fbne = varDeclaration.getFBNetworkElement()) != null && (type = fbne.getType()) != null) {
            VarDeclaration typeVariable = type.getInterfaceList().getVariable(varDeclaration.getName());
            return typeVariable.isInOutVar() && typeVariable.isIsInput() != varDeclaration.isIsInput() ? typeVariable.getInOutVarOpposite() : typeVariable;
        }
        return varDeclaration;
    }

    private VarDeclarationAnnotations() {
        throw new UnsupportedOperationException("Helper class must not be instantiated");
    }
}

