/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.ui.refactoring;

import com.google.inject.Inject;
import org.eclipse.fordiac.ide.structuredtextcore.ui.refactoring.STCoreImportUpdater;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionDiffBuilder;
import org.eclipse.xtext.ide.serializer.hooks.IReferenceUpdaterContext;
import org.eclipse.xtext.ide.serializer.hooks.IUpdatableReference;
import org.eclipse.xtext.ide.serializer.impl.ReferenceUpdater;
import org.eclipse.xtext.ide.serializer.impl.RelatedResourcesProvider;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.serializer.tokens.SerializerScopeProviderBinding;
import org.eclipse.xtext.util.ITextRegion;

public class STCoreReferenceUpdater
extends ReferenceUpdater {
    @Inject
    private STCoreImportUpdater importUpdater;
    @Inject
    private IQualifiedNameConverter nameConverter;
    @Inject
    @SerializerScopeProviderBinding
    private IScopeProvider scopeProvider;

    protected void updateExternalReferences(IReferenceUpdaterContext context, RelatedResourcesProvider.RelatedResource relatedResource) {
        super.updateExternalReferences(context, relatedResource);
        context.modifyModel(() -> this.importUpdater.updateImports(context));
    }

    public void updateReference(ITextRegionDiffBuilder rewriter, IUpdatableReference upd) {
        ISemanticRegion region;
        QualifiedName oldName;
        IUpdatableReference updatable = upd;
        if (rewriter.isModified((ITextRegion)updatable.getReferenceRegion())) {
            return;
        }
        IScope scope = this.scopeProvider.getScope(updatable.getSourceEObject(), updatable.getEReference());
        IEObjectDescription oldDesc = scope.getSingleElement(oldName = this.nameConverter.toQualifiedName((region = updatable.getReferenceRegion()).getText()));
        if (oldDesc != null && oldDesc.getEObjectOrProxy() == updatable.getTargetEObject() && oldDesc.getName().equals((Object)oldName)) {
            return;
        }
        String newName = this.findValidName(updatable, scope);
        if (newName != null && !newName.equals(region.getText())) {
            rewriter.replace(region, newName);
        }
    }
}

