/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring;

import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.fordiac.ide.model.commands.change.ChangeImportNamespaceCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Import;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.fordiac.ide.typemanagement.refactoring.AbstractCommandChange;
import org.eclipse.gef.commands.Command;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class ImportChange
extends AbstractCommandChange<Import> {
    private final String newValue;
    private String oldValue;

    public ImportChange(String name, URI elementURI, String newValue) {
        super(name, elementURI, Import.class);
        this.newValue = newValue;
    }

    @Override
    protected Command createCommand(Import element) {
        return new ChangeImportNamespaceCommand(element, this.newValue);
    }

    @Override
    public void initializeValidationData(Import element, IProgressMonitor pm) {
        this.oldValue = element.getImportedNamespace();
    }

    @Override
    public RefactoringStatus isValid(Import element, IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        if (!Objects.equals(element.getImportedNamespace(), this.oldValue)) {
            status.addFatalError(Messages.ImportChange_ImportedNamespaceChanged);
        }
        return status;
    }
}

