/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.variable;

import org.eclipse.fordiac.ide.model.data.AnyBitType;
import org.eclipse.fordiac.ide.model.data.BoolType;
import org.eclipse.fordiac.ide.model.data.ByteType;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.DwordType;
import org.eclipse.fordiac.ide.model.data.LwordType;
import org.eclipse.fordiac.ide.model.data.WordType;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.value.ValueOperations;
import org.eclipse.fordiac.ide.model.eval.variable.AbstractVariable;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;

public class PartialVariable<T extends Value>
extends AbstractVariable<T> {
    private final Variable<?> delegate;
    private final int index;

    public PartialVariable(Variable<?> delegate, AnyBitType partial, int index) {
        super(delegate.getName() + ".%" + PartialVariable.getPartialName(partial) + index, (INamedElement)partial);
        this.delegate = delegate;
        this.index = index;
    }

    @Override
    public T getValue() {
        return (T)ValueOperations.partial(this.delegate.getValue(), (DataType)this.getType(), this.index);
    }

    @Override
    public void setValue(Value value) {
        this.delegate.setValue(ValueOperations.partial(this.delegate.getValue(), (DataType)this.getType(), this.index, value));
    }

    public AnyBitType getType() {
        return (AnyBitType)super.getType();
    }

    private static String getPartialName(AnyBitType type) {
        if (type instanceof BoolType) {
            return "X";
        }
        if (type instanceof ByteType) {
            return "B";
        }
        if (type instanceof WordType) {
            return "W";
        }
        if (type instanceof DwordType) {
            return "D";
        }
        if (type instanceof LwordType) {
            return "L";
        }
        return null;
    }
}

