/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.fordiac.ide.model.eval.EvaluatorException;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.ITypedElement;

public final class EvaluatorCache
implements AutoCloseable {
    private static final ThreadLocal<EvaluatorCache> threadCaches = ThreadLocal.withInitial(EvaluatorCache::new);
    private final AtomicInteger stackDepth = new AtomicInteger(0);
    private final Map<ITypedElement, Value> cachedInitialValues = new ConcurrentHashMap<ITypedElement, Value>();
    private final Map<ITypedElement, INamedElement> cachedResultType = new ConcurrentHashMap<ITypedElement, INamedElement>();

    private EvaluatorCache() {
    }

    public static EvaluatorCache open() {
        EvaluatorCache cache = threadCaches.get();
        cache.stackDepth.incrementAndGet();
        return cache;
    }

    @Override
    public void close() {
        if (this.stackDepth.decrementAndGet() == 0) {
            threadCaches.remove();
        }
    }

    public <K extends ITypedElement> Value computeInitialValueIfAbsent(K key, CacheFunction<? super K, ? extends Value> comp) throws EvaluatorException, InterruptedException {
        Value newValue;
        Value value = this.cachedInitialValues.get(key);
        if (value == null && (newValue = comp.apply(key)) != null) {
            Value oldValue = this.cachedInitialValues.putIfAbsent(key, newValue);
            if (oldValue != null) {
                return oldValue;
            }
            return newValue;
        }
        return value;
    }

    public <K extends ITypedElement> INamedElement computeResultTypeIfAbsent(K key, CacheFunction<? super K, ? extends INamedElement> comp) throws EvaluatorException, InterruptedException {
        INamedElement newType;
        INamedElement type = this.cachedResultType.get(key);
        if (type == null && (newType = comp.apply(key)) != null) {
            INamedElement oldType = this.cachedResultType.putIfAbsent(key, newType);
            if (oldType != null) {
                return oldType;
            }
            return newType;
        }
        return type;
    }

    @FunctionalInterface
    public static interface CacheFunction<T, R> {
        public R apply(T var1) throws EvaluatorException, InterruptedException;
    }
}

