/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval;

import java.io.Closeable;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.fordiac.ide.model.eval.DefaultEvaluatorDebugger;
import org.eclipse.fordiac.ide.model.eval.Evaluator;
import org.eclipse.fordiac.ide.model.eval.EvaluatorDebugger;
import org.eclipse.fordiac.ide.model.eval.EvaluatorMonitor;
import org.eclipse.fordiac.ide.model.eval.EvaluatorThread;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;

public abstract class AbstractEvaluator
implements Evaluator {
    private final Variable<?> context;
    private final Evaluator parent;

    protected AbstractEvaluator(Variable<?> context, Evaluator parent) {
        this.context = context;
        this.parent = parent;
    }

    @Override
    public Variable<?> getContext() {
        return this.context;
    }

    @Override
    public Evaluator getParent() {
        return this.parent;
    }

    protected <T> T trap(T context) throws InterruptedException {
        AbstractEvaluator.currentDebugger().trap(context, this);
        return context;
    }

    protected void info(String message) {
        AbstractEvaluator.currentMonitors().forEach(monitor -> monitor.info(message));
    }

    protected void warn(String message) {
        AbstractEvaluator.currentMonitors().forEach(monitor -> monitor.warn(message));
    }

    protected void error(String message) {
        AbstractEvaluator.currentMonitors().forEach(monitor -> monitor.error(message));
    }

    protected void error(String message, Throwable t) {
        AbstractEvaluator.currentMonitors().forEach(monitor -> monitor.error(message, t));
    }

    protected void update(Collection<? extends Variable<?>> variables) {
        AbstractEvaluator.currentMonitors().forEach(monitor -> monitor.update(variables, this));
    }

    public static EvaluatorDebugger currentDebugger() {
        Thread thread = Thread.currentThread();
        if (thread instanceof EvaluatorThread) {
            EvaluatorThread evaluatorThread = (EvaluatorThread)thread;
            return evaluatorThread.getExecutor().getDebugger();
        }
        return DefaultEvaluatorDebugger.INSTANCE;
    }

    public static Set<EvaluatorMonitor> currentMonitors() {
        Thread thread = Thread.currentThread();
        if (thread instanceof EvaluatorThread) {
            EvaluatorThread evaluatorThread = (EvaluatorThread)thread;
            return evaluatorThread.getExecutor().getMonitorSet();
        }
        return Collections.emptySet();
    }

    public static Map<String, Object> currentContext() {
        Thread thread = Thread.currentThread();
        if (thread instanceof EvaluatorThread) {
            EvaluatorThread evaluatorThread = (EvaluatorThread)thread;
            return evaluatorThread.getExecutor().getContext();
        }
        return Collections.emptyMap();
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, Closeable> getSharedResources() {
        void evaluatorThread;
        Thread thread = Thread.currentThread();
        if (!(thread instanceof EvaluatorThread)) {
            throw new IllegalStateException("Cannot get shared resources without evaluator thread");
        }
        EvaluatorThread evaluatorThread2 = (EvaluatorThread)thread;
        return evaluatorThread.getExecutor().getSharedResources();
    }

    public static Clock currentClock() {
        Thread thread = Thread.currentThread();
        if (thread instanceof EvaluatorThread) {
            EvaluatorThread evaluatorThread = (EvaluatorThread)thread;
            return evaluatorThread.getExecutor().getClock();
        }
        return MonotonicClock.UTC;
    }

    /*
     * WARNING - void declaration
     */
    public static void setClock(Clock clock) {
        void evaluatorThread;
        Thread thread = Thread.currentThread();
        if (!(thread instanceof EvaluatorThread)) {
            throw new IllegalStateException("Cannot set clock without evaluator thread");
        }
        EvaluatorThread evaluatorThread2 = (EvaluatorThread)thread;
        evaluatorThread.getExecutor().setClock(clock);
    }

    public static class MonotonicClock
    extends Clock {
        public static final MonotonicClock UTC = new MonotonicClock(ZoneOffset.UTC);
        private final ZoneId zone;

        public MonotonicClock(ZoneId zone) {
            this.zone = zone;
        }

        @Override
        public Instant instant() {
            long nanoTime = System.nanoTime();
            return Instant.ofEpochSecond(nanoTime / 1000000000L, nanoTime % 1000000000L);
        }

        @Override
        public Clock withZone(ZoneId zone) {
            return new MonotonicClock(zone);
        }

        @Override
        public ZoneId getZone() {
            return this.zone;
        }

        @Override
        public int hashCode() {
            return this.zone.hashCode();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object obj) {
            void other;
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof MonotonicClock)) {
                return false;
            }
            MonotonicClock monotonicClock = (MonotonicClock)obj;
            return Objects.equals(this.zone, other.zone);
        }

        public String toString() {
            return String.format("%s [zone=%s]", this.getClass().getName(), this.zone);
        }
    }
}

