/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.figures.ECStateToolTipFigure;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.preferences.FBTypeEditorPreferenceConstants;
import org.eclipse.fordiac.ide.gef.figures.HorizontalLineFigure;
import org.eclipse.fordiac.ide.gef.figures.InteractionStyleFigure;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.swt.graphics.Color;

public final class ECStateFigure
extends Figure
implements InteractionStyleFigure {
    private static final int STATE_ACTION_CONNECTOR_LENGTH = 15;
    private static final Insets STATE_INSET = new Insets(3, 6, 3, 6);
    private Label nameLabel;
    private final Figure stateActionConnector = new HorizontalLineFigure(15);
    private final Figure actionContainer = new Figure(){

        public void add(IFigure figure, Object constraint, int index) {
            super.add(figure, constraint, index);
            this.setConstraint(figure, new GridData(4, 1, true, false));
        }
    };

    public ECStateFigure(ECState state) {
        ToolbarLayout tbLayout = new ToolbarLayout();
        tbLayout.setStretchMinorAxis(false);
        tbLayout.setHorizontal(true);
        this.setLayoutManager((LayoutManager)tbLayout);
        Figure stateRect = ECStateFigure.createStateRectangle();
        stateRect.add((IFigure)this.createStateNameLabel(state));
        this.stateActionConnector.setForegroundColor(FBTypeEditorPreferenceConstants.getColor("ECCEditorStateTextColor"));
        stateRect.add((IFigure)this.stateActionConnector);
        this.add((IFigure)stateRect);
        this.createActionContainerFigure();
        this.createStateCommentToolTip();
    }

    private static Figure createStateRectangle() {
        Figure stateRect = new Figure();
        FlowLayout layout = new FlowLayout();
        layout.setStretchMinorAxis(true);
        layout.setMajorSpacing(0);
        layout.setMinorSpacing(0);
        layout.setHorizontal(true);
        layout.setMinorAlignment(0);
        stateRect.setLayoutManager((LayoutManager)layout);
        return stateRect;
    }

    private void createStateCommentToolTip() {
        ECStateToolTipFigure stateTooltip = new ECStateToolTipFigure();
        stateTooltip.setVisible(true);
        this.setToolTip((IFigure)stateTooltip);
    }

    private void createActionContainerFigure() {
        this.add((IFigure)this.actionContainer);
        GridLayout gl = new GridLayout(2, false);
        gl.horizontalSpacing = -1;
        gl.verticalSpacing = 1;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.actionContainer.setLayoutManager((LayoutManager)gl);
    }

    private Label createStateNameLabel(ECState state) {
        this.nameLabel = new Label(){

            public Insets getInsets() {
                if (this.getBorder() != null) {
                    return this.getBorder().getInsets((IFigure)this);
                }
                return STATE_INSET;
            }

            public void setBackgroundColor(Color bg) {
                if (this.getBorder() instanceof StartStateBorder) {
                    ((StartStateBorder)this.getBorder()).setColor(bg);
                } else {
                    super.setBackgroundColor(bg);
                }
            }
        };
        this.nameLabel.setText(state.getName());
        this.nameLabel.setForegroundColor(FBTypeEditorPreferenceConstants.getColor("ECCEditorStateTextColor"));
        this.nameLabel.setOpaque(true);
        if (state.isStartState()) {
            this.nameLabel.setBorder((Border)new StartStateBorder(FBTypeEditorPreferenceConstants.getColor("ECCEditorStateColor")));
        } else {
            this.nameLabel.setBackgroundColor(FBTypeEditorPreferenceConstants.getColor("ECCEditorStateColor"));
        }
        return this.nameLabel;
    }

    public ECStateToolTipFigure getToolTip() {
        return (ECStateToolTipFigure)super.getToolTip();
    }

    public void setHasAction(boolean hasAction) {
        this.stateActionConnector.setVisible(hasAction);
    }

    public Figure getContentPane() {
        return this.actionContainer;
    }

    public Label getNameLabel() {
        return this.nameLabel;
    }

    public Figure getLine() {
        return this.stateActionConnector;
    }

    public int getIntersectionStyle(Point location) {
        Rectangle bounds = this.nameLabel.getBounds().getCopy();
        bounds.x += 3;
        bounds.y += 3;
        bounds.width -= 6;
        bounds.height -= 6;
        if (bounds.intersects(new Rectangle(location, new Dimension(1, 1)))) {
            return 0;
        }
        return 1;
    }

    private static class StartStateBorder
    extends LineBorder {
        private static final int DOUBLE_BORDER_WIDTH = 4;
        private static final int START_STATE_INSET_SIZE = 2;
        private static final Insets START_STATE_INSET = new Insets(2);
        private static final Insets DOUBLE_BORDER_INSET = new Insets(4).add(START_STATE_INSET);

        public StartStateBorder(Color color) {
            this.setWidth(4);
            this.setColor(color);
        }

        public Insets getInsets(IFigure figure) {
            return DOUBLE_BORDER_INSET;
        }
    }
}

