/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.ui.handlers.internal;

import org.eclipse.fordiac.ide.ui.handlers.ErrorMessageHandler;
import org.eclipse.fordiac.ide.ui.preferences.UIPreferenceConstants;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class ErrorMessageDialog
extends PopupDialog {
    private static final int ERROR_TEXT_WIDTH_HINT = 400;
    private static final int MOUSE_CURSOR_OFFSET_Y = 10;
    private static final int MOUSE_CURSOR_OFFSET_X = 5;
    private static final Point MOUSE_CURSOR_OFFSET = new Point(5, 10);
    private final String errorMsg;
    private final int timeout;
    private final ErrorMessageHandler container;
    private final FocusListener lostFocusListener = new FocusListener(){

        public void focusLost(FocusEvent e) {
            ErrorMessageDialog.this.container.clearDialog((Composite)ErrorMessageDialog.this.getShell());
        }

        public void focusGained(FocusEvent e) {
        }
    };
    private final KeyListener keypressListener = new KeyListener(){

        public void keyReleased(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            ErrorMessageDialog.this.container.clearDialog((Composite)ErrorMessageDialog.this.getShell());
        }
    };
    private final SelectionListener selectionChangeListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            ErrorMessageDialog.this.container.clearDialog((Composite)ErrorMessageDialog.this.getShell());
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };

    protected Color getBackground() {
        return Display.getCurrent().getSystemColor(29);
    }

    protected Color getForeground() {
        return Display.getCurrent().getSystemColor(28);
    }

    public ErrorMessageDialog(Shell parent, ErrorMessageHandler container, String errorMsg, int timeout) {
        super(parent, 540676, false, false, false, false, false, null, null);
        this.errorMsg = errorMsg;
        this.timeout = timeout;
        this.container = container;
    }

    protected void adjustBounds() {
        super.adjustBounds();
        Point pt = this.getDialogPosition();
        Rectangle boundingBox = this.getShell().getBounds();
        boundingBox.x = pt.x;
        boundingBox.y = pt.y;
        this.getShell().setBounds(boundingBox);
    }

    public Point getDialogPosition() {
        Control focused = this.getShell().getDisplay().getFocusControl();
        Point pt = ErrorMessageDialog.isTextInput(focused) ? ErrorMessageDialog.getTextInputRelativeLocation(focused) : (ErrorMessageDialog.isTableInput(focused) ? ErrorMessageDialog.getTableRelativeLocation(focused) : this.getUnAttachedLocation());
        return pt;
    }

    private static Point getTextInputRelativeLocation(Control focused) {
        Rectangle elementBounds = focused.getDisplay().getBounds();
        return focused.toDisplay(new Point(elementBounds.x, elementBounds.y + focused.getSize().y));
    }

    private static Point getTableRelativeLocation(Control focused) {
        Table table = (Table)focused;
        TableItem ti = table.getItem(table.getSelectionIndex());
        Rectangle elementBounds = ti.getBounds();
        return focused.toDisplay(new Point(elementBounds.x, elementBounds.y + ti.getBounds().height));
    }

    private Point getUnAttachedLocation() {
        if (ErrorMessageDialog.showErrorAtMouse()) {
            return this.getMouseRelativeLocation();
        }
        return this.getBottomRightLocation();
    }

    public Point getMouseRelativeLocation() {
        Point pt = this.getShell().getDisplay().getCursorLocation();
        pt.x += ErrorMessageDialog.MOUSE_CURSOR_OFFSET.x;
        pt.y += ErrorMessageDialog.MOUSE_CURSOR_OFFSET.y;
        return pt;
    }

    public Point getBottomRightLocation() {
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
        if (win == null) {
            return this.getMouseRelativeLocation();
        }
        Rectangle parentBounds = win.getShell().getBounds();
        Point pt = new Point(parentBounds.x + parentBounds.width, parentBounds.y + parentBounds.height);
        Rectangle boundingBox = this.getShell().getBounds();
        pt.x -= boundingBox.width;
        pt.y -= boundingBox.height;
        return pt;
    }

    private static boolean isTextInput(Control focused) {
        return focused instanceof Text && ((Text)focused).getEditable();
    }

    private static boolean isTableInput(Control focused) {
        if (focused instanceof Table) {
            Table table = (Table)focused;
            return table.getSelectionCount() != 0 && table.getItem(table.getSelectionIndex()) != null;
        }
        return false;
    }

    protected Control createDialogArea(Composite parent) {
        Composite warningComposite = new Composite(parent, 0);
        warningComposite.setLayout((Layout)new GridLayout(2, false));
        warningComposite.setLayoutData((Object)new GridData(0, 0, true, true));
        Label image = new Label(warningComposite, 0);
        image.setImage(parent.getDisplay().getSystemImage(8));
        image.setLayoutData((Object)new GridData(4, 4, true, true));
        Label errorText = new Label(warningComposite, 64);
        errorText.setText(this.errorMsg);
        GridData errorTestLayoutData = new GridData(4, 0x1000000, true, true);
        errorTestLayoutData.widthHint = 400;
        errorText.setLayoutData((Object)errorTestLayoutData);
        Control focused = this.getShell().getDisplay().getFocusControl();
        if (ErrorMessageDialog.isTextInput(focused)) {
            this.clearPopupOnKeypress(focused);
            this.clearPopupOnLostFocus(focused);
        } else if (ErrorMessageDialog.isTableInput(focused)) {
            this.clearPopupOnKeypress(focused);
            this.clearPopupOnLostFocus(focused);
            this.clearPopupOnSelectionChange(focused);
        } else {
            this.clearPopupAfterTimeout(this.timeout);
        }
        return warningComposite;
    }

    private void clearPopupAfterTimeout(int t) {
        if (!this.container.isHovering()) {
            this.getShell().getDisplay().timerExec(t, () -> this.container.clearDialog((Composite)this.getShell()));
        }
    }

    private void clearPopupOnLostFocus(Control focused) {
        focused.removeFocusListener(this.lostFocusListener);
        focused.addFocusListener(this.lostFocusListener);
    }

    private void clearPopupOnKeypress(Control focused) {
        focused.removeKeyListener(this.keypressListener);
        focused.addKeyListener(this.keypressListener);
    }

    private void clearPopupOnSelectionChange(Control focused) {
        if (focused instanceof Table) {
            Table table = (Table)focused;
            table.removeSelectionListener(this.selectionChangeListener);
            table.addSelectionListener(this.selectionChangeListener);
        }
    }

    private static boolean showErrorAtMouse() {
        return UIPreferenceConstants.STORE.getBoolean("ShowErrorsAtMouseCursor");
    }
}

