/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.eval;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.deployment.eval.DeploymentEvaluatorConfiguration;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.DeviceTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.ResourceTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;

public class DeploymentEvaluatorConfigurationBuilder {
    public static final String RESOURCE_NAME_PREFIX = "EVAL_RES_";
    private static final String MGR_ID = "MGR_ID";
    private DeviceTypeEntry deviceType;
    private ResourceTypeEntry resourceType;
    private String deviceProfile;
    private String deviceMgrID;

    public DeploymentEvaluatorConfigurationBuilder(DeviceTypeEntry deviceType, ResourceTypeEntry resourceType) {
        this.deviceType = deviceType;
        this.resourceType = resourceType;
    }

    public static final DeploymentEvaluatorConfigurationBuilder withDefaults(TypeLibrary typeLibrary) {
        return DeploymentEvaluatorConfigurationBuilder.fromContext(Collections.emptyMap(), typeLibrary);
    }

    public static final DeploymentEvaluatorConfigurationBuilder fromContext(Map<String, Object> context, TypeLibrary typeLibrary) {
        return new DeploymentEvaluatorConfigurationBuilder(Objects.requireNonNull(DeploymentEvaluatorConfiguration.getDeviceType(context, typeLibrary), "No such device type"), Objects.requireNonNull(DeploymentEvaluatorConfiguration.getResourceType(context, typeLibrary), "No such resource type")).setDeviceProfile(DeploymentEvaluatorConfiguration.getDeviceProfile(context)).setDeviceMgrID(DeploymentEvaluatorConfiguration.getMgrID(context));
    }

    public Resource build() {
        Resource resource = LibraryElementFactory.eINSTANCE.createResource();
        resource.setName(RESOURCE_NAME_PREFIX + UUID.randomUUID().toString());
        resource.setTypeEntry((TypeEntry)this.resourceType);
        if (this.resourceType != null) {
            resource.getVarDeclarations().addAll(EcoreUtil.copyAll((Collection)this.resourceType.getType().getVarDeclaration()));
        }
        resource.setFBNetwork(LibraryElementFactory.eINSTANCE.createFBNetwork());
        resource.setDevice(this.createDevice());
        return resource;
    }

    public Device createDevice() {
        Device device = LibraryElementFactory.eINSTANCE.createDevice();
        device.setName(this.deviceType.getTypeName());
        device.setTypeEntry((TypeEntry)this.deviceType);
        device.setProfile(this.deviceProfile);
        device.getVarDeclarations().addAll(EcoreUtil.copyAll((Collection)this.deviceType.getType().getVarDeclaration()));
        if (this.deviceMgrID != null) {
            DeploymentEvaluatorConfigurationBuilder.setValue(device, MGR_ID, this.deviceMgrID);
        }
        return device;
    }

    protected static void setValue(Device device, String name, String value) {
        VarDeclaration varDeclaration = DeploymentEvaluatorConfigurationBuilder.getOrCreateVariable(device, name);
        if (varDeclaration.getValue() == null) {
            varDeclaration.setValue(LibraryElementFactory.eINSTANCE.createValue());
        }
        varDeclaration.getValue().setValue(value);
    }

    protected static VarDeclaration getOrCreateVariable(Device device, String name) {
        return device.getVarDeclarations().stream().filter(varDeclaration -> name.equals(varDeclaration.getName())).findAny().orElseGet(() -> {
            VarDeclaration varDeclaration = LibraryElementFactory.eINSTANCE.createVarDeclaration();
            device.getVarDeclarations().add((Object)varDeclaration);
            return varDeclaration;
        });
    }

    public DeviceTypeEntry getDeviceType() {
        return this.deviceType;
    }

    public DeploymentEvaluatorConfigurationBuilder setDeviceType(DeviceTypeEntry deviceType) {
        this.deviceType = Objects.requireNonNull(deviceType);
        return this;
    }

    public ResourceTypeEntry getResourceType() {
        return this.resourceType;
    }

    public DeploymentEvaluatorConfigurationBuilder setResourceType(ResourceTypeEntry resourceType) {
        this.resourceType = Objects.requireNonNull(resourceType);
        return this;
    }

    public String getDeviceProfile() {
        return this.deviceProfile;
    }

    public DeploymentEvaluatorConfigurationBuilder setDeviceProfile(String deviceProfile) {
        this.deviceProfile = deviceProfile;
        return this;
    }

    public String getDeviceMgrID() {
        return this.deviceMgrID;
    }

    public DeploymentEvaluatorConfigurationBuilder setDeviceMgrID(String deviceMgrID) {
        this.deviceMgrID = deviceMgrID;
        return this;
    }
}

